/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NameDefinition
implements OfficeConstants {
    private String name;
    private String definition;
    private String baseCellAddress;
    private boolean rangeType = false;
    private boolean expressionType = false;

    public NameDefinition() {
    }

    public NameDefinition(String string, String string2, String string3, boolean bl, boolean bl2) {
        this.name = string;
        this.definition = string2;
        this.baseCellAddress = string3;
        this.rangeType = bl;
        this.expressionType = bl2;
    }

    public NameDefinition(Node node) {
        this.readNode(node);
    }

    public String getBaseCellAddress() {
        return this.baseCellAddress;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getName() {
        return this.name;
    }

    public boolean isExpressionType() {
        return this.expressionType;
    }

    public boolean isRangeType() {
        return this.rangeType;
    }

    public void readNode(Node node) {
        String string = node.getNodeName();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (string.equals("table:named-range")) {
            Node node2 = namedNodeMap.getNamedItem("table:name");
            Node node3 = namedNodeMap.getNamedItem("table:base-cell-address");
            Node node4 = namedNodeMap.getNamedItem("table:cell-range-address");
            Debug.log(4, "Named-range : " + node2.getNodeValue());
            this.name = node2.getNodeValue();
            this.definition = node4.getNodeValue();
            this.baseCellAddress = node3.getNodeValue();
            this.expressionType = true;
            this.rangeType = false;
        } else if (string.equals("table:named-expression")) {
            Node node5 = namedNodeMap.getNamedItem("table:name");
            Node node6 = namedNodeMap.getNamedItem("table:base-cell-address");
            Node node7 = namedNodeMap.getNamedItem("table:expression");
            Debug.log(4, "Named-expression: " + node5.getNodeValue());
            this.name = node5.getNodeValue();
            this.definition = node7.getNodeValue();
            this.baseCellAddress = node6.getNodeValue();
            this.expressionType = false;
            this.rangeType = true;
        } else {
            Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(node) + " />");
        }
    }

    public void setDefinition(String string) {
        this.definition = string;
    }

    public void writeNode(Document document, Node node) {
        if (this.isRangeType()) {
            Debug.log(4, "Found Range Name : " + this.getName());
            Element element = document.createElement("table:named-range");
            element.setAttribute("table:name", this.getName());
            element.setAttribute("table:base-cell-address", this.getBaseCellAddress());
            element.setAttribute("table:cell-range-address", this.getDefinition());
            node.appendChild(element);
        } else if (this.isExpressionType()) {
            Debug.log(4, "Found Expression Name : " + this.getName());
            Element element = document.createElement("table:named-expression");
            element.setAttribute("table:name", this.getName());
            element.setAttribute("table:base-cell-address", this.getBaseCellAddress());
            element.setAttribute("table:expression", this.getDefinition());
            node.appendChild(element);
        } else {
            Debug.log(4, "Unknown Name Definition : " + this.getName());
        }
    }
}

