/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractCategoryItemRenderer;
import com.jrefinery.chart.CategoryPlot;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class AreaCategoryItemRenderer
extends AbstractCategoryItemRenderer {
    public AreaCategoryItemRenderer() {
        this(null, null);
    }

    public AreaCategoryItemRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D, Shape shape) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(double_);
    }

    public void drawCategoryItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, Object object, int n2, Object object2) {
        Number number = categoryDataset.getValue(n, object);
        if (number != null) {
            Object object3;
            double d = categoryPlot.getCategoryCoordinate(n2, rectangle2D);
            double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
            graphics2D.setPaint(categoryPlot.getSeriesPaint(n));
            graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
            if (object2 != null && (object3 = categoryDataset.getValue(n, object2)) != null) {
                double d3 = categoryPlot.getCategoryCoordinate(n2 - 1, rectangle2D);
                double d4 = valueAxis.translateValueToJava2D(((Number)object3).doubleValue(), rectangle2D);
                double d5 = valueAxis.translateValueToJava2D(0.0, rectangle2D);
                Polygon polygon = new Polygon();
                polygon.addPoint((int)d3, (int)d4);
                polygon.addPoint((int)d, (int)d2);
                polygon.addPoint((int)d, (int)d5);
                polygon.addPoint((int)d3, (int)d5);
                graphics2D.setPaint(categoryPlot.getSeriesPaint(n));
                graphics2D.setStroke(categoryPlot.getSeriesStroke(n));
                graphics2D.fill(polygon);
            }
            if (this.getInfo() != null) {
                object3 = this.getInfo().getEntityCollection();
                Rectangle2D.Double double_ = new Rectangle2D.Double(d - 3.0, d2 - 3.0, 6.0, 6.0);
                if (object3 != null && double_ != null) {
                    String string = null;
                    if (this.getToolTipGenerator() != null) {
                        string = this.getToolTipGenerator().generateToolTip(categoryDataset, n, object);
                    }
                    String string2 = null;
                    if (this.getURLGenerator() != null) {
                        string2 = this.getURLGenerator().generateURL(categoryDataset, n, object);
                    }
                    CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, n, object, n2);
                    object3.addEntity(categoryItemEntity);
                }
            }
        }
    }
}

