/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.LegendItemCollection;
import com.jrefinery.chart.Plot;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.needle.ArrowNeedle;
import com.jrefinery.chart.needle.LineNeedle;
import com.jrefinery.chart.needle.LongNeedle;
import com.jrefinery.chart.needle.MeterNeedle;
import com.jrefinery.chart.needle.PinNeedle;
import com.jrefinery.chart.needle.PlumNeedle;
import com.jrefinery.chart.needle.PointerNeedle;
import com.jrefinery.chart.needle.ShipNeedle;
import com.jrefinery.chart.needle.WindNeedle;
import com.jrefinery.data.DefaultMeterDataset;
import com.jrefinery.data.MeterDataset;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;

public class CompassPlot
extends Plot {
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    private int labelType;
    private Font labelFont;
    private boolean drawBorder = false;
    private Color roseHighlightColour = Color.black;
    private Color roseColour = Color.yellow;
    private Color roseCenterColour = Color.white;
    private Font compassFont = new Font("Arial", 0, 10);
    private Ellipse2D.Double circle1;
    private Ellipse2D.Double circle2;
    private Area a1;
    private Area a2;
    private Area a3;
    private Area a4;
    private Area needleArea;
    private Rectangle2D rect1;
    private MeterDataset[] datasets = new MeterDataset[1];
    private MeterNeedle[] seriesNeedle = new MeterNeedle[1];

    public CompassPlot() {
        this(new DefaultMeterDataset());
    }

    public CompassPlot(MeterDataset meterDataset) {
        this(meterDataset, Plot.DEFAULT_INSETS, Plot.DEFAULT_BACKGROUND_PAINT, null, 1.0f, Plot.DEFAULT_OUTLINE_STROKE, Plot.DEFAULT_OUTLINE_PAINT, 1.0f);
    }

    public CompassPlot(MeterDataset meterDataset, Insets insets, Paint paint, Image image, float f, Stroke stroke, Paint paint2, float f2) {
        super(meterDataset, insets, paint, image, f, stroke, paint2, f2);
        if (meterDataset != null) {
            this.datasets[0] = meterDataset;
            meterDataset.addChangeListener(this);
        }
        this.setInsets(insets);
        this.circle1 = new Ellipse2D.Double();
        this.circle2 = new Ellipse2D.Double();
        this.rect1 = new Rectangle2D.Double();
        this.setSeriesNeedle(0);
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.labelType != n) {
            this.labelType = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("MeterPlot.setLabelFont(...): null font not allowed.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public void setSeriesPaint(int n, Paint paint) {
        super.setSeriesPaint(n, paint);
        if (n >= 0 && n < this.seriesNeedle.length) {
            this.seriesNeedle[n].setFillPaint(paint);
        }
    }

    public void setSeriesOutlinePaint(int n, Paint paint) {
        if (n >= 0 && n < this.seriesNeedle.length) {
            this.seriesNeedle[n].setOutlinePaint(paint);
        }
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        super.setSeriesOutlineStroke(n, stroke);
        if (n >= 0 && n < this.seriesNeedle.length) {
            this.seriesNeedle[n].setOutlineStroke(stroke);
        }
    }

    public void setSeriesNeedle(int n) {
        this.setSeriesNeedle(0, n);
    }

    public void setSeriesNeedle(int n, int n2) {
        switch (n2) {
            case 0: {
                this.setSeriesNeedle(n, new ArrowNeedle(true));
                this.setSeriesPaint(n, Color.red);
                this.seriesNeedle[n].setHighlightPaint(Color.white);
                break;
            }
            case 1: {
                this.setSeriesNeedle(n, new LineNeedle());
                break;
            }
            case 2: {
                this.setSeriesNeedle(n, new LongNeedle());
                break;
            }
            case 3: {
                this.setSeriesNeedle(n, new PinNeedle());
                break;
            }
            case 4: {
                this.setSeriesNeedle(n, new PlumNeedle());
                break;
            }
            case 5: {
                this.setSeriesNeedle(n, new PointerNeedle());
                break;
            }
            case 6: {
                this.setSeriesPaint(n, null);
                this.setSeriesOutlineStroke(n, new BasicStroke(3.0f));
                this.setSeriesNeedle(n, new ShipNeedle());
                break;
            }
            case 7: {
                this.setSeriesPaint(n, Color.blue);
                this.setSeriesNeedle(n, new WindNeedle());
                break;
            }
            case 8: {
                this.setSeriesNeedle(n, new ArrowNeedle(true));
            }
        }
    }

    public void setSeriesNeedle(int n, MeterNeedle meterNeedle) {
        if (meterNeedle != null && n < this.seriesNeedle.length) {
            this.seriesNeedle[n] = meterNeedle;
        }
    }

    public MeterDataset[] getData() {
        return this.datasets;
    }

    public void addData(MeterDataset meterDataset) {
        this.addData(meterDataset, null);
    }

    public void addData(MeterDataset meterDataset, MeterNeedle meterNeedle) {
        if (meterDataset != null) {
            int n = this.datasets.length + 1;
            MeterDataset[] meterDatasetArray = new MeterDataset[n];
            MeterNeedle[] meterNeedleArray = new MeterNeedle[n];
            n -= 2;
            while (n >= 0) {
                meterDatasetArray[n] = this.datasets[n];
                meterNeedleArray[n] = this.seriesNeedle[n];
                --n;
            }
            n = this.datasets.length;
            meterDatasetArray[n] = meterDataset;
            meterNeedleArray[n] = meterNeedle != null ? meterNeedle : meterNeedleArray[n - 1];
            MeterDataset[] meterDatasetArray2 = this.datasets;
            MeterNeedle[] meterNeedleArray2 = this.seriesNeedle;
            this.datasets = meterDatasetArray;
            this.seriesNeedle = meterNeedleArray;
            --n;
            while (n >= 0) {
                meterDatasetArray2[n] = null;
                meterNeedleArray2[n] = null;
                --n;
            }
            meterDataset.addChangeListener(this);
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Serializable serializable;
        int n;
        double d;
        int n2 = 0;
        int n3 = 0;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if (this.insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        if (this.drawBorder) {
            this.drawOutlineAndBackground(graphics2D, rectangle2D);
        }
        int n4 = (int)(rectangle2D.getWidth() / 2.0);
        int n5 = (int)(rectangle2D.getHeight() / 2.0);
        int n6 = n4;
        if (n5 < n4) {
            n6 = n5;
        }
        int n7 = 2 * --n6;
        this.circle1.setFrame((n4 += (int)rectangle2D.getMinX()) - n6, (n5 += (int)rectangle2D.getMinY()) - n6, n7, n7);
        this.circle2.setFrame(n4 - n6 + 15, n5 - n6 + 15, n7 - 30, n7 - 30);
        graphics2D.setColor(this.roseColour);
        this.a1 = new Area(this.circle1);
        this.a2 = new Area(this.circle2);
        this.a1.subtract(this.a2);
        graphics2D.fill(this.a1);
        graphics2D.setColor(this.roseCenterColour);
        int n8 = n7 - 30;
        graphics2D.fillOval(n4 - n6 + 15, n5 - n6 + 15, n8, n8);
        graphics2D.setColor(this.roseHighlightColour);
        graphics2D.drawOval(n4 - n6, n5 - n6, n7, n7);
        n8 = n7 - 20;
        graphics2D.drawOval(n4 - n6 + 10, n5 - n6 + 10, n8, n8);
        n8 = n7 - 30;
        graphics2D.drawOval(n4 - n6 + 15, n5 - n6 + 15, n8, n8);
        n8 = n7 - 80;
        graphics2D.drawOval(n4 - n6 + 40, n5 - n6 + 40, n8, n8);
        n2 = n6 - 20;
        n3 = n6 - 32;
        int n9 = 0;
        while (n9 < 360) {
            d = Math.toRadians(n9);
            n8 = n4 - (int)(Math.sin(d) * (double)n3);
            int n10 = n4 - (int)(Math.sin(d) * (double)n2);
            n = n5 - (int)(Math.cos(d) * (double)n3);
            int n11 = n5 - (int)(Math.cos(d) * (double)n2);
            graphics2D.drawLine(n8, n, n10, n11);
            n9 += 15;
        }
        graphics2D.setColor(this.roseHighlightColour);
        n3 = n6 - 26;
        n2 = 7;
        int n12 = 45;
        while (n12 < 360) {
            d = Math.toRadians(n12);
            n8 = n4 - (int)(Math.sin(d) * (double)n3);
            n = n5 - (int)(Math.cos(d) * (double)n3);
            graphics2D.fillOval(n8 - n2, n - n2, 2 * n2, 2 * n2);
            n12 += 90;
        }
        int n13 = 0;
        while (n13 < 360) {
            d = Math.toRadians(n13);
            n8 = n4 - (int)(Math.sin(d) * (double)n3);
            n = n5 - (int)(Math.cos(d) * (double)n3);
            serializable = new Polygon();
            ((Polygon)serializable).addPoint(n8 - n2, n);
            ((Polygon)serializable).addPoint(n8, n + n2);
            ((Polygon)serializable).addPoint(n8 + n2, n);
            ((Polygon)serializable).addPoint(n8, n - n2);
            graphics2D.fillPolygon((Polygon)serializable);
            n13 += 90;
        }
        n3 = n6 - 42;
        serializable = this.getCompassFont(n6);
        graphics2D.setFont((Font)serializable);
        graphics2D.drawString("N", n4 - 5, n5 - n3 + ((Font)serializable).getSize());
        graphics2D.drawString("S", n4 - 5, n5 + n3 - 5);
        graphics2D.drawString("W", n4 - n3 + 5, n5 + 5);
        graphics2D.drawString("E", n4 + n3 - ((Font)serializable).getSize(), n5 + 5);
        n = n6 / 2;
        n8 = n6 / 6;
        Rectangle2D.Double double_ = new Rectangle2D.Double(n4 - n8, n5 - n, 2 * n8, 2 * n);
        int n14 = this.seriesNeedle.length;
        int n15 = 0;
        double d2 = 0.0;
        int n16 = this.datasets.length - 1;
        while (n16 >= 0) {
            MeterDataset meterDataset = this.datasets[n16];
            if (meterDataset != null && meterDataset.isValueValid()) {
                d2 = meterDataset.getValue().doubleValue() % 360.0;
                n15 = n16 % n14;
                this.seriesNeedle[n15].draw(graphics2D, double_, d2);
            }
            --n16;
        }
    }

    public String getPlotType() {
        return "Compass Plot";
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis == null;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis == null;
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void zoom(double d) {
    }

    protected Font getCompassFont(int n) {
        float f = n / 10;
        if (f < 8.0f) {
            f = 8.0f;
        }
        Font font = this.compassFont.deriveFont(f);
        return font;
    }

    public List getLegendItemLabels() {
        return null;
    }
}

