/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.CombinedXYPlot;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalXYBarRenderer;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.tooltips.TimeSeriesToolTipGenerator;
import com.jrefinery.data.BasicTimeSeries;
import com.jrefinery.data.Day;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimeSeriesCollection;
import com.jrefinery.data.XYDataset;
import com.jrefinery.ui.ApplicationFrame;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;

public class PriceVolumeDemo
extends ApplicationFrame {
    static /* synthetic */ Class class$com$jrefinery$data$Day;

    public PriceVolumeDemo(String string) {
        super(string);
        JFreeChart jFreeChart = this.createCombinedChart();
        ChartPanel chartPanel = new ChartPanel(jFreeChart, true, true, true, false, true);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createCombinedChart() {
        XYDataset xYDataset = this.createPriceDataset();
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        standardXYItemRenderer.setToolTipGenerator(new TimeSeriesToolTipGenerator("d-MMM-yyyy", "0.00"));
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis("Price");
        verticalNumberAxis.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, null, verticalNumberAxis, standardXYItemRenderer);
        IntervalXYDataset intervalXYDataset = this.createVolumeDataset();
        VerticalXYBarRenderer verticalXYBarRenderer = new VerticalXYBarRenderer(0.2);
        verticalXYBarRenderer.setToolTipGenerator(new TimeSeriesToolTipGenerator("d-MMM-yyyy", "0.00"));
        XYPlot xYPlot2 = new XYPlot(intervalXYDataset, null, new VerticalNumberAxis("Volume"), verticalXYBarRenderer);
        xYPlot2.setSeriesPaint(0, Color.blue);
        CombinedXYPlot combinedXYPlot = new CombinedXYPlot(new HorizontalDateAxis("Date"), 1);
        combinedXYPlot.add(xYPlot, 3);
        combinedXYPlot.add(xYPlot2, 1);
        return new JFreeChart("Price / Volume Example", JFreeChartConstants.DEFAULT_TITLE_FONT, combinedXYPlot, true);
    }

    private XYDataset createPriceDataset() {
        BasicTimeSeries basicTimeSeries = new BasicTimeSeries("Price", class$com$jrefinery$data$Day == null ? (class$com$jrefinery$data$Day = PriceVolumeDemo.class$("com.jrefinery.data.Day")) : class$com$jrefinery$data$Day);
        basicTimeSeries.add((TimePeriod)new Day(1, 3, 2002), 12353.3);
        basicTimeSeries.add((TimePeriod)new Day(4, 3, 2002), 13984.3);
        basicTimeSeries.add((TimePeriod)new Day(5, 3, 2002), 12999.4);
        basicTimeSeries.add((TimePeriod)new Day(6, 3, 2002), 14274.3);
        basicTimeSeries.add((TimePeriod)new Day(7, 3, 2002), 15943.5);
        basicTimeSeries.add((TimePeriod)new Day(8, 3, 2002), 14845.3);
        basicTimeSeries.add((TimePeriod)new Day(11, 3, 2002), 17232.3);
        basicTimeSeries.add((TimePeriod)new Day(12, 3, 2002), 14232.2);
        basicTimeSeries.add((TimePeriod)new Day(13, 3, 2002), 13102.2);
        basicTimeSeries.add((TimePeriod)new Day(14, 3, 2002), 14230.2);
        basicTimeSeries.add((TimePeriod)new Day(15, 3, 2002), 11435.2);
        basicTimeSeries.add((TimePeriod)new Day(18, 3, 2002), 14525.3);
        basicTimeSeries.add((TimePeriod)new Day(19, 3, 2002), 13984.3);
        basicTimeSeries.add((TimePeriod)new Day(20, 3, 2002), 12999.4);
        basicTimeSeries.add((TimePeriod)new Day(21, 3, 2002), 14274.3);
        basicTimeSeries.add((TimePeriod)new Day(22, 3, 2002), 15943.5);
        basicTimeSeries.add((TimePeriod)new Day(25, 3, 2002), 16234.6);
        basicTimeSeries.add((TimePeriod)new Day(26, 3, 2002), 17232.3);
        basicTimeSeries.add((TimePeriod)new Day(27, 3, 2002), 14232.2);
        basicTimeSeries.add((TimePeriod)new Day(28, 3, 2002), 13102.2);
        return new TimeSeriesCollection(basicTimeSeries);
    }

    private IntervalXYDataset createVolumeDataset() {
        BasicTimeSeries basicTimeSeries = new BasicTimeSeries("Volume", class$com$jrefinery$data$Day == null ? (class$com$jrefinery$data$Day = PriceVolumeDemo.class$("com.jrefinery.data.Day")) : class$com$jrefinery$data$Day);
        basicTimeSeries.add((TimePeriod)new Day(1, 3, 2002), 500.0);
        basicTimeSeries.add((TimePeriod)new Day(4, 3, 2002), 100.0);
        basicTimeSeries.add((TimePeriod)new Day(5, 3, 2002), 350.0);
        basicTimeSeries.add((TimePeriod)new Day(6, 3, 2002), 975.0);
        basicTimeSeries.add((TimePeriod)new Day(7, 3, 2002), 675.0);
        basicTimeSeries.add((TimePeriod)new Day(8, 3, 2002), 525.0);
        basicTimeSeries.add((TimePeriod)new Day(11, 3, 2002), 675.0);
        basicTimeSeries.add((TimePeriod)new Day(12, 3, 2002), 700.0);
        basicTimeSeries.add((TimePeriod)new Day(13, 3, 2002), 250.0);
        basicTimeSeries.add((TimePeriod)new Day(14, 3, 2002), 225.0);
        basicTimeSeries.add((TimePeriod)new Day(15, 3, 2002), 425.0);
        basicTimeSeries.add((TimePeriod)new Day(18, 3, 2002), 600.0);
        basicTimeSeries.add((TimePeriod)new Day(19, 3, 2002), 300.0);
        basicTimeSeries.add((TimePeriod)new Day(20, 3, 2002), 325.0);
        basicTimeSeries.add((TimePeriod)new Day(21, 3, 2002), 925.0);
        basicTimeSeries.add((TimePeriod)new Day(22, 3, 2002), 525.0);
        basicTimeSeries.add((TimePeriod)new Day(25, 3, 2002), 775.0);
        basicTimeSeries.add((TimePeriod)new Day(26, 3, 2002), 725.0);
        basicTimeSeries.add((TimePeriod)new Day(27, 3, 2002), 125.0);
        basicTimeSeries.add((TimePeriod)new Day(28, 3, 2002), 150.0);
        return new TimeSeriesCollection(basicTimeSeries);
    }

    public static void main(String[] stringArray) {
        PriceVolumeDemo priceVolumeDemo = new PriceVolumeDemo("Price Volume Chart Demo");
        priceVolumeDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)priceVolumeDemo));
        priceVolumeDemo.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

