/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.needle;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class MeterNeedle {
    protected Paint outlinePaint = Color.black;
    protected Stroke outlineStroke = new BasicStroke(2.0f);
    protected Paint fillPaint = null;
    protected Paint highlightPaint = null;
    protected int size = 5;
    protected double rotateX = 0.5;
    protected double rotateY = 0.5;
    protected static AffineTransform t = new AffineTransform();
    private static final double ANGLE180 = Math.toRadians(180.0);

    public MeterNeedle() {
    }

    public MeterNeedle(Paint paint, Paint paint2, Paint paint3) {
        this.fillPaint = paint2;
        this.highlightPaint = paint3;
        this.outlinePaint = paint;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.draw(graphics2D, rectangle2D, 0.0);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, double d) {
        Point2D.Double double_ = new Point2D.Double();
        double_.setLocation(rectangle2D.getMinX() + this.rotateX * rectangle2D.getWidth(), rectangle2D.getMinY() + this.rotateY * rectangle2D.getHeight());
        this.draw(graphics2D, rectangle2D, double_, d);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, double d) {
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        this.drawNeedle(graphics2D, rectangle2D, point2D, Math.toRadians(d));
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(color);
    }

    protected abstract void drawNeedle(Graphics2D var1, Rectangle2D var2, Point2D var3, double var4);

    public void setOutlinePaint(Paint paint) {
        if (paint != null) {
            this.outlinePaint = paint;
        }
    }

    protected void defaultDisplay(Graphics2D graphics2D, Shape shape) {
        if (this.fillPaint != null) {
            graphics2D.setPaint(this.fillPaint);
            graphics2D.fill(shape);
        }
        if (this.outlinePaint != null) {
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.draw(shape);
        }
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke != null) {
            this.outlineStroke = stroke;
        }
    }

    public void setFillPaint(Paint paint) {
        if (paint != null) {
            this.fillPaint = paint;
        }
    }

    public void setHighlightPaint(Paint paint) {
        if (paint != null) {
            this.highlightPaint = paint;
        }
    }

    public void setSize(int n) {
        this.size = n;
    }
}

