/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.tooltips;

import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import java.text.DateFormat;
import java.text.NumberFormat;

public class IntervalCategoryToolTipGenerator
implements CategoryToolTipGenerator {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;

    public IntervalCategoryToolTipGenerator() {
        this(NumberFormat.getInstance());
    }

    public IntervalCategoryToolTipGenerator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.dateFormat = null;
    }

    public IntervalCategoryToolTipGenerator(DateFormat dateFormat) {
        this.numberFormat = null;
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String generateToolTip(CategoryDataset categoryDataset, int n, Object object) {
        Object object2;
        Number number;
        Number number2 = number = categoryDataset.getValue(n, object);
        Number number3 = number;
        if (categoryDataset instanceof IntervalCategoryDataset) {
            object2 = (IntervalCategoryDataset)categoryDataset;
            number2 = object2.getStartValue(n, object);
            number3 = object2.getEndValue(n, object);
        }
        object2 = "";
        if (number2 != null && number3 != null) {
            String string = categoryDataset.getSeriesName(n);
            if (string != null) {
                object2 = (String)object2 + string + ", ";
            }
            String string2 = object.toString();
            String string3 = null;
            String string4 = null;
            if (this.numberFormat != null) {
                string3 = this.numberFormat.format(number2);
                string4 = this.numberFormat.format(number3);
            } else if (this.dateFormat != null) {
                string3 = this.dateFormat.format(number2);
                string4 = this.dateFormat.format(number3);
            }
            object2 = (String)object2 + string2 + " : " + string3 + " to " + string4;
        }
        return object2;
    }
}

