/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.ColumnRowInfo;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetDecoder;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.CellValue;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.ColInfo;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefinedName;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.ExtendedFormat;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.FloatNumber;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.FontDescription;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Formula;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Row;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Worksheet;
import org.openoffice.xmerge.util.Debug;

final class PocketExcelDecoder
extends SpreadsheetDecoder {
    private Workbook wb;
    private Worksheet ws;
    private CellValue cell;
    private int maxRows = 0;
    private int maxCols = 0;
    private int wsIndex;
    private Enumeration cellValue;
    private Format fmt = new Format();

    PocketExcelDecoder(String string, String[] stringArray, String string2) throws IOException {
        super(string, string2);
    }

    public void addDeviceContent(ConvertData convertData) throws IOException {
        Enumeration enumeration = convertData.getDocumentEnumeration();
        this.wb = (Workbook)enumeration.nextElement();
    }

    public String getCellContents() {
        String string;
        block3: {
            string = new String("");
            if (this.cell == null) break block3;
            try {
                string = this.cell.getString();
                if (string.startsWith("=")) {
                    string = this.parseFormula(string);
                }
            }
            catch (IOException iOException) {
                System.err.println("Could Not retrieve Cell contents");
                System.err.println("Setting contents of cell(" + this.cell.getRow() + "," + this.cell.getCol() + ") to an empty string");
                System.err.println("Error msg: " + iOException.getMessage());
            }
        }
        return string;
    }

    public String getCellDataType() {
        String string = "string";
        if (this.cell instanceof FloatNumber) {
            string = "float";
        }
        if (this.cell instanceof Formula) {
            string = "float";
        }
        return string;
    }

    public Format getCellFormat() {
        return new Format(this.fmt);
    }

    public String getCellValue() {
        String string;
        block2: {
            string = new String("");
            if (this.cell == null) break block2;
            try {
                string = ((Formula)this.cell).getValue();
            }
            catch (IOException iOException) {
                System.err.println("Could Not retrieve Cell value");
                System.err.println("Setting value of cell(" + this.cell.getRow() + "," + this.cell.getCol() + ") to an empty string");
                System.err.println("Error msg: " + iOException.getMessage());
            }
        }
        return string;
    }

    public int getColNumber() {
        int n = -1;
        if (this.cell != null) {
            n = this.cell.getCol();
            Debug.log((int)4, (String)("cell col is " + n));
        }
        return n;
    }

    public Enumeration getColumnRowInfos() {
        Object object;
        Vector<ColumnRowInfo> vector = new Vector<ColumnRowInfo>();
        Enumeration enumeration = this.ws.getColInfos();
        while (enumeration.hasMoreElements()) {
            object = (ColInfo)enumeration.nextElement();
            int n = ((ColInfo)object).getLast() - ((ColInfo)object).getFirst() + 1;
            ColumnRowInfo columnRowInfo = new ColumnRowInfo((int)((ColInfo)object).getColWidth(), n, 1);
            vector.add(columnRowInfo);
        }
        object = this.ws.getRows();
        while (object.hasMoreElements()) {
            Row row = (Row)object.nextElement();
            short s = row.getRowNumber();
            ColumnRowInfo columnRowInfo = new ColumnRowInfo((int)row.getRowHeight(), (int)s, 2);
            vector.add(columnRowInfo);
        }
        Debug.log((int)4, (String)("Getting " + vector.size() + " ColRowInfo records"));
        return vector.elements();
    }

    public Enumeration getNameDefinitions() {
        Enumeration enumeration = this.wb.getDefinedNames();
        Vector<NameDefinition> vector = new Vector<NameDefinition>();
        while (enumeration.hasMoreElements()) {
            DefinedName definedName = (DefinedName)enumeration.nextElement();
            NameDefinition nameDefinition = definedName.getNameDefinition();
            vector.add(nameDefinition);
        }
        Debug.log((int)4, (String)("Getting " + vector.size() + " DefinedName records"));
        return vector.elements();
    }

    public int getNumberOfColumns() {
        return this.maxCols;
    }

    public int getNumberOfRows() {
        return this.maxRows;
    }

    public int getNumberOfSheets() {
        Vector vector = this.wb.getWorksheetNames();
        Debug.log((int)4, (String)("Total Number of Sheets : " + vector.size()));
        return vector.size();
    }

    public int getRowNumber() {
        int n = -1;
        if (this.cell != null) {
            n = this.cell.getRow();
            Debug.log((int)4, (String)("cell row is " + n));
        }
        return n;
    }

    public BookSettings getSettings() {
        return this.wb.getSettings();
    }

    public String getSheetName() {
        String string = this.wb.getSheetName(this.wsIndex);
        Debug.log((int)4, (String)("The name of the current Worksheet is : " + string));
        return string;
    }

    public boolean goToNextCell() throws IOException {
        boolean bl = false;
        try {
            this.cell = (CellValue)this.cellValue.nextElement();
            Debug.log((int)4, (String)("Current Cell : " + this.cell.getString()));
            this.readCellFormat();
            bl = true;
        }
        catch (NoSuchElementException noSuchElementException) {
            Debug.log((int)4, (String)"Could't find current cell");
        }
        return bl;
    }

    protected String parseFormula(String string) {
        string = string.replace(',', ';');
        string = string.replace('!', '.');
        return string;
    }

    private void readCellFormat() throws IOException {
        this.fmt.clearFormatting();
        Debug.log((int)4, (String)(" ixfe for Current Cell " + this.cell.getIxfe()));
        ExtendedFormat extendedFormat = this.wb.getExtendedFormat(this.cell.getIxfe());
        Debug.log((int)4, (String)(" ixfnt for Current Cell " + extendedFormat.getFontIndex()));
        FontDescription fontDescription = this.wb.getFontDescription(extendedFormat.getFontIndex());
        this.fmt.setAttribute(2, fontDescription.isItalic());
        this.fmt.setAttribute(1, fontDescription.isBold());
        this.fmt.setAttribute(4, fontDescription.isUnderline());
        this.fmt.setForeground(fontDescription.getForeground());
        this.fmt.setBackground(extendedFormat.getBackground());
        this.fmt.setAlign(extendedFormat.getAlign());
        this.fmt.setVertAlign(extendedFormat.getVertAlign());
        this.fmt.setAttribute(1024, extendedFormat.isWordWrap());
        this.fmt.setAttribute(256, extendedFormat.isBorder(1));
        this.fmt.setAttribute(512, extendedFormat.isBorder(4));
        this.fmt.setAttribute(128, extendedFormat.isBorder(8));
        this.fmt.setAttribute(64, extendedFormat.isBorder(2));
        this.fmt.setFontName(fontDescription.getFont());
        this.fmt.setFontSize(fontDescription.getFontSize());
        this.fmt.setCategory(this.getCellDataType());
    }

    public void setWorksheet(int n) throws IOException {
        Debug.log((int)4, (String)("Setting to worksheet : " + n));
        this.ws = this.wb.getWorksheet(n);
        this.cellValue = this.ws.getCellEnumerator();
        this.wsIndex = n;
        while (this.goToNextCell()) {
            this.maxRows = Math.max(this.maxRows, this.cell.getRow());
            this.maxCols = Math.max(this.maxCols, this.cell.getCol());
        }
        this.cellValue = this.ws.getCellEnumerator();
        Debug.log((int)4, (String)("Max Cols : " + this.maxCols + " MaxRows : " + this.maxRows));
    }
}

