/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula;

import java.util.Vector;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.FormulaParsingException;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.formula.TokenFactory;
import org.openoffice.xmerge.util.Debug;

public class FormulaParser {
    private char look;
    private String formulaStr;
    private int index = 1;
    private TokenFactory tokenFactory;
    private Vector tokenVector;
    private Workbook wb;

    public FormulaParser() {
        Debug.log((int)4, (String)"Creating a Formula Parser");
        this.tokenFactory = new TokenFactory();
        this.tokenVector = new Vector();
    }

    private void addOp(String string) throws FormulaParsingException {
        this.match(string);
        this.tokenVector.add(this.tokenFactory.getOperatorToken(string, 2));
        this.term();
    }

    private int arguments() throws FormulaParsingException {
        this.skipWhite();
        int n = this.look == ')' ? 0 : 1;
        while (this.look != ')') {
            this.expression();
            if (this.look != ',') continue;
            ++n;
            this.match(',');
            this.tokenVector.add(this.tokenFactory.getOperatorToken(",", 1));
        }
        return n;
    }

    private void expression() throws FormulaParsingException {
        if (this.look == '\"') {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            bl = this.getChar();
            while (this.look != '\"' && bl) {
                stringBuffer.append(this.look);
                bl = this.getChar();
            }
            if (this.look != '\"') {
                throw new FormulaParsingException("Expected closing quote." + this.makeErrorString());
            }
            this.tokenVector.add(this.tokenFactory.getOperandToken(stringBuffer.toString(), "STRING"));
            this.getChar();
        } else {
            this.term();
        }
        while (this.isAddOp(this.look) || this.isLogicalOp()) {
            if (this.isAddOp(this.look)) {
                this.addOp(Character.toString(this.look));
                continue;
            }
            if (!this.isLogicalOp()) continue;
            this.logicalOp();
        }
    }

    private void factor() throws FormulaParsingException {
        if (this.isAddOp(this.look)) {
            Character c = new Character(this.look);
            this.match(this.look);
            this.tokenVector.add(this.tokenFactory.getOperatorToken(c.toString(), 1));
        }
        if (this.look == '(') {
            this.match('(');
            this.tokenVector.add(this.tokenFactory.getOperatorToken("(", 1));
            this.expression();
            this.match(')');
            this.tokenVector.add(this.tokenFactory.getOperatorToken(")", 1));
        } else if (this.isDigit(this.look)) {
            this.getNum();
        } else {
            this.ident();
        }
    }

    private boolean getChar() throws FormulaParsingException {
        boolean bl = true;
        if (this.index < this.formulaStr.length()) {
            this.look = this.formulaStr.charAt(this.index);
            ++this.index;
            if (this.look == ',') {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private String getLogicalOperator() throws FormulaParsingException {
        boolean bl;
        String string = new String();
        do {
            string = String.valueOf(string) + this.look;
            bl = this.getChar();
        } while (this.isLogicalOpChar(this.look) && bl);
        this.skipWhite();
        return string;
    }

    private void getNum() throws FormulaParsingException {
        boolean bl;
        Debug.log((int)4, (String)"getNum : ");
        if (!this.isDigit(this.look)) {
            throw new FormulaParsingException("Expected Integer" + this.makeErrorString());
        }
        String string = new String();
        do {
            string = String.valueOf(string) + this.look;
            bl = this.getChar();
        } while ((this.isDigit(this.look) || this.look == '.' && this.isDigit(this.formulaStr.charAt(this.index))) && bl);
        this.skipWhite();
        this.tokenVector.add(this.tokenFactory.getOperandToken(string, "INTEGER"));
        if (this.isPercent(this.look)) {
            this.match(this.look);
            this.tokenVector.add(this.tokenFactory.getOperatorToken("%", 1));
            Debug.log((int)4, (String)"Added Percent token to Vector: ");
        }
        Debug.log((int)4, (String)("Number parsed : " + string));
    }

    private String getTokenString() throws FormulaParsingException {
        boolean bl;
        if (!this.isAlpha(this.look) && this.look != '$') {
            throw new FormulaParsingException("Expected Cell Reference" + this.makeErrorString());
        }
        String string = new String();
        do {
            string = String.valueOf(string) + this.look;
            bl = this.getChar();
        } while (this.isCellRefChar(this.look) && bl);
        this.skipWhite();
        return string;
    }

    private void ident() throws FormulaParsingException {
        String string = this.getTokenString();
        if (this.look == '(') {
            Debug.log((int)4, (String)("Found Function : " + string));
            int n = this.tokenVector.size();
            this.match('(');
            this.tokenVector.add(this.tokenFactory.getOperatorToken("(", 1));
            int n2 = this.arguments();
            this.match(')');
            this.tokenVector.add(this.tokenFactory.getOperatorToken(")", 1));
            this.tokenVector.insertElementAt(this.tokenFactory.getFunctionToken(string, n2), n);
        } else if (string.indexOf(46) != -1) {
            String string2 = string.substring(string.indexOf(46) + 1, string.length());
            if (string2.indexOf(58) != -1) {
                this.tokenVector.add(this.tokenFactory.getOperandToken(string, "3D_CELL_AREA_REFERENCE"));
            } else {
                this.tokenVector.add(this.tokenFactory.getOperandToken(string, "3D_CELL_REFERENCE"));
            }
        } else if (string.indexOf(58) != -1) {
            this.tokenVector.add(this.tokenFactory.getOperandToken(string, "CELL_AREA_REFERENCE"));
        } else if (this.isCellRef(string)) {
            this.tokenVector.add(this.tokenFactory.getOperandToken(string, "CELL_REFERENCE"));
        } else {
            this.tokenVector.add(this.tokenFactory.getOperandToken(string, "NAME"));
        }
    }

    private boolean isAddOp(char c) {
        return c == '-' || c == '+';
    }

    private boolean isAlpha(char c) {
        return Character.isLetter(c);
    }

    private boolean isAlphaNum(char c) {
        return this.isAlpha(c) || this.isDigit(c);
    }

    private boolean isCellRef(String string) {
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (this.isCellRefSpecialChar(c)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl && (this.isDigit(string.charAt(1)) || this.isDigit(string.charAt(2)))) {
            bl = true;
        }
        return bl;
    }

    private boolean isCellRefChar(char c) {
        return this.isAlpha(c) || this.isDigit(c) || this.isCellRefSpecialChar(c);
    }

    private boolean isCellRefSpecialChar(char c) {
        return c == ':' || c == '$' || c == '.';
    }

    private boolean isDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean isLogicalOp() {
        if (!this.isLogicalOpChar(this.look)) {
            return false;
        }
        if (this.index + 1 >= this.formulaStr.length()) {
            return true;
        }
        if (!this.isLogicalOpChar(this.formulaStr.charAt(this.index))) {
            return true;
        }
        if (this.look == '<' && (this.formulaStr.charAt(this.index) == '>' || this.formulaStr.charAt(this.index) == '=')) {
            return true;
        }
        return this.look == '>' && this.formulaStr.charAt(this.index) == '=';
    }

    private boolean isLogicalOp(String string) {
        return string.compareTo(">") == 0 || string.compareTo("<") == 0 || string.compareTo(">=") == 0 || string.compareTo("<=") == 0 || string.compareTo("=") == 0 || string.compareTo("<>") == 0;
    }

    private boolean isLogicalOpChar(char c) {
        return c == '>' || c == '<' || c == '=';
    }

    private boolean isMultiOp() {
        return this.look == '*' || this.look == '/' || this.look == '^' || this.look == '&';
    }

    private boolean isPercent(char c) {
        return c == '%';
    }

    private void logicalOp() throws FormulaParsingException {
        String string = this.getLogicalOperator();
        this.tokenVector.add(this.tokenFactory.getOperatorToken(string, 2));
        this.term();
    }

    private String makeErrorString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.index - 1) {
            stringBuffer.append(' ');
            ++n;
        }
        stringBuffer.append('^');
        return "\n\t" + this.formulaStr + "\n\t" + stringBuffer.toString();
    }

    private void match(char c) throws FormulaParsingException {
        if (this.look != c) {
            throw new FormulaParsingException("Unexpected character '" + c + "'" + this.makeErrorString());
        }
        Debug.log((int)4, (String)("Operator Found : " + this.look));
        this.getChar();
        this.skipWhite();
    }

    private void match(String string) throws FormulaParsingException {
        int n = string.length();
        boolean bl = true;
        int n2 = 0;
        while (n2 < n && bl) {
            if (this.look != string.charAt(n2)) {
                throw new FormulaParsingException("Unexpected character '" + string + "'" + this.makeErrorString());
            }
            bl = this.getChar();
            this.skipWhite();
            ++n2;
        }
    }

    private void multiOp(String string) throws FormulaParsingException {
        this.match(string);
        this.tokenVector.add(this.tokenFactory.getOperatorToken(string, 2));
        this.factor();
    }

    public Vector parse(String string) throws FormulaParsingException {
        this.index = 1;
        this.look = (char)32;
        this.tokenVector.clear();
        if (!string.startsWith("=")) {
            throw new FormulaParsingException("No equals found!" + this.makeErrorString());
        }
        this.formulaStr = string;
        Debug.log((int)4, (String)("Creating a Formula Parser for " + this.formulaStr));
        this.getChar();
        this.expression();
        return this.tokenVector;
    }

    public void setWorkbook(Workbook workbook) {
        this.wb = workbook;
    }

    private void skipWhite() throws FormulaParsingException {
        boolean bl = true;
        while (Character.isWhitespace(this.look) && bl) {
            bl = this.getChar();
        }
    }

    private void term() throws FormulaParsingException {
        this.factor();
        while (this.isMultiOp()) {
            this.multiOp(Character.toString(this.look));
        }
    }
}

