/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM /usr/home/sean/mozdev/mozilla-1.0/mozilla/netwerk/base/public/nsISocketTransportService.idl
 */

#ifndef __gen_nsISocketTransportService_h__
#define __gen_nsISocketTransportService_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsITransport; /* forward declaration */

class nsIEventSinkGetter; /* forward declaration */

class nsIChannel; /* forward declaration */

class nsIProxyInfo; /* forward declaration */


/* starting interface:    nsISocketTransportService */
#define NS_ISOCKETTRANSPORTSERVICE_IID_STR "05331390-6884-11d3-9382-00104ba0fd40"

#define NS_ISOCKETTRANSPORTSERVICE_IID \
  {0x05331390, 0x6884, 0x11d3, \
    { 0x93, 0x82, 0x00, 0x10, 0x4b, 0xa0, 0xfd, 0x40 }}

class NS_NO_VTABLE nsISocketTransportService : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ISOCKETTRANSPORTSERVICE_IID)

  /**
     * Creates a transport for a specified host and port.
     *
     * @param proxyInfo Information about any transport-layer proxying. Used
     * for communicating information about proxies like socks.
     * This can either be the proxyInfo attribute on an
     * nsISupportsTransparentProxy (or from the protocolProxyService),
     * or null for no proxying.
     *
     * @see nsISupportsTransparentProxy
     * @see nsIProtocolProxyService::GetProxyInfo
     */
  /* nsITransport createTransport (in string host, in long port, in nsIProxyInfo proxyInfo, in unsigned long bufferSegmentSize, in unsigned long bufferMaxSize); */
  NS_IMETHOD CreateTransport(const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval) = 0;

  /* nsITransport createTransportOfType (in string socketType, in string host, in long port, in nsIProxyInfo proxyInfo, in unsigned long bufferSegmentSize, in unsigned long bufferMaxSize); */
  NS_IMETHOD CreateTransportOfType(const char *socketType, const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval) = 0;

  /* nsITransport createTransportOfTypes (in unsigned long typeCount, [array, size_is (typeCount)] in string socketTypes, in string host, in long port, in nsIProxyInfo proxyInfo, in unsigned long bufferSegmentSize, in unsigned long bufferMaxSize); */
  NS_IMETHOD CreateTransportOfTypes(PRUint32 typeCount, const char **socketTypes, const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval) = 0;

  /**
     * Returns true if the specified transport is good enough for 
     * being used again. The situations in which this may return false
     * include- an error including server resets, an explicit 
     * Connection: close header (for HTTP) and timeouts! 
     */
  /* boolean reuseTransport (in nsITransport i_Transport); */
  NS_IMETHOD ReuseTransport(nsITransport *i_Transport, PRBool *_retval) = 0;

  /* void init (); */
  NS_IMETHOD Init(void) = 0;

  /* void shutdown (); */
  NS_IMETHOD Shutdown(void) = 0;

  /* void wakeup (in nsITransport i_Transport); */
  NS_IMETHOD Wakeup(nsITransport *i_Transport) = 0;

  /**
	 * Total number of nsSocketTransport objects currently alive
	 */
  /* readonly attribute unsigned long totalTransportCount; */
  NS_IMETHOD GetTotalTransportCount(PRUint32 *aTotalTransportCount) = 0;

  /**
	 * A number of nsSocketTransport objects with I/O operation currently in-progress
	 */
  /* readonly attribute unsigned long inUseTransportCount; */
  NS_IMETHOD GetInUseTransportCount(PRUint32 *aInUseTransportCount) = 0;

  /**
	 * A number of nsSocketTransport objects connected (this may include keep-alive idle connections)
	 */
  /* readonly attribute unsigned long connectedTransportCount; */
  NS_IMETHOD GetConnectedTransportCount(PRUint32 *aConnectedTransportCount) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSISOCKETTRANSPORTSERVICE \
  NS_IMETHOD CreateTransport(const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval); \
  NS_IMETHOD CreateTransportOfType(const char *socketType, const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval); \
  NS_IMETHOD CreateTransportOfTypes(PRUint32 typeCount, const char **socketTypes, const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval); \
  NS_IMETHOD ReuseTransport(nsITransport *i_Transport, PRBool *_retval); \
  NS_IMETHOD Init(void); \
  NS_IMETHOD Shutdown(void); \
  NS_IMETHOD Wakeup(nsITransport *i_Transport); \
  NS_IMETHOD GetTotalTransportCount(PRUint32 *aTotalTransportCount); \
  NS_IMETHOD GetInUseTransportCount(PRUint32 *aInUseTransportCount); \
  NS_IMETHOD GetConnectedTransportCount(PRUint32 *aConnectedTransportCount); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSISOCKETTRANSPORTSERVICE(_to) \
  NS_IMETHOD CreateTransport(const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval) { return _to CreateTransport(host, port, proxyInfo, bufferSegmentSize, bufferMaxSize, _retval); } \
  NS_IMETHOD CreateTransportOfType(const char *socketType, const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval) { return _to CreateTransportOfType(socketType, host, port, proxyInfo, bufferSegmentSize, bufferMaxSize, _retval); } \
  NS_IMETHOD CreateTransportOfTypes(PRUint32 typeCount, const char **socketTypes, const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval) { return _to CreateTransportOfTypes(typeCount, socketTypes, host, port, proxyInfo, bufferSegmentSize, bufferMaxSize, _retval); } \
  NS_IMETHOD ReuseTransport(nsITransport *i_Transport, PRBool *_retval) { return _to ReuseTransport(i_Transport, _retval); } \
  NS_IMETHOD Init(void) { return _to Init(); } \
  NS_IMETHOD Shutdown(void) { return _to Shutdown(); } \
  NS_IMETHOD Wakeup(nsITransport *i_Transport) { return _to Wakeup(i_Transport); } \
  NS_IMETHOD GetTotalTransportCount(PRUint32 *aTotalTransportCount) { return _to GetTotalTransportCount(aTotalTransportCount); } \
  NS_IMETHOD GetInUseTransportCount(PRUint32 *aInUseTransportCount) { return _to GetInUseTransportCount(aInUseTransportCount); } \
  NS_IMETHOD GetConnectedTransportCount(PRUint32 *aConnectedTransportCount) { return _to GetConnectedTransportCount(aConnectedTransportCount); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSISOCKETTRANSPORTSERVICE(_to) \
  NS_IMETHOD CreateTransport(const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateTransport(host, port, proxyInfo, bufferSegmentSize, bufferMaxSize, _retval); } \
  NS_IMETHOD CreateTransportOfType(const char *socketType, const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateTransportOfType(socketType, host, port, proxyInfo, bufferSegmentSize, bufferMaxSize, _retval); } \
  NS_IMETHOD CreateTransportOfTypes(PRUint32 typeCount, const char **socketTypes, const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateTransportOfTypes(typeCount, socketTypes, host, port, proxyInfo, bufferSegmentSize, bufferMaxSize, _retval); } \
  NS_IMETHOD ReuseTransport(nsITransport *i_Transport, PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->ReuseTransport(i_Transport, _retval); } \
  NS_IMETHOD Init(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Init(); } \
  NS_IMETHOD Shutdown(void) { return !_to ? NS_ERROR_NULL_POINTER : _to->Shutdown(); } \
  NS_IMETHOD Wakeup(nsITransport *i_Transport) { return !_to ? NS_ERROR_NULL_POINTER : _to->Wakeup(i_Transport); } \
  NS_IMETHOD GetTotalTransportCount(PRUint32 *aTotalTransportCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTotalTransportCount(aTotalTransportCount); } \
  NS_IMETHOD GetInUseTransportCount(PRUint32 *aInUseTransportCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetInUseTransportCount(aInUseTransportCount); } \
  NS_IMETHOD GetConnectedTransportCount(PRUint32 *aConnectedTransportCount) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetConnectedTransportCount(aConnectedTransportCount); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsSocketTransportService : public nsISocketTransportService
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSISOCKETTRANSPORTSERVICE

  nsSocketTransportService();
  virtual ~nsSocketTransportService();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsSocketTransportService, nsISocketTransportService)

nsSocketTransportService::nsSocketTransportService()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsSocketTransportService::~nsSocketTransportService()
{
  /* destructor code */
}

/* nsITransport createTransport (in string host, in long port, in nsIProxyInfo proxyInfo, in unsigned long bufferSegmentSize, in unsigned long bufferMaxSize); */
NS_IMETHODIMP nsSocketTransportService::CreateTransport(const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsITransport createTransportOfType (in string socketType, in string host, in long port, in nsIProxyInfo proxyInfo, in unsigned long bufferSegmentSize, in unsigned long bufferMaxSize); */
NS_IMETHODIMP nsSocketTransportService::CreateTransportOfType(const char *socketType, const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsITransport createTransportOfTypes (in unsigned long typeCount, [array, size_is (typeCount)] in string socketTypes, in string host, in long port, in nsIProxyInfo proxyInfo, in unsigned long bufferSegmentSize, in unsigned long bufferMaxSize); */
NS_IMETHODIMP nsSocketTransportService::CreateTransportOfTypes(PRUint32 typeCount, const char **socketTypes, const char *host, PRInt32 port, nsIProxyInfo *proxyInfo, PRUint32 bufferSegmentSize, PRUint32 bufferMaxSize, nsITransport **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean reuseTransport (in nsITransport i_Transport); */
NS_IMETHODIMP nsSocketTransportService::ReuseTransport(nsITransport *i_Transport, PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void init (); */
NS_IMETHODIMP nsSocketTransportService::Init()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void shutdown (); */
NS_IMETHODIMP nsSocketTransportService::Shutdown()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void wakeup (in nsITransport i_Transport); */
NS_IMETHODIMP nsSocketTransportService::Wakeup(nsITransport *i_Transport)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long totalTransportCount; */
NS_IMETHODIMP nsSocketTransportService::GetTotalTransportCount(PRUint32 *aTotalTransportCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long inUseTransportCount; */
NS_IMETHODIMP nsSocketTransportService::GetInUseTransportCount(PRUint32 *aInUseTransportCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long connectedTransportCount; */
NS_IMETHODIMP nsSocketTransportService::GetConnectedTransportCount(PRUint32 *aConnectedTransportCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif

#define NS_SOCKETTRANSPORTSERVICE_CID                \
{ /* c07e81e0-ef12-11d2-92b6-00105a1b0d64 */         \
    0xc07e81e0,                                      \
    0xef12,                                          \
    0x11d2,                                          \
    {0x92, 0xb6, 0x00, 0x10, 0x5a, 0x1b, 0x0d, 0x64} \
}
// if a socket connection attempt fails (eg. no server listening at specified host:port)
#define NS_ERROR_CONNECTION_REFUSED NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 13)
// if a socket connection was lost due to a timeout error (eg. PR_Poll times out)
#define NS_ERROR_NET_TIMEOUT NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 14)
// if a socket connection was lost due to a network reset (eg. PR_Poll sets PR_POLL_ERR)
#define NS_ERROR_NET_RESET NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 20)
/**
 * Status nsresult codes: used with nsIProgressEventSink::OnStatus 
 */
#define NS_NET_STATUS_RESOLVING_HOST  NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 3)
#define NS_NET_STATUS_CONNECTED_TO    NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 4)
#define NS_NET_STATUS_SENDING_TO      NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 5)
#define NS_NET_STATUS_RECEIVING_FROM  NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 6)
#define NS_NET_STATUS_CONNECTING_TO   NS_ERROR_GENERATE_FAILURE(NS_ERROR_MODULE_NETWORK, 7)

#endif /* __gen_nsISocketTransportService_h__ */
