/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIHttpChannel.idl
 */

#ifndef __gen_nsIHttpChannel_h__
#define __gen_nsIHttpChannel_h__


#ifndef __gen_nsIChannel_h__
#include "nsIChannel.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIHttpHeaderVisitor; /* forward declaration */

class nsISimpleEnumerator; /* forward declaration */


/* starting interface:    nsIHttpChannel */
#define NS_IHTTPCHANNEL_IID_STR "d78b53c8-d03f-4fd8-b2ee-7b36fcd150d1"

#define NS_IHTTPCHANNEL_IID \
  {0xd78b53c8, 0xd03f, 0x4fd8, \
    { 0xb2, 0xee, 0x7b, 0x36, 0xfc, 0xd1, 0x50, 0xd1 }}

class NS_NO_VTABLE nsIHttpChannel : public nsIChannel {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IHTTPCHANNEL_IID)

  /**************************************************************************
     * Request info...
     */
/**
     * The request method is case insensitive
     */
  /* attribute ACString requestMethod; */
  NS_IMETHOD GetRequestMethod(nsACString & aRequestMethod) = 0;
  NS_IMETHOD SetRequestMethod(const nsACString & aRequestMethod) = 0;

  /**
     * Get/set the referrer URI on the request.  This is the address (URI) of
     * the resource from which this channel's URI was obtained (see RFC2616
     * section 14.36).  The referrer type may be used to block the referrer
     * from being sent in certain cases.
     */
  /* readonly attribute nsIURI referrer; */
  NS_IMETHOD GetReferrer(nsIURI * *aReferrer) = 0;

  /* void setReferrer (in nsIURI referrer, in unsigned long referrerType); */
  NS_IMETHOD SetReferrer(nsIURI *referrer, PRUint32 referrerType) = 0;

  enum { REFERRER_NONE = 0U };

  enum { REFERRER_LINK_CLICK = 1U };

  enum { REFERRER_INLINES = 2U };

  enum { REFERRER_NON_HTTP = 3U };

  /**
     * An http channel can own a reference to the document URI
     */
  /* attribute nsIURI documentURI; */
  NS_IMETHOD GetDocumentURI(nsIURI * *aDocumentURI) = 0;
  NS_IMETHOD SetDocumentURI(nsIURI * aDocumentURI) = 0;

  /**
     * Header strings are case insensitive
     */
  /* ACString getRequestHeader (in ACString header); */
  NS_IMETHOD GetRequestHeader(const nsACString & header, nsACString & _retval) = 0;

  /* void setRequestHeader (in ACString header, in ACString value); */
  NS_IMETHOD SetRequestHeader(const nsACString & header, const nsACString & value) = 0;

  /* void visitRequestHeaders (in nsIHttpHeaderVisitor visitor); */
  NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *visitor) = 0;

  /**
     * Get the stream (to be) uploaded by this HTTP channel.
     */
  /* readonly attribute nsIInputStream uploadStream; */
  NS_IMETHOD GetUploadStream(nsIInputStream * *aUploadStream) = 0;

  /**************************************************************************
     * Response info...
     */
  /* readonly attribute unsigned long responseStatus; */
  NS_IMETHOD GetResponseStatus(PRUint32 *aResponseStatus) = 0;

  /* readonly attribute ACString responseStatusText; */
  NS_IMETHOD GetResponseStatusText(nsACString & aResponseStatusText) = 0;

  /**
     * Header strings are case insensitive
     */
  /* ACString getResponseHeader (in ACString header); */
  NS_IMETHOD GetResponseHeader(const nsACString & header, nsACString & _retval) = 0;

  /* void setResponseHeader (in ACString header, in ACString value); */
  NS_IMETHOD SetResponseHeader(const nsACString & header, const nsACString & value) = 0;

  /* void visitResponseHeaders (in nsIHttpHeaderVisitor visitor); */
  NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *visitor) = 0;

  /**
     * True if the server sent a "Cache-control: no-store" response header.
     */
  /* boolean isNoStoreResponse (); */
  NS_IMETHOD IsNoStoreResponse(PRBool *_retval) = 0;

  /**
     * True if the server sent the equivalent of a "Cache-control: no-cache"
     * response header.  Other equivalent response headers include: "Pragma:
     * no-cache" and "Expires" with a date-value in the past.
     */
  /* boolean isNoCacheResponse (); */
  NS_IMETHOD IsNoCacheResponse(PRBool *_retval) = 0;

  /**
     * This attribute holds the MIME types corresponding to the content
     * encodings on the channel.  The enumerator returns nsISupportsString
     * objects.  The first one corresponds to the outermost encoding on the
     * channel and then we work our way inward.  "identity" is skipped and not
     * represented on the list.  Unknown encodings make the enumeration stop.
     * If you want the actual Content-Encoding value, use
     * getResponseHeader("Content-Encoding").
     *
     * When there is no Content-Encoding header, this property is null.
     *
     * Modifying the Content-Encoding header on the channel will case
     * this enumerator to have undefined behavior.  Don't do it.
     */
  /* readonly attribute nsISimpleEnumerator contentEncodings; */
  NS_IMETHOD GetContentEncodings(nsISimpleEnumerator * *aContentEncodings) = 0;

  /**
     * This attribute controls whether or not content conversion should be
     * done per the Content-Encoding response header.
     *
     * TRUE by default.
     */
  /* attribute boolean applyConversion; */
  NS_IMETHOD GetApplyConversion(PRBool *aApplyConversion) = 0;
  NS_IMETHOD SetApplyConversion(PRBool aApplyConversion) = 0;

  /**
     * This attribute is a hint to the channel to indicate whether or not
     * the underlying HTTP transaction should be allowed to be pipelined
     * with other transactions.  This should be set to FALSE, for example,
     * if the application knows that the corresponding document is likely
     * to be very large.
     *
     * TRUE by default, though other factors may prevent pipelining.
     */
  /* attribute boolean allowPipelining; */
  NS_IMETHOD GetAllowPipelining(PRBool *aAllowPipelining) = 0;
  NS_IMETHOD SetAllowPipelining(PRBool aAllowPipelining) = 0;

  /**
     * This attribute specifies the number of redirects this channel is allowed
     * to make.  If zero, the channel will fail to redirect and will generate
     * a NS_ERROR_REDIRECT_LOOP failure status.
     */
  /* attribute unsigned long redirectionLimit; */
  NS_IMETHOD GetRedirectionLimit(PRUint32 *aRedirectionLimit) = 0;
  NS_IMETHOD SetRedirectionLimit(PRUint32 aRedirectionLimit) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPCHANNEL \
  NS_IMETHOD GetRequestMethod(nsACString & aRequestMethod); \
  NS_IMETHOD SetRequestMethod(const nsACString & aRequestMethod); \
  NS_IMETHOD GetReferrer(nsIURI * *aReferrer); \
  NS_IMETHOD SetReferrer(nsIURI *referrer, PRUint32 referrerType); \
  NS_IMETHOD GetDocumentURI(nsIURI * *aDocumentURI); \
  NS_IMETHOD SetDocumentURI(nsIURI * aDocumentURI); \
  NS_IMETHOD GetRequestHeader(const nsACString & header, nsACString & _retval); \
  NS_IMETHOD SetRequestHeader(const nsACString & header, const nsACString & value); \
  NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *visitor); \
  NS_IMETHOD GetUploadStream(nsIInputStream * *aUploadStream); \
  NS_IMETHOD GetResponseStatus(PRUint32 *aResponseStatus); \
  NS_IMETHOD GetResponseStatusText(nsACString & aResponseStatusText); \
  NS_IMETHOD GetResponseHeader(const nsACString & header, nsACString & _retval); \
  NS_IMETHOD SetResponseHeader(const nsACString & header, const nsACString & value); \
  NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *visitor); \
  NS_IMETHOD IsNoStoreResponse(PRBool *_retval); \
  NS_IMETHOD IsNoCacheResponse(PRBool *_retval); \
  NS_IMETHOD GetContentEncodings(nsISimpleEnumerator * *aContentEncodings); \
  NS_IMETHOD GetApplyConversion(PRBool *aApplyConversion); \
  NS_IMETHOD SetApplyConversion(PRBool aApplyConversion); \
  NS_IMETHOD GetAllowPipelining(PRBool *aAllowPipelining); \
  NS_IMETHOD SetAllowPipelining(PRBool aAllowPipelining); \
  NS_IMETHOD GetRedirectionLimit(PRUint32 *aRedirectionLimit); \
  NS_IMETHOD SetRedirectionLimit(PRUint32 aRedirectionLimit); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPCHANNEL(_to) \
  NS_IMETHOD GetRequestMethod(nsACString & aRequestMethod) { return _to GetRequestMethod(aRequestMethod); } \
  NS_IMETHOD SetRequestMethod(const nsACString & aRequestMethod) { return _to SetRequestMethod(aRequestMethod); } \
  NS_IMETHOD GetReferrer(nsIURI * *aReferrer) { return _to GetReferrer(aReferrer); } \
  NS_IMETHOD SetReferrer(nsIURI *referrer, PRUint32 referrerType) { return _to SetReferrer(referrer, referrerType); } \
  NS_IMETHOD GetDocumentURI(nsIURI * *aDocumentURI) { return _to GetDocumentURI(aDocumentURI); } \
  NS_IMETHOD SetDocumentURI(nsIURI * aDocumentURI) { return _to SetDocumentURI(aDocumentURI); } \
  NS_IMETHOD GetRequestHeader(const nsACString & header, nsACString & _retval) { return _to GetRequestHeader(header, _retval); } \
  NS_IMETHOD SetRequestHeader(const nsACString & header, const nsACString & value) { return _to SetRequestHeader(header, value); } \
  NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *visitor) { return _to VisitRequestHeaders(visitor); } \
  NS_IMETHOD GetUploadStream(nsIInputStream * *aUploadStream) { return _to GetUploadStream(aUploadStream); } \
  NS_IMETHOD GetResponseStatus(PRUint32 *aResponseStatus) { return _to GetResponseStatus(aResponseStatus); } \
  NS_IMETHOD GetResponseStatusText(nsACString & aResponseStatusText) { return _to GetResponseStatusText(aResponseStatusText); } \
  NS_IMETHOD GetResponseHeader(const nsACString & header, nsACString & _retval) { return _to GetResponseHeader(header, _retval); } \
  NS_IMETHOD SetResponseHeader(const nsACString & header, const nsACString & value) { return _to SetResponseHeader(header, value); } \
  NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *visitor) { return _to VisitResponseHeaders(visitor); } \
  NS_IMETHOD IsNoStoreResponse(PRBool *_retval) { return _to IsNoStoreResponse(_retval); } \
  NS_IMETHOD IsNoCacheResponse(PRBool *_retval) { return _to IsNoCacheResponse(_retval); } \
  NS_IMETHOD GetContentEncodings(nsISimpleEnumerator * *aContentEncodings) { return _to GetContentEncodings(aContentEncodings); } \
  NS_IMETHOD GetApplyConversion(PRBool *aApplyConversion) { return _to GetApplyConversion(aApplyConversion); } \
  NS_IMETHOD SetApplyConversion(PRBool aApplyConversion) { return _to SetApplyConversion(aApplyConversion); } \
  NS_IMETHOD GetAllowPipelining(PRBool *aAllowPipelining) { return _to GetAllowPipelining(aAllowPipelining); } \
  NS_IMETHOD SetAllowPipelining(PRBool aAllowPipelining) { return _to SetAllowPipelining(aAllowPipelining); } \
  NS_IMETHOD GetRedirectionLimit(PRUint32 *aRedirectionLimit) { return _to GetRedirectionLimit(aRedirectionLimit); } \
  NS_IMETHOD SetRedirectionLimit(PRUint32 aRedirectionLimit) { return _to SetRedirectionLimit(aRedirectionLimit); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPCHANNEL(_to) \
  NS_IMETHOD GetRequestMethod(nsACString & aRequestMethod) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestMethod(aRequestMethod); } \
  NS_IMETHOD SetRequestMethod(const nsACString & aRequestMethod) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestMethod(aRequestMethod); } \
  NS_IMETHOD GetReferrer(nsIURI * *aReferrer) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetReferrer(aReferrer); } \
  NS_IMETHOD SetReferrer(nsIURI *referrer, PRUint32 referrerType) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetReferrer(referrer, referrerType); } \
  NS_IMETHOD GetDocumentURI(nsIURI * *aDocumentURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDocumentURI(aDocumentURI); } \
  NS_IMETHOD SetDocumentURI(nsIURI * aDocumentURI) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetDocumentURI(aDocumentURI); } \
  NS_IMETHOD GetRequestHeader(const nsACString & header, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRequestHeader(header, _retval); } \
  NS_IMETHOD SetRequestHeader(const nsACString & header, const nsACString & value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRequestHeader(header, value); } \
  NS_IMETHOD VisitRequestHeaders(nsIHttpHeaderVisitor *visitor) { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitRequestHeaders(visitor); } \
  NS_IMETHOD GetUploadStream(nsIInputStream * *aUploadStream) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetUploadStream(aUploadStream); } \
  NS_IMETHOD GetResponseStatus(PRUint32 *aResponseStatus) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseStatus(aResponseStatus); } \
  NS_IMETHOD GetResponseStatusText(nsACString & aResponseStatusText) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseStatusText(aResponseStatusText); } \
  NS_IMETHOD GetResponseHeader(const nsACString & header, nsACString & _retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetResponseHeader(header, _retval); } \
  NS_IMETHOD SetResponseHeader(const nsACString & header, const nsACString & value) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetResponseHeader(header, value); } \
  NS_IMETHOD VisitResponseHeaders(nsIHttpHeaderVisitor *visitor) { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitResponseHeaders(visitor); } \
  NS_IMETHOD IsNoStoreResponse(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsNoStoreResponse(_retval); } \
  NS_IMETHOD IsNoCacheResponse(PRBool *_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->IsNoCacheResponse(_retval); } \
  NS_IMETHOD GetContentEncodings(nsISimpleEnumerator * *aContentEncodings) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetContentEncodings(aContentEncodings); } \
  NS_IMETHOD GetApplyConversion(PRBool *aApplyConversion) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetApplyConversion(aApplyConversion); } \
  NS_IMETHOD SetApplyConversion(PRBool aApplyConversion) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetApplyConversion(aApplyConversion); } \
  NS_IMETHOD GetAllowPipelining(PRBool *aAllowPipelining) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAllowPipelining(aAllowPipelining); } \
  NS_IMETHOD SetAllowPipelining(PRBool aAllowPipelining) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetAllowPipelining(aAllowPipelining); } \
  NS_IMETHOD GetRedirectionLimit(PRUint32 *aRedirectionLimit) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetRedirectionLimit(aRedirectionLimit); } \
  NS_IMETHOD SetRedirectionLimit(PRUint32 aRedirectionLimit) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRedirectionLimit(aRedirectionLimit); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsHttpChannel : public nsIHttpChannel
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIHTTPCHANNEL

  nsHttpChannel();
  virtual ~nsHttpChannel();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsHttpChannel, nsIHttpChannel)

nsHttpChannel::nsHttpChannel()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsHttpChannel::~nsHttpChannel()
{
  /* destructor code */
}

/* attribute ACString requestMethod; */
NS_IMETHODIMP nsHttpChannel::GetRequestMethod(nsACString & aRequestMethod)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsHttpChannel::SetRequestMethod(const nsACString & aRequestMethod)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIURI referrer; */
NS_IMETHODIMP nsHttpChannel::GetReferrer(nsIURI * *aReferrer)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setReferrer (in nsIURI referrer, in unsigned long referrerType); */
NS_IMETHODIMP nsHttpChannel::SetReferrer(nsIURI *referrer, PRUint32 referrerType)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute nsIURI documentURI; */
NS_IMETHODIMP nsHttpChannel::GetDocumentURI(nsIURI * *aDocumentURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsHttpChannel::SetDocumentURI(nsIURI * aDocumentURI)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getRequestHeader (in ACString header); */
NS_IMETHODIMP nsHttpChannel::GetRequestHeader(const nsACString & header, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setRequestHeader (in ACString header, in ACString value); */
NS_IMETHODIMP nsHttpChannel::SetRequestHeader(const nsACString & header, const nsACString & value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void visitRequestHeaders (in nsIHttpHeaderVisitor visitor); */
NS_IMETHODIMP nsHttpChannel::VisitRequestHeaders(nsIHttpHeaderVisitor *visitor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsIInputStream uploadStream; */
NS_IMETHODIMP nsHttpChannel::GetUploadStream(nsIInputStream * *aUploadStream)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute unsigned long responseStatus; */
NS_IMETHODIMP nsHttpChannel::GetResponseStatus(PRUint32 *aResponseStatus)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute ACString responseStatusText; */
NS_IMETHODIMP nsHttpChannel::GetResponseStatusText(nsACString & aResponseStatusText)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* ACString getResponseHeader (in ACString header); */
NS_IMETHODIMP nsHttpChannel::GetResponseHeader(const nsACString & header, nsACString & _retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setResponseHeader (in ACString header, in ACString value); */
NS_IMETHODIMP nsHttpChannel::SetResponseHeader(const nsACString & header, const nsACString & value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void visitResponseHeaders (in nsIHttpHeaderVisitor visitor); */
NS_IMETHODIMP nsHttpChannel::VisitResponseHeaders(nsIHttpHeaderVisitor *visitor)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isNoStoreResponse (); */
NS_IMETHODIMP nsHttpChannel::IsNoStoreResponse(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* boolean isNoCacheResponse (); */
NS_IMETHODIMP nsHttpChannel::IsNoCacheResponse(PRBool *_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute nsISimpleEnumerator contentEncodings; */
NS_IMETHODIMP nsHttpChannel::GetContentEncodings(nsISimpleEnumerator * *aContentEncodings)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean applyConversion; */
NS_IMETHODIMP nsHttpChannel::GetApplyConversion(PRBool *aApplyConversion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsHttpChannel::SetApplyConversion(PRBool aApplyConversion)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute boolean allowPipelining; */
NS_IMETHODIMP nsHttpChannel::GetAllowPipelining(PRBool *aAllowPipelining)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsHttpChannel::SetAllowPipelining(PRBool aAllowPipelining)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* attribute unsigned long redirectionLimit; */
NS_IMETHODIMP nsHttpChannel::GetRedirectionLimit(PRUint32 *aRedirectionLimit)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
NS_IMETHODIMP nsHttpChannel::SetRedirectionLimit(PRUint32 aRedirectionLimit)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsIHttpHeaderVisitor */
#define NS_IHTTPHEADERVISITOR_IID_STR "0cf40717-d7c1-4a94-8c1e-d6c9734101bb"

#define NS_IHTTPHEADERVISITOR_IID \
  {0x0cf40717, 0xd7c1, 0x4a94, \
    { 0x8c, 0x1e, 0xd6, 0xc9, 0x73, 0x41, 0x01, 0xbb }}

class NS_NO_VTABLE nsIHttpHeaderVisitor : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IHTTPHEADERVISITOR_IID)

  /**
 * Implement this interface to visit http headers.
 */
/**
     * @throw any exception to terminate enumeration
     */
  /* void visitHeader (in ACString header, in ACString value); */
  NS_IMETHOD VisitHeader(const nsACString & header, const nsACString & value) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIHTTPHEADERVISITOR \
  NS_IMETHOD VisitHeader(const nsACString & header, const nsACString & value); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIHTTPHEADERVISITOR(_to) \
  NS_IMETHOD VisitHeader(const nsACString & header, const nsACString & value) { return _to VisitHeader(header, value); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIHTTPHEADERVISITOR(_to) \
  NS_IMETHOD VisitHeader(const nsACString & header, const nsACString & value) { return !_to ? NS_ERROR_NULL_POINTER : _to->VisitHeader(header, value); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsHttpHeaderVisitor : public nsIHttpHeaderVisitor
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIHTTPHEADERVISITOR

  nsHttpHeaderVisitor();
  virtual ~nsHttpHeaderVisitor();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsHttpHeaderVisitor, nsIHttpHeaderVisitor)

nsHttpHeaderVisitor::nsHttpHeaderVisitor()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsHttpHeaderVisitor::~nsHttpHeaderVisitor()
{
  /* destructor code */
}

/* void visitHeader (in ACString header, in ACString value); */
NS_IMETHODIMP nsHttpHeaderVisitor::VisitHeader(const nsACString & header, const nsACString & value)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIHttpChannel_h__ */
