/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsITransport.idl
 */

#ifndef __gen_nsITransport_h__
#define __gen_nsITransport_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

#ifndef __gen_nsIRequest_h__
#include "nsIRequest.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIStreamListener; /* forward declaration */

class nsIStreamProvider; /* forward declaration */

class nsIInputStream; /* forward declaration */

class nsIOutputStream; /* forward declaration */

class nsIInterfaceRequestor; /* forward declaration */


/* starting interface:    nsITransport */
#define NS_ITRANSPORT_IID_STR "fd01f9a4-d492-4cf8-b76e-160ffc8c01e8"

#define NS_ITRANSPORT_IID \
  {0xfd01f9a4, 0xd492, 0x4cf8, \
    { 0xb7, 0x6e, 0x16, 0x0f, 0xfc, 0x8c, 0x01, 0xe8 }}

class NS_NO_VTABLE nsITransport : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ITRANSPORT_IID)

  /**
     * Get security info for this transport.
     */
  /* readonly attribute nsISupports securityInfo; */
  NS_IMETHOD GetSecurityInfo(nsISupports * *aSecurityInfo) = 0;

  /**
     * Get/set notificationCallbacks for this transport.
     */
  /* nsIInterfaceRequestor getNotificationCallbacks (); */
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor **_retval) = 0;

  /* void setNotificationCallbacks (in nsIInterfaceRequestor callbacks, in unsigned long flags); */
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor *callbacks, PRUint32 flags) = 0;

  /**
     * If the notificationCallbacks provide a nsIProgressEventSink
     * implementation, then progress is by default reported to the thread
     * that called setNotificationCallbacks.  The following flags provide
     * finer control over progress notifications:
     *
     * DONT_REPORT_PROGRESS - progress notifications are not sent.
     * DONT_PROXY_PROGRESS  - progress notifications can occur on any thread.
     */
  enum { DONT_REPORT_PROGRESS = 1U };

  enum { DONT_PROXY_PROGRESS = 2U };

  /**
     * Open an input stream on this transport.
     *
     * @param offset - read starting at this offset
     * @param count  - read this many bytes (pass PRUint32(-1) if unlimited)
     * @param flags  - optional transport specific flags
     */
  /* nsIInputStream openInputStream (in unsigned long offset, in unsigned long count, in unsigned long flags); */
  NS_IMETHOD OpenInputStream(PRUint32 offset, PRUint32 count, PRUint32 flags, nsIInputStream **_retval) = 0;

  /**
     * Open an output stream on this transport.
     *
     * @param offset - write starting at this offset
     * @param count  - write no more than this many bytes (pass PRUint32(-1) if unlimited)
     * @param flags  - optional transport specific flags
     */
  /* nsIOutputStream openOutputStream (in unsigned long offset, in unsigned long count, in unsigned long flags); */
  NS_IMETHOD OpenOutputStream(PRUint32 offset, PRUint32 count, PRUint32 flags, nsIOutputStream **_retval) = 0;

  /**
     * Asynchronously read data from the transport.
     *
     * @param listener - notify this listener when data is available
     * @param ctxt     - opaque parameter passed to listener methods
     * @param offset   - read starting at this offset
     * @param count    - read this many bytes (pass PRUint32(-1) if unlimited)
     * @param flags    - optional transport specific flags
     */
  /* nsIRequest asyncRead (in nsIStreamListener listener, in nsISupports ctxt, in unsigned long offset, in unsigned long count, in unsigned long flags); */
  NS_IMETHOD AsyncRead(nsIStreamListener *listener, nsISupports *ctxt, PRUint32 offset, PRUint32 count, PRUint32 flags, nsIRequest **_retval) = 0;

  /**
     * Asynchronously write data to the transport.
     *
     * @param provider - notify this provider when data can be written
     * @param ctxt     - opaque parameter passed to provider methods
     * @param offset   - write starting at this offset
     * @param count    - write no more than this many bytes (pass PRUint32(-1) if unlimited)
     * @param flags    - optional transport specific flags
     */
  /* nsIRequest asyncWrite (in nsIStreamProvider provider, in nsISupports ctxt, in unsigned long offset, in unsigned long count, in unsigned long flags); */
  NS_IMETHOD AsyncWrite(nsIStreamProvider *provider, nsISupports *ctxt, PRUint32 offset, PRUint32 count, PRUint32 flags, nsIRequest **_retval) = 0;

  /**
     * Callbacks from asyncRead and asyncWrite may be proxied from a
     * background thread (if one exists) to the thread which initiated
     * the request.  This is the expected behavior of such a nsITransport
     * implementation.  A caller of asyncRead or asyncWrite can explicitly
     * ask the transport to not proxy the callback.  The caller must then
     * be prepared to handle callbacks on any thread.
     */
  enum { DONT_PROXY_OBSERVER = 1U };

  enum { DONT_PROXY_LISTENER = 2U };

  enum { DONT_PROXY_PROVIDER = 2U };

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITRANSPORT \
  NS_IMETHOD GetSecurityInfo(nsISupports * *aSecurityInfo); \
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor **_retval); \
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor *callbacks, PRUint32 flags); \
  NS_IMETHOD OpenInputStream(PRUint32 offset, PRUint32 count, PRUint32 flags, nsIInputStream **_retval); \
  NS_IMETHOD OpenOutputStream(PRUint32 offset, PRUint32 count, PRUint32 flags, nsIOutputStream **_retval); \
  NS_IMETHOD AsyncRead(nsIStreamListener *listener, nsISupports *ctxt, PRUint32 offset, PRUint32 count, PRUint32 flags, nsIRequest **_retval); \
  NS_IMETHOD AsyncWrite(nsIStreamProvider *provider, nsISupports *ctxt, PRUint32 offset, PRUint32 count, PRUint32 flags, nsIRequest **_retval); \

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITRANSPORT(_to) \
  NS_IMETHOD GetSecurityInfo(nsISupports * *aSecurityInfo) { return _to GetSecurityInfo(aSecurityInfo); } \
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor **_retval) { return _to GetNotificationCallbacks(_retval); } \
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor *callbacks, PRUint32 flags) { return _to SetNotificationCallbacks(callbacks, flags); } \
  NS_IMETHOD OpenInputStream(PRUint32 offset, PRUint32 count, PRUint32 flags, nsIInputStream **_retval) { return _to OpenInputStream(offset, count, flags, _retval); } \
  NS_IMETHOD OpenOutputStream(PRUint32 offset, PRUint32 count, PRUint32 flags, nsIOutputStream **_retval) { return _to OpenOutputStream(offset, count, flags, _retval); } \
  NS_IMETHOD AsyncRead(nsIStreamListener *listener, nsISupports *ctxt, PRUint32 offset, PRUint32 count, PRUint32 flags, nsIRequest **_retval) { return _to AsyncRead(listener, ctxt, offset, count, flags, _retval); } \
  NS_IMETHOD AsyncWrite(nsIStreamProvider *provider, nsISupports *ctxt, PRUint32 offset, PRUint32 count, PRUint32 flags, nsIRequest **_retval) { return _to AsyncWrite(provider, ctxt, offset, count, flags, _retval); } \

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITRANSPORT(_to) \
  NS_IMETHOD GetSecurityInfo(nsISupports * *aSecurityInfo) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetSecurityInfo(aSecurityInfo); } \
  NS_IMETHOD GetNotificationCallbacks(nsIInterfaceRequestor **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetNotificationCallbacks(_retval); } \
  NS_IMETHOD SetNotificationCallbacks(nsIInterfaceRequestor *callbacks, PRUint32 flags) { return !_to ? NS_ERROR_NULL_POINTER : _to->SetNotificationCallbacks(callbacks, flags); } \
  NS_IMETHOD OpenInputStream(PRUint32 offset, PRUint32 count, PRUint32 flags, nsIInputStream **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenInputStream(offset, count, flags, _retval); } \
  NS_IMETHOD OpenOutputStream(PRUint32 offset, PRUint32 count, PRUint32 flags, nsIOutputStream **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->OpenOutputStream(offset, count, flags, _retval); } \
  NS_IMETHOD AsyncRead(nsIStreamListener *listener, nsISupports *ctxt, PRUint32 offset, PRUint32 count, PRUint32 flags, nsIRequest **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AsyncRead(listener, ctxt, offset, count, flags, _retval); } \
  NS_IMETHOD AsyncWrite(nsIStreamProvider *provider, nsISupports *ctxt, PRUint32 offset, PRUint32 count, PRUint32 flags, nsIRequest **_retval) { return !_to ? NS_ERROR_NULL_POINTER : _to->AsyncWrite(provider, ctxt, offset, count, flags, _retval); } \

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsTransport : public nsITransport
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSITRANSPORT

  nsTransport();
  virtual ~nsTransport();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsTransport, nsITransport)

nsTransport::nsTransport()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsTransport::~nsTransport()
{
  /* destructor code */
}

/* readonly attribute nsISupports securityInfo; */
NS_IMETHODIMP nsTransport::GetSecurityInfo(nsISupports * *aSecurityInfo)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIInterfaceRequestor getNotificationCallbacks (); */
NS_IMETHODIMP nsTransport::GetNotificationCallbacks(nsIInterfaceRequestor **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void setNotificationCallbacks (in nsIInterfaceRequestor callbacks, in unsigned long flags); */
NS_IMETHODIMP nsTransport::SetNotificationCallbacks(nsIInterfaceRequestor *callbacks, PRUint32 flags)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIInputStream openInputStream (in unsigned long offset, in unsigned long count, in unsigned long flags); */
NS_IMETHODIMP nsTransport::OpenInputStream(PRUint32 offset, PRUint32 count, PRUint32 flags, nsIInputStream **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIOutputStream openOutputStream (in unsigned long offset, in unsigned long count, in unsigned long flags); */
NS_IMETHODIMP nsTransport::OpenOutputStream(PRUint32 offset, PRUint32 count, PRUint32 flags, nsIOutputStream **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIRequest asyncRead (in nsIStreamListener listener, in nsISupports ctxt, in unsigned long offset, in unsigned long count, in unsigned long flags); */
NS_IMETHODIMP nsTransport::AsyncRead(nsIStreamListener *listener, nsISupports *ctxt, PRUint32 offset, PRUint32 count, PRUint32 flags, nsIRequest **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* nsIRequest asyncWrite (in nsIStreamProvider provider, in nsISupports ctxt, in unsigned long offset, in unsigned long count, in unsigned long flags); */
NS_IMETHODIMP nsTransport::AsyncWrite(nsIStreamProvider *provider, nsISupports *ctxt, PRUint32 offset, PRUint32 count, PRUint32 flags, nsIRequest **_retval)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


/* starting interface:    nsITransportRequest */
#define NS_ITRANSPORTREQUEST_IID_STR "d7abf5a4-ce72-482a-9217-a219a905c019"

#define NS_ITRANSPORTREQUEST_IID \
  {0xd7abf5a4, 0xce72, 0x482a, \
    { 0x92, 0x17, 0xa2, 0x19, 0xa9, 0x05, 0xc0, 0x19 }}

class NS_NO_VTABLE nsITransportRequest : public nsIRequest {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ITRANSPORTREQUEST_IID)

  /**
     * Get the transport associated with this request.
     */
  /* readonly attribute nsITransport transport; */
  NS_IMETHOD GetTransport(nsITransport * *aTransport) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSITRANSPORTREQUEST \
  NS_IMETHOD GetTransport(nsITransport * *aTransport); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSITRANSPORTREQUEST(_to) \
  NS_IMETHOD GetTransport(nsITransport * *aTransport) { return _to GetTransport(aTransport); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSITRANSPORTREQUEST(_to) \
  NS_IMETHOD GetTransport(nsITransport * *aTransport) { return !_to ? NS_ERROR_NULL_POINTER : _to->GetTransport(aTransport); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsTransportRequest : public nsITransportRequest
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSITRANSPORTREQUEST

  nsTransportRequest();
  virtual ~nsTransportRequest();
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsTransportRequest, nsITransportRequest)

nsTransportRequest::nsTransportRequest()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

nsTransportRequest::~nsTransportRequest()
{
  /* destructor code */
}

/* readonly attribute nsITransport transport; */
NS_IMETHODIMP nsTransportRequest::GetTransport(nsITransport * *aTransport)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsITransport_h__ */
