/*************************************************************************
 *
 *  $RCSfile: QueryHitMerger.java,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: abi $ $Date: 2000/11/30 18:03:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.util.Vector;
import java.util.Enumeration;
import java.rmi.RemoteException;

public final class QueryHitMerger implements QueryProcessor {
  
    private final class QueryThread extends Thread {
	private final QueryProcessor _processor;
	private final QueryStatement _queryStatement;
	
	public QueryThread(QueryProcessor processor, QueryStatement qs) {
	    _processor = processor;
	    _queryStatement = qs;
	}
	
	public void run() {
	    try {
		addHits(_processor.processQuery(_queryStatement));
	    }
	    catch (Exception e) {
		e.printStackTrace();
	    }
	}
    } // end of QueryThread
  
    private static final int DefaultTimeoutSecs = 15;
    // heap
    private static final int InitSize = 32;
    private int                _heapSize = 0;
    private int                _size = InitSize;
    private QueryHitIterator[] _heap = new QueryHitIterator[InitSize];
    private int                _free = 0;

    private int                _nServers;
    private int                _timeout;
    private Vector _queryProcessors = new Vector();
    
    private void reset() {
	_heapSize = 0;
	_free = 0;
	_nServers = 0;
    }

    public String getName() {
	// or concat
	return "merger getName";
    }
  
    public String getClassification() {
	return "merger getClassification";
    }
  
    public String getDocumentType() {
	return "merger getDocumentType";
    }
  
    public QueryResults processQuery(QueryStatement query) throws Exception {
	reset();
	Enumeration processors = _queryProcessors.elements();
	if (processors.hasMoreElements()) {
	    do {
		QueryProcessor server = (QueryProcessor)processors.nextElement();
		_nServers++;
		(new QueryThread(server, query.makeClone())).start();
	    }
	    while (processors.hasMoreElements());
	    return waitForResults(DefaultTimeoutSecs, query.getRequestedNumberOfHits());
	}
	else
	    return null;
    }
  
    public void close() throws Exception {
    }
  
    public synchronized void addSearchServer(QueryProcessor server) {
	_queryProcessors.addElement(server);
    }

    private QueryResults _result = new QueryResults(null, null, null);
  
    /** wait at most timeout seconds */
    public QueryResults waitForResults(final int timeout, final int nHits) {
	_timeout = timeout;
	new Thread(new Runnable() {
		public void run() {
		    synchronized (this) {
			System.out.println(_nServers + " servers");
			while (_timeout > 0  && _nServers > 0)
			    try {
				wait(1000);
				_timeout--;
				System.out.println("timeout = " + _timeout);
			    }
			    catch (InterruptedException e) {}
		    }
		    System.out.println("_nServers = " + _nServers +
				       " _timeout = " + _timeout);
		    buildHeap();
		    Vector hits = new Vector(nHits);
		    if (nonEmpty())
			do {
			    hits.addElement(getHit());
			}
			while (step() && hits.size() < nHits);
	
		    synchronized (_result) {
			_result.notify();
			QueryHitData[] hitArray = new QueryHitData[hits.size()];
			_result = new QueryResults(null,
						   null,
						   (QueryHitData[])hits.toArray(hitArray));
		    }
		}
	    }).start();
    
	synchronized (_result) {
	    try { _result.wait(); } catch (InterruptedException e) {}
	}
	return _result;
    }

    // called from QueryThread
    private synchronized void addHits(QueryResults queryResults) {
	if (queryResults != null && queryResults.isNonEmpty()) {
	    queryResults.translate();
	    // then, in God's name, proceed...
	    if (_free == _size) {
		QueryHitIterator[] newArray = new QueryHitIterator[_size *= 2];
		System.arraycopy(_heap, 0, newArray, 0, _free);
		_heap = newArray;
	    }
	    _heap[_free++] = queryResults.makeQueryHitIterator();
	}
	_nServers--;
	notifyAll();
    }
    
    private void buildHeap() {
	if ((_heapSize = _free) > 0)
	    for (int i = _heapSize/2; i >= 0; i--)
		heapify(i);
    }

    public boolean nonEmpty() {
	return _heapSize > 0;
    }

    public boolean step() {
	if (_heapSize > 0)
	    if (_heap[0].next()) {
		heapify(0);
		return true;
	    }
	    else if (_heapSize > 1) {
		_heap[0] = _heap[--_heapSize];
		heapify(0);
		return true;
	    }
	return false;
    }
  
    public QueryHitData getHit() {
	return _heap[0].getHit();
    }
    
    private void heapify(int i) {
	for (int r, l, smallest;;) {
	    r = (i + 1) << 1; l = r - 1;
	    smallest = l < _heapSize && _heap[l].betterThan(_heap[i]) ? l : i;
	    if (r < _heapSize && _heap[r].betterThan(_heap[smallest]))
		smallest = r;
	    if (smallest != i) {
		QueryHitIterator temp = _heap[smallest];
		_heap[smallest] = _heap[i];
		_heap[i] = temp;
		i = smallest;
	    }
	    else
		break;
	}
    }
}

