/*************************************************************************
 *
 *  $RCSfile: cntrange.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: kso $ $Date: 2001/07/25 15:09:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CNTRANGE_HXX
#define _CNTRANGE_HXX

#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif

namespace chaos {

//============================================================================
class CntRangesItem: public SfxPoolItem
{
	struct Range
	{
		ULONG m_nFrom;
		ULONG m_nTo;
		Range * m_pNext;
	};

	Range * m_pFirstRange;
	USHORT m_nRangeCount;
	ULONG m_nTotalCount;

public:
	TYPEINFO();

	inline CntRangesItem(USHORT nWhich = 0);
	CntRangesItem(USHORT nWhich, SvStream & rStream);
	CntRangesItem(const CntRangesItem &);
	virtual ~CntRangesItem();

	CntRangesItem & operator =(const CntRangesItem & rRanges);

	virtual int operator ==(const SfxPoolItem &) const;
	virtual SfxPoolItem * Clone(SfxItemPool * = 0) const;
	virtual SfxPoolItem * Create(SvStream &, USHORT) const;
	virtual SvStream & Store(SvStream &, USHORT) const;

	USHORT Count() const { return m_nRangeCount; }
	void GetRange(USHORT nIndex, ULONG & rFrom, ULONG & rTo) const;
	void RemoveRange(USHORT nIndex);

	ULONG TotalCount() const { return m_nTotalCount; }
	ULONG TotalMin() const
	{ return m_pFirstRange ? m_pFirstRange->m_nFrom : 0; }
	ULONG TotalMax() const;

	BOOL IsWithinRanges(ULONG nValue) const;

	BOOL InsertRange(ULONG nFrom, ULONG nTo);
	BOOL RemoveRange(ULONG nFrom, ULONG nTo);
	void AddRanges(const CntRangesItem & rRanges);
	void SubtractRanges(const CntRangesItem & rRanges);

	// These funcs return either 0 or a new CntRangesItem which must be
	// deleted by the caller:
	CntRangesItem * GetIntersectRanges(const CntRangesItem & rRanges) const;
	CntRangesItem * GetSubtractRanges(const CntRangesItem & rRanges) const;
	CntRangesItem * GetDifferenceRanges(ULONG nFrom, ULONG nTo) const;
};

inline CntRangesItem::CntRangesItem(USHORT nWhich):
	SfxPoolItem(nWhich),
	m_pFirstRange(0),
	m_nRangeCount(0),
	m_nTotalCount(0)
{}

}

#endif // _CNTRANGE_HXX

