/*************************************************************************
 *
 *  $RCSfile: export.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: mhu $ $Date: 2001/07/24 19:39:12 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CHAOS_EXPORT_HXX
#define _CHAOS_EXPORT_HXX

#ifndef TOOLS_INETMIME_HXX
#include <tools/inetmime.hxx>
#endif

class INetCoreMIMEMessage;
class SfxItemSet;
class SvStream;

namespace chaos
{

//============================================================================
class CntMIMEStreamSink_Impl: public INetMIMEOutputSink
{
	SvStream & m_rStream;

	virtual void writeSequence(sal_Char const * pBegin,
							   sal_Char const * pEnd);

public:
	CntMIMEStreamSink_Impl(SvStream & rTheStream): m_rStream(rTheStream) {}

	virtual ErrCode getError();
};

//============================================================================
class CntExport
{
	enum State { STATE_FROM, STATE_HEADER, STATE_BODY };

	CntMIMEStreamSink_Impl m_aSink;
	State m_eState;

	void writeFrom(SfxItemSet const * pItems, bool bFromLine);

	void writeHeaderField(INetMIME::HeaderFieldType eType,
						  sal_Char const * pName, ByteString const & rBody,
						  rtl_TextEncoding ePreferredEncoding);

	void writeHeaderField(INetMIME::HeaderFieldType eType,
						  sal_Char const * pName, UniString const & rBody,
						  rtl_TextEncoding ePreferredEncoding);

	void writeQuotedPrintable(sal_uInt32 nChar, bool bForce = false,
							  bool bEndOfLine = false);

	void writeQuotedPrintable(SvStream & rData, sal_uInt32 nSize);

	void writeBase64(SvStream & rData, sal_uInt32 nSize);

	ErrCode writeMessage(SfxItemSet const * pItems,
						 INetCoreMIMEMessage const * pMessage, bool bBody,
						 UniString const & rNewsHost,
						 rtl_TextEncoding ePreferredEncoding);

public:
	CntExport(SvStream & rTheStream):
		m_aSink(rTheStream), m_eState(STATE_FROM) {}

	ErrCode writeMessage(SfxItemSet const & rItems,
						 UniString const * pNewsHost = 0,
						 bool bFromLine = true);

	/** Write a message without the initial From line. */
	ErrCode writeMessage(INetCoreMIMEMessage const & rMessage,
						 UniString const * pNewsHost = 0);

	ErrCode writeHeader(SfxItemSet const & rItems,
						UniString const * pNewsHost = 0);

	ErrCode writeBody(ByteString const & rLine);
};

} // namespace chaos

#endif // _CHAOS_IMPORT_HXX

