/*************************************************************************
 *
 *  $RCSfile: ConfigMgrTest.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:43 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/


import java.lang.Object;                      
import java.util.StringTokenizer;                     
import java.util.Vector;

import java.io.*;
import com.sun.star.comp.helper.RegistryServiceFactory;
import com.sun.star.comp.servicemanager.ServiceManager;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyState;
import com.sun.star.connection.XConnector;
import com.sun.star.connection.XConnection;
import com.sun.star.bridge.XBridge;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;

import com.sun.star.uno.IBridge;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;

import com.sun.star.util.ElementChange;
import com.sun.star.util.XChangesBatch;
import com.sun.star.util.XChangesNotifier;        
import com.sun.star.util.XChangesListener;
import com.sun.star.container.XNameReplace;
import com.sun.star.container.XHierarchicalNameAccess;        

public class ConfigMgrTest// implements com.sun.star.util.XChangesListener
{
	// Global Things
	// the size of the tabulator
	static String tab = "   ";
	static Vector xChangesNotifierVector = new Vector();
	static ConfigMgrTest testBridge;
    
	static String neededServices[] = new String[] {
		"com.sun.star.comp.servicemanager.ServiceManager",
		"com.sun.star.comp.loader.JavaLoader",
		"com.sun.star.comp.connections.Connector",
  		"com.sun.star.comp.connections.Acceptor"
	};
	// for the config items
	static java.util.Hashtable                      ConfigItems         = new java.util.Hashtable();
	//static com.sun.star.comp.servicemanager.ServiceManager smgr                = new com.sun.star.comp.servicemanager.ServiceManager();
	ConfigMgrTest                                   myConfigMgrTest     = null;
	static XConnection                              myConnection        = null;
	static XNamingService                           myNamingService     = null;
//---------------------------------------------------------------------------
	/**
    * main
    * 
    * 
    * 
    */
	public static void main(String args[]) throws Exception
	{	    
	    ConfigMgrTest myConfigMgrTest = new ConfigMgrTest();	    
	    boolean foundConfig = false;
	    boolean foundTestFiles = false;
	    String sTestFiles = "";
	    try
	    {
	        if ( args[0].equals("--version") ) // only when --version the first parameter
		    {
		        System.out.println("Config Manager Testprogram");
		        System.out.println("Version 1.0");		    
		        System.exit(0);    
		    }
	        for ( int i=0;i<args.length;i++) // read the arguments
	        {	            
		        if ( args[i].equals("-c") )
		        {
		            readConfigSection(args[i+1]);
		            foundConfig = true;
		        }
		        if ( args[i].equals("-t") )
		        {		            
		            sTestFiles = args[i+1];
		            foundTestFiles = true;
		        }
		    }
		    if (!foundTestFiles) // when no parameter -t found display messages and exit
		    {
		        System.out.println("No Testscriptfiles specified");
		        System.exit(0);
		    }
		    if (!foundConfig) // when no parameter -c found read the default config, if the parameter found the config is read some lines above
		    {
		        readConfigSection("config.dat");		        
		    }		    
		    // Create a new ServiceManager
		    String sRegistry = ConfigItems.get("registry").toString();
		    XMultiServiceFactory myServiceManager = RegistryServiceFactory.create(sRegistry);		    
	        if (myServiceManager == null)
	        {
    	            System.out.println("No Connect to proxy available.");
                    System.exit(0);
	        }		    
	        //
		    if ( foundTestFiles )
		    {   
		        String sTestFile = "";		     
		        StringTokenizer st = new StringTokenizer(sTestFiles,",");
		        int iFiles = st.countTokens();
		        ConfigTest [] mct = new ConfigTest[iFiles];
		        for ( int i = 0; i < iFiles;i ++)
		        {
		            sTestFile = st.nextToken();
		            System.out.println(sTestFile);		            
		            //mct[i] = new ConfigTest(sTestFile,myNamingService);
		            mct[i] = new ConfigTest(sTestFile,myServiceManager);
		            mct[i].start();
		        }		        
		        boolean stop = true;
		        // wait for all threads
		        while(stop)
		        {		            
		            stop = false;
		            for ( int i = 0 ; i < iFiles ; i++)
		            {		            
		                boolean th = mct[i].isAlive();
		                if (th)
		                {
		                    stop = true;		                    
		                }
		            }
		        }
		        // wait for all threads
		        System.out.println("END");
		        System.exit(0);
		    }
		    else
		    {
		        System.out.println("ConfigMgrTest -t <scriptfile>");
		        System.exit(0);
		    }
        }    
        catch (Exception e)
        {
            System.out.println("Config Manager Testprogram");
		    System.out.println("ConfigMgrTest -t <scriptfile>");		    		    
		    System.out.println(e);
		}
    }
    //--------------------------------------------------------------------
    /**
    * startOffice
    * start the Office 
    * @param sScriptFile     - the scriptfile in witch the office path is 
    */
    private static void startOffice()
    {   
		try
		{            
            java.lang.Runtime xRuntime = null;
            try
            {
                (xRuntime.getRuntime()).exec(ConfigItems.get("OfficePath")+"");
            }
            catch(Exception e)
            {
                System.out.println(e);
                System.exit(0);
            }
            java.lang.Thread.sleep(7000);            
        }		
		catch( Exception e)
		{
		    System.out.println(e);
		}
		
	}   

//--------------------------------------------------------------------    
    /**
    * readConfigSection
    * read the config section from the testscriptfile
    * @param sScriptFile     - the scriptfile 
    */
    private static void readConfigSection(String sScriptFile)
    {   
		BufferedReader          inFile              = null;
		int                     findConfigSection   = 0;
		int                     findConfigEnd       = 0;
		String                  sReadLine           = "";
		String                  sKey                = "";
		String                  sValue              = "";
		//StringTokenizer         StringToken         = null;
		int                     iIndex              = 0;		
		
		try
		{
		    inFile = new BufferedReader(new FileReader(new File(sScriptFile)));	  
		    
		    while ( findConfigSection != -1)
		    {
    		    sReadLine = inFile.readLine();
    		    findConfigSection = sReadLine.indexOf("// common parameters start");
    		    if (findConfigSection != -1)
    		    {
    			    sReadLine = inFile.readLine();
    			    findConfigEnd = sReadLine.indexOf("// common parameters end");
    			    while (findConfigEnd == -1)
    			    {    			           			    
    			        iIndex = sReadLine.indexOf("=");
    			        sKey = sReadLine.substring(0, iIndex);
    		            sValue = sReadLine.substring(iIndex+1);
    		            ConfigItems.put(sKey.trim(), sValue.trim());    		        
    		            sReadLine = inFile.readLine();
    			        findConfigEnd = sReadLine.indexOf("// common parameters end");
    		        }
    		        break;
    		    }
		    }
		    
		}
		catch( Exception e)
		{
		    System.out.println(e);
		}
		
	}
    
    //---------------------------------------------------------------------------	
	/**
    * connectOffice
    * connect to the StarOffice
    * 
    * 
    *
	private XConnection connectOffice()
	{	
	    XConnector      myConnector     = null;
		XConnection     myConnection    = null;
		try // get the ServiceManager
		{   
            myConnector  = (XConnector)smgr.createInstance("com.sun.star.connection.Connector");		    
            try // create the Connector
            {		       
	            if(myConnector != null)
	            {
		            try // try the connect
		            {
		                try
		                {
		                    String sHost = ConfigItems.get("host").toString();
		                    String sPort = ConfigItems.get("port").toString();
		                    myConnection = myConnector.connect("socket,host=" + sHost + ",port=" + sPort);		    
		                }
		                catch (Exception e)
		                {
		                    myConnection = myConnector.connect("socket,host=localhost,port=6001");		    
		                }
		            }
		            catch ( Exception e)
		            {
		                //System.out.println("No Connect");
		                //System.out.println(e);
		            }		        
		        }
		        else
		        {
		            System.out.println("Can't create instance com.sun.star.connection.Connector");
		            System.exit(0);
		        }		        
		    }
		    catch (Exception e)
		    {
		            System.out.println(e);
		    }
		}
		catch(Exception e)
		{
		    System.out.println(e);
		}
		return myConnection;
	}	
//---------------------------------------------------------------------------	
	/**
    * getNamingService
    * 
    * 
    * 
    *
    private static void getNamingService()
    {
	    try // getBridgeByName
	    {
	        IBridge iBridge = UnoRuntime.getBridgeByName("java", null, "remote", null, new Object[]{"iiop", myConnection, null});
	        Object rInitialObject = iBridge.mapInterfaceFrom("classic_uno", XInterface.class);
            if(rInitialObject != null)
            {
                try // get the NamingService
                {
                    myNamingService = (XNamingService)UnoRuntime.queryInterface(XNamingService.class, rInitialObject);                        
	            }
	            catch (Exception e)
	            {
	                System.out.println(e);
	            }
            }
        }
        catch(Exception e)
        {
            System.out.println(e);
            System.out.println(getTargetMessages(e));
        }
    }
    */
    //-------------------------------------------------------------------------	    
    /**
    * getTargetMessages
    * get the target messages form a TargetException
    * @param MyE    - the exception      
    */
    static private String getTargetMessages(Exception MyE)
    {
        String sMyE = MyE.toString();
        String ret = "";
		if ( sMyE.indexOf("InvocationTargetException") != -1)
		{
		    java.lang.reflect.InvocationTargetException xx = (java.lang.reflect.InvocationTargetException) MyE;
		    ret = (xx.getTargetException()).toString();
		}
		return ret;
	}
}
