/*************************************************************************
 *
 *  $RCSfile: stubs.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jl $ $Date: 2001/03/23 13:22:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBA_SHARED_STUBS_HXX_
#include "stubs.hxx"
#endif

#ifndef _CPPUHELPER_QUERYINTERFACE_HXX_
#include <cppuhelper/queryinterface.hxx>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_
#include <cppuhelper/typeprovider.hxx>
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::osl;
using namespace ::cppu;

//==========================================================================
//= OServerComponent
//==========================================================================
//--------------------------------------------------------------------------
Sequence< Type > OServerComponent::getTypes() throw (RuntimeException)
{
	OTypeCollection aTypes(::getCppuType( static_cast< Reference< XUnoTunnel >* >(NULL) ),
						   OSubComponent::getTypes());

	return aTypes.getTypes();
}

//------------------------------------------------------------------------------
Any OServerComponent::queryInterface( const Type & rType ) throw (RuntimeException)
{
	Any aReturn = OSubComponent::queryInterface( rType );
	if (!aReturn.hasValue())
		aReturn = ::cppu::queryInterface(rType,
			static_cast< XUnoTunnel * >( this )
		);
	return aReturn;
}

//------------------------------------------------------------------------------
void OServerComponent::appendStub(const Reference< XInterface >& _rxStub)
{
	m_aStubs.push_back(WeakReferenceHelper(_rxStub));
}

//------------------------------------------------------------------------------
void OServerComponent::disposing()
{
	MutexGuard aGuard(*m_pMutex);
	for (OWeakRefArray::iterator i = m_aStubs.begin(); m_aStubs.end() != i; i++)
	{
		Reference< XComponent > xComp((*i).get(), UNO_QUERY);
		if (xComp.is())
			xComp->dispose();
	}
	m_aStubs.clear();
	OSubComponent::disposing();
}

// com::sun::star::lang::XUnoTunnel
//------------------------------------------------------------------
sal_Int64 OServerComponent::getSomething( const Sequence< sal_Int8 > & rId ) throw (RuntimeException)
{
	if (rId.getLength() == 16 && 0 == rtl_compareMemory(getUnoTunnelImplementationId().getConstArray(),  rId.getConstArray(), 16 ) )
		return reinterpret_cast<sal_Int64>(this);

	return 0;
}

//------------------------------------------------------------------
::com::sun::star::uno::Sequence< sal_Int8 >	OServerComponent::getUnoTunnelImplementationId()
{
	static Sequence< sal_Int8 > * pSeq = 0;
	if( !pSeq )
	{
		::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
		if( !pSeq )
		{
			static Sequence< sal_Int8 > aSeq( 16 );
			rtl_createUuid( (sal_uInt8*)aSeq.getArray(), 0, sal_True );
			pSeq = &aSeq;
		}
	}
	return *pSeq;
}

//==========================================================================
//= OStubComponent
//==========================================================================
//------------------------------------------------------------------------------
OStubComponent::OStubComponent(OServerComponent& rServer)
	           :OShared(rServer.m_pMutex)
			   ,OSubComponent(*m_pMutex, rServer)
{
	osl_incrementInterlockedCount( &m_refCount );
	{
		Reference <XInterface> xStub(*this);
		rServer.appendStub(xStub);
	}

	sal_Int32 n = osl_decrementInterlockedCount( &m_refCount );
	OSL_ENSURE(n == 0, "OStubComponent::OStubComponent : invalid ref count !");
}

//------------------------------------------------------------------------------
sal_Int64 OStubComponent::getServer(const Sequence< sal_Int8 >& _rId) const throw( DisposedException )
{
	if (!m_xParent.is())
		throw DisposedException();

	return Reference<XUnoTunnel>(m_xParent,UNO_QUERY)->getSomething(_rId);
}


