#include "ssodlg.hxx"
#include "ssodlg.hrc"

#ifndef _VOS_PROCESS_HXX_
#include <vos/process.hxx>
#endif
#ifndef _TOOLS_STREAM_HXX_
#include <tools/stream.hxx>
#endif
#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

using namespace ::rtl;
using namespace ::vos;
using namespace ::osl;

const OUString SSOLoginDialog::sBmpFile =
	OUString::createFromAscii( "ssologin.bmp" );

SSOLoginDialog::SSOLoginDialog( Window * inParent, ResMgr * inResMgr ) :
	ModalDialog(			inParent,	ResId( DLG_SSOLOGIN,	inResMgr ) ),
	mLogo(					this,		ResId( FI_LOGO,			inResMgr ) ),
	mMessage(				this,		ResId( FT_MESSAGE,		inResMgr ) ),
	mUserNameLabel(			this,		ResId( FT_USERNAME,		inResMgr ) ),
	mUserNameEdit(			this,		ResId( ED_USERNAME,		inResMgr ) ),
	mPasswordLabel(			this,		ResId( FT_PASSWORD,		inResMgr ) ),
	mPasswordEdit(			this,		ResId( ED_PASSWORD,		inResMgr ) ),
	mSavePasswordCheckBox(	this,		ResId( CB_SAVEPASSWORD,	inResMgr ) ),
	mLine(					this,		ResId( FL_LINE,			inResMgr ) ),
	mLoginButton(			this,		ResId( BT_LOGIN,		inResMgr ) ),
	mCancelButton(			this,		ResId( BT_CANCEL,		inResMgr ) )
{	
	LoadLogo();
	mPasswordEdit.GrabFocus();
}

SSOLoginDialog::~SSOLoginDialog()
{
	FreeResource();
}

void SSOLoginDialog::LoadLogo()
{
	OUString theURL;
	OStartupInfo().getExecutableFile( theURL );
	sal_uInt32 theIndex = theURL.lastIndexOf( '/' );
	if ( theIndex > 0 )
	{
		theURL = theURL.copy( 0, theIndex + 1 );
	}
	theURL += sBmpFile;
	OUString thePath;
	FileBase::getSystemPathFromFileURL( theURL, thePath );

	SvFileStream theStream;
	theStream.Open( thePath, STREAM_READ );
	if ( theStream.GetError() == ERRCODE_NONE )
	{
		Bitmap theBitmap;
		theStream >> theBitmap;
		theStream.Close();
		Size theLogoSize = GetSizePixel();
		theLogoSize.Height() = theLogoSize.Height()/5;
		theBitmap.Scale( theLogoSize, BMP_SCALE_INTERPOLATE );
		mLogo.SetModeImage( Image( theBitmap ) );
		mLogo.SetPosSizePixel( Point( 0, 0 ), theLogoSize );
	}
}
