/*************************************************************************
 *
 *  $RCSfile: datman.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:01:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _ADR_DATMAN_HXX
#define _ADR_DATMAN_HXX

#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANCELLEDEXCEPTION_HXX_
#include <smart/com/sun/star/address/CancelledException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKSOURCEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookSourceDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTYVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredPropertyValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDVALUE_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredValue.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPROPERTYPARAMETERINFO_HXX_
#include <smart/com/sun/star/address/AddressBookPropertyParameterInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XSYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XSynchronJob.hxx>
#endif

#ifndef _SV_TIMER_HXX
#include <vcl/timer.hxx>
#endif

#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENTTYPE_HXX_
#include <smart/com/sun/star/address/JobEventType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYFUNCTION_HXX_
#include <smart/com/sun/star/address/AddressBookQueryFunction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKSCHEMATASUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookSchemataSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEDEFINITION_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOB_HXX_
#include <smart/com/sun/star/address/XJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYPARSER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryParser.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASEFIELDMAPPING_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseFieldMapping.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKJOBFACTORYSUPPLIER_HXX_
#include <smart/com/sun/star/address/XAddressBookJobFactorySupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBLISTENER_HXX_
#include <smart/com/sun/star/address/XJobListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRECORDCONTAINER_HXX_
#include <smart/com/sun/star/address/XAddressBookRecordContainer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_DATABASEDRIVERADDRESSBOOKTABLEFIELD_HXX_
#include <smart/com/sun/star/address/DatabaseDriverAddressBookTableField.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKQUERYWRITER_HXX_
#include <smart/com/sun/star/address/XAddressBookQueryWriter.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_JOBEVENT_HXX_
#include <smart/com/sun/star/address/JobEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XASYNCHRONJOB_HXX_
#include <smart/com/sun/star/address/XAsynchronJob.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKPARAMETEREDPROPERTY_HXX_
#include <smart/com/sun/star/address/AddressBookParameteredProperty.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCESIMPLEDATABASESCHEMADEFINITION_HXX_
#include <smart/com/sun/star/address/AddressBookSourceSimpleDatabaseSchemaDefinition.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKQUERYTERM_HXX_
#include <smart/com/sun/star/address/AddressBookQueryTerm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSORTINFO_HXX_
#include <smart/com/sun/star/address/AddressBookSortInfo.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_CANTCONNECTEXCEPTION_HXX_
#include <smart/com/sun/star/address/CantConnectException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_ADDRESSBOOKSOURCELDAPSCOPE_HXX_
#include <smart/com/sun/star/address/AddressBookSourceLDAPScope.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XADDRESSBOOKRESULTSETDESCRIPTORFACTORY_HXX_
#include <smart/com/sun/star/address/XAddressBookResultSetDescriptorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_ADDRESS_XJOBFACTORY_HXX_
#include <smart/com/sun/star/address/XJobFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASERECORDSTATUS_HXX_
#include <smart/com/sun/star/data/DatabaseRecordStatus.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSOROPTION_HXX_
#include <smart/com/sun/star/data/DatabaseCursorOption.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSORSUPPLIER_HXX_
#include <smart/com/sun/star/data/XDatabaseCursorSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XPREPAREDDATABASESTATEMENT_HXX_
#include <smart/com/sun/star/data/XPreparedDatabaseStatement.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASESTATEMENT_HXX_
#include <smart/com/sun/star/data/XDatabaseStatement.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEUPDATECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseUpdateCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEBOOKMARKCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseBookmarkCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEDIRECTCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseDirectCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSORTYPE_HXX_
#include <smart/com/sun/star/data/DatabaseCursorType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASERECORDMODE_HXX_
#include <smart/com/sun/star/data/DatabaseRecordMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEQUERYCOMPOSER_HXX_
#include <smart/com/sun/star/data/XDatabaseQueryComposer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEQUERYCOMPOSERFACTORY_HXX_
#include <smart/com/sun/star/data/XDatabaseQueryComposerFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XUPDATEBROADCASTER_HXX_
#include <smart/com/sun/star/form/XUpdateBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XCONFIRMDELETEBROADCASTER_HXX_
#include <smart/com/sun/star/form/XConfirmDeleteBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEFORMUPDATE_HXX_
#include <smart/com/sun/star/form/XDatabaseFormUpdate.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XUPDATELISTENER_HXX_
#include <smart/com/sun/star/form/XUpdateListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATASELECTIONTYPE_HXX_
#include <smart/com/sun/star/form/DataSelectionType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XERRORLISTENER_HXX_
#include <smart/com/sun/star/form/XErrorListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XRESTORELISTENER_HXX_
#include <smart/com/sun/star/form/XRestoreListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATABASEPARAMETEREVENT_HXX_
#include <smart/com/sun/star/form/DatabaseParameterEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XINSERTLISTENER_HXX_
#include <smart/com/sun/star/form/XInsertListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDELETELISTENER_HXX_
#include <smart/com/sun/star/form/XDeleteListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATABASEDELETEEVENT_HXX_
#include <smart/com/sun/star/form/DatabaseDeleteEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XPOSITIONINGLISTENER_HXX_
#include <smart/com/sun/star/form/XPositioningListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XBOUNDCOMPONENT_HXX_
#include <smart/com/sun/star/form/XBoundComponent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEPARAMETERLISTENER_HXX_
#include <smart/com/sun/star/form/XDatabaseParameterListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XLOADLISTENER_HXX_
#include <smart/com/sun/star/form/XLoadListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_NAVIGATIONBARMODE_HXX_
#include <smart/com/sun/star/form/NavigationBarMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XCONFIRMDELETELISTENER_HXX_
#include <smart/com/sun/star/form/XConfirmDeleteListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XERRORBROADCASTER_HXX_
#include <smart/com/sun/star/form/XErrorBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_ERROREVENT_HXX_
#include <smart/com/sun/star/form/ErrorEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_LISTSOURCETYPE_HXX_
#include <smart/com/sun/star/form/ListSourceType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEPARAMETERBROADCASTER_HXX_
#include <smart/com/sun/star/form/XDatabaseParameterBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_TABULATORCYCLE_HXX_
#include <smart/com/sun/star/form/TabulatorCycle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEFORM_HXX_
#include <smart/com/sun/star/form/XDatabaseForm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XBOUNDCONTROL_HXX_
#include <smart/com/sun/star/form/XBoundControl.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAMEACTIONLISTENER_HXX_
#include <smart/com/sun/star/frame/XFrameActionListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HXX_
#include <smart/com/sun/star/frame/XComponentLoader.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XFRAME_HXX_
#include <smart/com/sun/star/frame/XFrame.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTIONEVENT_HXX_
#include <smart/com/sun/star/frame/FrameActionEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMEACTION_HXX_
#include <smart/com/sun/star/frame/FrameAction.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XOBJECTINPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XObjectInputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XPERSISTOBJECT_HXX_
#include <smart/com/sun/star/io/XPersistObject.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_IO_XOBJECTOUTPUTSTREAM_HXX_
#include <smart/com/sun/star/io/XObjectOutputStream.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HXX_
#include <smart/com/sun/star/registry/MergeConflictException.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HXX_
#include <smart/com/sun/star/registry/XSimpleRegistry.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWDESCRIPTOR_HXX_
#include <smart/com/sun/star/awt/WindowDescriptor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_INVALIDATESTYLE_HXX_
#include <smart/com/sun/star/awt/InvalidateStyle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XTOOLKIT_HXX_
#include <smart/com/sun/star/awt/XToolkit.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XWINDOWPEER_HXX_
#include <smart/com/sun/star/awt/XWindowPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWCLASS_HXX_
#include <smart/com/sun/star/awt/WindowClass.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XSYSTEMDEPENDENTWINDOWPEER_HXX_
#include <smart/com/sun/star/awt/XSystemDependentWindowPeer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_WINDOWATTRIBUTE_HXX_
#include <smart/com/sun/star/awt/WindowAttribute.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_XPOINTER_HXX_
#include <smart/com/sun/star/awt/XPointer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_AWT_SYSTEMPOINTER_HXX_
#include <smart/com/sun/star/awt/SystemPointer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XFORMCOMPONENT_HXX_
#include <smart/com/sun/star/form/XFormComponent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HXX_
#include <smart/com/sun/star/frame/XDispatchProvider.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_XDISPATCH_HXX_
#include <smart/com/sun/star/frame/XDispatch.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_UTIL_XURLTRANSFORMER_HXX_
#include <smart/com/sun/star/util/XURLTransformer.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HXX_
#include <smart/com/sun/star/frame/FrameSearchFlag.hxx>
#endif








>>>>>>> 1.6
class AdrRegistry;
class AdrFrameController;

class AdrDataManager :	public XPropertyChangeListener,
						public XPositioningListener,
						public XLoadListener,
						public UsrObject
{
private:
		BOOL											bRecordIsInsertable;
		BOOL											bRecordIsRemovable;
		BOOL											bRecordIsModified;
		
		AdrFrameController*								pFrameController;							
		XDatabaseFormRef								xForm;
		XControlModelRef								xGridModel;
		XSimpleRegistryRef								xRegistry;
		XPropertySetRef									xSourceProps;
		XPropertySetRef									xGlobalProps;
		XDatabaseQueryComposerRef						xParser;
		UString											aActivDataSource;
		UString											aQuoteChar;
		BOOL											bIsLayoutMode;
		INT16											nTmState;
		DatabaseRecordMode								nEditMode;
		UsrAny											aUID;
		UsrAny											aNewUID;
		UsrAny											aBookmark;
		UsrAny											aNewBookmark;
		UsrAny											aTimerBookmark;
		XDatabaseBookmarkCursorRef						xAdrCursor;
		XAddressBookRecordContainerRef					xRecordContainer;
		Timer											aUpdateTimer;
		XNameAccessRef									xAdrSourceSchemata;
		Sequence<AddressBookParameteredPropertyValue>	aValueSeq;		
		Sequence<AddressBookParameteredProperty>	    aActualPropSeq;		
		Sequence<AddressBookParameteredProperty>		aRecordSchemataSeq;		
		Link											aUpdateLink;
		Link											aAdrSourceChangedHdl;
		Link											aAdrSourceRefreshHdl;
		Link											aAdrSourceSaveHdl;

		DECL_LINK( UpdateHdl, Timer*);

protected:

		XPropertySetRef				createGlobalProperties();
		void						InsertFields(
			const XFormComponentRef& xGrid);
		void						InitRegistry();
		void						SetMeAsUidListener();
		void						RemoveMeAsUidListener();
		Sequence<UString>			MakeMaxFieldList(const XNameAccessRef& xSchemata);
		void						UpdateAddressbookCursor(UString aSourceName);
		void						UpdateAddressbookCursor(const XDatabaseFormRef& xDbForm);

public:

		AdrDataManager(const XSimpleRegistryRef& xReg);
		~AdrDataManager();

		SMART_UNO_DECLARATION( AdrDataManager, UsrObject );

		BOOL 						queryInterface( UsrUik aUIK, XInterfaceRef& xRet );

		virtual void				propertyChange(const PropertyChangeEvent& evt) 
																THROWS( (UsrSystemException) );
		virtual void 				disposing( const EventObject& Source );

		virtual void				positioned(const EventObject& aEvent);

	    virtual void				loaded(const EventObject& aEvent);
		virtual void				unloaded(const EventObject& aEvent);

		XDatabaseFormRef			createDatabaseForm(const UString& rURL);
		XDatabaseFormRef			getDatabaseForm();

		XControlModelRef			createGridModel(const XDatabaseFormRef& xDbForm);
		XControlModelRef			createGridModel();
								
		void						loadDatabase();
		void						unloadDatabase();
								
		Sequence<UString>			getDataSources();
								
		UString						getActivDataSource();
		void						setActivDataSource(const UString& rURL);
								
		void						setFilter(const UString& rQuery);
		UString						getFilter();
								
		Sequence<UString>			getQueryFields();
		void						setQueryField(const UString& rField);
		UString						getQueryField();
		void						startQueryWith(const UString& rQuery);
		UString						getQueryString();
		XDatabaseQueryComposerRef	getParser();

		void						saveGridModel(const XControlModelRef& xDbForm);
		XControlModelRef			loadGridModel(const UString& rName);

		void						setBeamerSize(long nSize);
		long						getBeamerSize();
		void						setViewSize(long nSize);
		long						getViewSize();
									
		XPropertySetRef				getViewProperties();

		XPropertySetRef				getChildViewProperties(const UString& rName);

		UString						getControlName(INT32 nFormatKey );

		XControlModelRef			loadControlModel(const UString& rName);
		void						saveCtrModel(const UString& rName,
													const XControlModelRef& rCtrModel);

		void						EnableLayoutMode(BOOL bFlag=TRUE);
		BOOL						isLayoutMode(){ return bIsLayoutMode;}

		DatabaseRecordMode			getRecordMode(){ return nEditMode;}
		void						saveRecord();
		void						editRecord();
		void						removeRecord();
		void						insertRecord();
		void						setRecordModified() {bRecordIsModified=TRUE;}

		BOOL					    IsRecordInsertable(UString* pSchemata=NULL);
		BOOL					    IsRecordRemovable() {return bRecordIsRemovable;}

		void						RemoveAvailableField(const UString& aClassName,const Sequence<UString>& seqParas);
		UsrAny						getAvailableField(const UString& aClassName,const Sequence<UString>& aSubSet, 
													BOOL* pReadOnly=NULL);

		UsrAny						getFieldValue(const UString& aClassName,const Sequence<UString>& seqParas, 
													BOOL* pReadOnly=NULL);
		
		void						saveFieldValue(const UString& aClassName,AddressBookParameteredValue aValue);
		
		BOOL						HasEqualParas(const Sequence<UString>& seqParas, const Sequence<UString>& aSubSet, 
													BOOL bEqualLength=FALSE);

		XNameAccessRef				GetSourceSchemata();
		
		INT32						GetMaxFieldCount(const UString& aClassName,const Sequence<UString>& seqParas);
		INT32						GetMaxFieldCount();
		void						CreateFields();

		void						SetFrameController(AdrFrameController* pCtr) {pFrameController=pCtr;}
		AdrFrameController*			GetFrameController() {return pFrameController;}

		void						SetUpdateHdl( const Link& rLink ) { aUpdateLink = rLink; }
		const Link& 				GetUpdateHdl() const { return aUpdateLink; }

		void						SetAdrSourceChangedHdl( const Link& rLink ) { aAdrSourceChangedHdl = rLink; }
		const Link& 				GetAdrSourceChangedHdl() const { return aAdrSourceChangedHdl; }

		void						SetAdrSourceRefreshHdl( const Link& rLink ) { aAdrSourceRefreshHdl = rLink; }
		const Link& 				GetAdrSourceRefreshHdl() const { return aAdrSourceRefreshHdl; }

		void						SetAdrSourceSaveHdl( const Link& rLink ) { aAdrSourceSaveHdl = rLink; }
		const Link& 				GetAdrSourceSaveHdl() const { return aAdrSourceSaveHdl; }

};

typedef AdrDataManager*		AdrDataManagerPtr;
typedef AdrDataManagerPtr*  AdrDataManagerHdl;

#endif
