/*************************************************************************
 *
 *  $RCSfile: inetset.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2000/11/14 15:02:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __EXTENSIONS_INSTALLATION_SYSTEM_INETSET_INETSET_HXX__
#define __EXTENSIONS_INSTALLATION_SYSTEM_INETSET_INETSET_HXX__ \
    "$Revision: 1.2 $"

#ifndef _SV_CONFIG_HXX
#include <vcl/config.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _INETTYPE_HXX
#include <svtools/inettype.hxx>
#endif

#include "cntsupp.hxx"

#ifndef _SVTOOLS_CTYPEITM_HXX
#include <svtools/ctypeitm.hxx>
#endif

#ifndef _VOS_PROFILE_HXX_
#include <vos/profile.hxx>
#endif

#ifndef _OSL_SECURITY_H_
#include <osl/security.h>
#endif

#include <rtl/string.hxx>
#include <rtl/ustring.hxx>
#include <tools/fsys.hxx>
#include <tools/resmgr.hxx>

#include <com/sun/star/container/XNameAccess.hpp>
#include <com/sun/star/reflection/XIdlClass.hpp>
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>

#ifndef _CPPU_WEAK_HXX_
#include<cppuhelper/weak.hxx>
#endif

#define INETSET_SERVICE_NAME        \
    "com.sun.star.installation.InternetSettings"
#define INETSET_IMPLEMENTATION_NAME \
    "com.sun.star.installation.InternetSettings.V10"

enum mailTypes {
    mtUnknown = 0,
    mtStarOffice = 1,
    mtNetscape = 2,
    mtOutlook = 3
};

enum serverTypes {
    stUnknown = 0,
    stSMTP = 1,
    stPOP = 2,
    stUNSENT = 3,
    stIMAP = 4
};

class Directory;

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::reflection;

typedef struct
{
    rtl::OUString name;
    Any value;
    Directory *dir;
} Entry;

Entry *doCreateData(const rtl::OUString &aName, const Any &aValue);

inline Entry *createData(const rtl::OUString &aName, const Any &aValue) {
    return doCreateData(aName, aValue); }

inline Entry *createData(const rtl::OUString &aName,
                         const rtl::OUString &aValue) {
    return doCreateData(aName, Any(makeAny(aValue))); }

inline Entry *createData(const char *aName, const rtl::OUString &aValue) {
    return doCreateData(rtl::OUString::createFromAscii(aName), Any(makeAny(aValue))); }

inline Entry *createData(const char *aName, const char *aValue) {
    return doCreateData(rtl::OUString::createFromAscii(aName),
                        Any(makeAny(rtl::OUString::createFromAscii(aValue))));
}

inline Entry *createNumData(const rtl::OUString &aName,
                            const rtl::OUString &aValue) {
    sal_Int32 i = (sal_Int32) aValue.toInt32();
    Any a;
    a <<= i;
    return doCreateData(aName, a);
}

inline Entry *createNumData(const rtl::OString &aName,
                            const rtl::OUString &aValue) {
    return createNumData(rtl::OUString::createFromAscii(aName), aValue); }

inline Entry *createNumData(const rtl::OUString &aName,
                            const rtl::OString &aValue) {
    return createNumData(aName, rtl::OUString::createFromAscii(aValue)); }

inline Entry *createNumData(const rtl::OString &aName,
                            const rtl::OString &aValue) {
    return createNumData(rtl::OUString::createFromAscii(aName),
                         rtl::OUString::createFromAscii(aValue)); }


inline Entry *createNum16Data(const rtl::OUString &aName,
                              const rtl::OUString &aValue) {
    sal_Int16 i = (sal_Int16) aValue.toInt32();
    Any a;
    a <<= i;
    return doCreateData(aName, a);
}

inline Entry *createNum16Data(const rtl::OString &aName,
                              const rtl::OUString &aValue) {
    return createNum16Data(rtl::OUString::createFromAscii(aName), aValue); }

inline Entry *createNum16Data(const rtl::OUString &aName,
                              const rtl::OString &aValue) {
    return createNum16Data(aName, rtl::OUString::createFromAscii(aValue)); }

inline Entry *createNum16Data(const rtl::OString &aName,
                              const rtl::OString &aValue) {
    return createNum16Data(rtl::OUString::createFromAscii(aName),
                           rtl::OUString::createFromAscii(aValue)); }

inline Entry *createNum(const rtl::OUString &aName, sal_Int32 aValue) {
    Any a;
    a <<= aValue;
    return doCreateData(aName, a);
}

inline Entry *createNum(const char *aName, sal_Int32 aValue) {
    return createNum(rtl::OUString::createFromAscii(aName), aValue); }

Entry *createSub(const rtl::OUString &aName, Directory *aDirectory);

inline Entry *createSub(const char *aName, Directory *aDirectory) {
    return createSub(rtl::OUString::createFromAscii(aName), aDirectory); }

Entry *copyEntry(Entry *e);

char *readFile(const char *name, const char *mode);
sal_Bool testFile(const char *name);
int find(char *src, char *search);
char *seekBehind(char *src, const char *seek);

class Directory : public XNameAccess, public ::cppu::OWeakObject {
public:
    sal_Bool mbIsRoot;
    int mnSize, mnUsed;
    Entry **maEntries;
    void copySub(Directory *src, Directory *dst, const rtl::OUString &name);
public:
/* --- Methods of XInterface ---------------------------------------------- */
    virtual Any SAL_CALL queryInterface(const Type& aType)
        throw(RuntimeException);
    virtual void SAL_CALL acquire() throw(RuntimeException)
        { OWeakObject::acquire(); };
    virtual void SAL_CALL release() throw(RuntimeException)
        { OWeakObject::release(); };
/* --- Methods of XElementAccess ------------------------------------------ */
    virtual Type SAL_CALL getElementType() throw(RuntimeException);
    virtual sal_Bool SAL_CALL hasElements(void) throw(RuntimeException);
/* --- Methods of XNameAccess --------------------------------------------- */
    virtual Any SAL_CALL getByName(const rtl::OUString& Name)
        throw(NoSuchElementException, WrappedTargetException,
              RuntimeException);
    virtual Sequence<rtl::OUString> SAL_CALL getElementNames()
        throw(RuntimeException);
    virtual sal_Bool SAL_CALL hasByName(const rtl::OUString& aName)
        throw(RuntimeException);
/* --- Methods of Directory ----------------------------------------------- */
    Directory(sal_Bool isRoot);
    ~Directory();
    Directory *_createSub(const rtl::OUString& aSubName);
    Entry *get(const rtl::OUString& aName) const;
    int indexOf(const rtl::OUString& aName) const;
    int insert(Entry *aEntry);
    int insert(Entry *aEntry, const rtl::OUString& aPath);
    inline int insert(Entry *aEntry, const String& aPath) {
        return insert(aEntry, rtl::OUString(aPath));
    };
    inline int insert(Entry *aEntry, const rtl::OString& aPath) {
        return insert(aEntry, rtl::OUString::createFromAscii(
          aPath));
    };
    sal_Bool remove(const rtl::OUString& aName);
};

void readStarOffice(Directory *root);

#ifdef SAL_W32
void readNetscape(Directory *root);
void readIExplorer(Directory *root);
void readOutlook(Directory *root);
#endif

#ifdef SAL_UNX
void readNetscape(Directory *root);
#endif

#endif

