/*************************************************************************
 *
 *  $RCSfile: asyncloadthread.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: as $ $Date: 2002/07/29 08:15:37 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef __FRAMEWORK_HELPER_ASYNCLOADTHREAD_HXX_
#define __FRAMEWORK_HELPER_ASYNCLOADTHREAD_HXX_

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_HELPER_LOADEVENTLISTENER_HXX_
#include <helper/loadeventlistener.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_THREADHELPBASE_HXX_
#include <threadhelp/threadhelpbase.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XINTERFACE_HXX_
#include <macros/xinterface.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_XTYPEPROVIDER_HXX_
#include <macros/xtypeprovider.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_FRAME_XCOMPONENTLOADER_HPP_
#include <com/sun/star/frame/XComponentLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAMELOADER_HPP_
#include <com/sun/star/frame/XFrameLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XLoadEventListener_HPP_
#include <com/sun/star/frame/XLoadEventListener.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_URL_HPP_
#include <com/sun/star/util/URL.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
#include <com/sun/star/task/XInteractionHandler.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONREQUEST_HPP_
#include <com/sun/star/task/XInteractionRequest.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONABORT_HPP_
#include <com/sun/star/task/XInteractionAbort.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XINTERACTIONFILTERSELECT_HPP_
#include <com/sun/star/document/XInteractionFilterSelect.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_AMBIGOUSFILTERREQUEST_HPP_
#include <com/sun/star/document/AmbigousFilterRequest.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _THREAD_HXX_
#include <osl/thread.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	exported definitions
//_________________________________________________________________________________________________________________

/**
    @short      This struct holds all neccessary informations alive, which must be available
                after an asynchronous load process finish.
    @descr      It uses an asnychronoues frame loader object internaly and wait till it finish.
                After that it returns the result of the operation.

    @modified   12.07.2002 14:50
    @by         Andreas Schlns
 */
class AsyncLoadThread : private ThreadHelpBase
                      , public  ::osl::Thread
{
    //_____________________________________
    // member
    private:

        /// reference to the target frame which is used for loading
        css::uno::Reference< css::frame::XFrame > m_xFrame;
        /// holds the async loader
        css::uno::Reference< css::frame::XFrameLoader > m_xLoader;
        /// original URL for this request
        css::util::URL m_aURL;
        /// the original MediaDescriptor
        css::uno::Sequence< css::beans::PropertyValue > m_lDescriptor;
        /// used as listener for the load request (must come from outside!) And we hold it as interface AND as object reference!
        LoadEventListener* m_pExternalListener;
        LoadEventListener* m_pOwnListener;
        css::uno::Reference< css::frame::XLoadEventListener > m_xListener;

    //_____________________________________
    // c++ interface
    public:

        //_________________________________
        /**
            @short initialize a new instance of this thread class with all neccessary values
                   but don't start it

            @param xFrame
                    reference to the target frame which is used for loading

            @param xloader
                    reference to the async loader object

            @param aURL
                    URL for loading

            @param lDescriptor
                    optional MediaDescriptor for loading

            @param pListener
                    an external listener for load finished events
                    In case we don't get anyone, we use our own one.
                    So the started load thread wait for finishing the load request
                    in every case. We must use the pointer to have access on the implementation.
                    But we use it only, if an uno reference (holded to the same object) is valid too!
         */
        AsyncLoadThread( const css::uno::Reference< css::frame::XFrame >&       xFrame      ,
                         const css::uno::Reference< css::frame::XFrameLoader >& xLoader     ,
                         const css::util::URL                                   aURL        ,
                         const css::uno::Sequence< css::beans::PropertyValue >& lDescriptor ,
                               LoadEventListener*                               pListener   );

        //_________________________________
        /**
            @short      start the thread
            @descr      It starts loading of the document and block till the request finish his work.
                        During this time an outside process can wait for finishing of this process.

            @attention  Waiting cant be done by using thread methods like join()!
                        Because it's not possible to implement an interface (with using OWeakObject)
                        and a thread at the same class - you must use a LoadEventListener seperated from
                        this load thread too. He provides a wait method which use a condition.
                        Combination of both classes make waiting possible. Otherwhise it's
                        a "ping" only!

            @seealso    ::osl::Thread
         */
        void SAL_CALL run();

        //_________________________________
        /**
            @short      forget all used ressources
            @descr      If this thread was finished, we must forget all internal used references.
                        Otherwhise these objects can't die realy.

            @seealso    ::osl::Thread
         */
        void SAL_CALL onTerminated();
};

} // namespace framework

#endif // #ifndef __FRAMEWORK_HELPER_ASYNCLOADTHREAD_HXX_
