/*************************************************************************
 *
 *  $RCSfile: testhtml.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: pl $ $Date: 2001/09/04 17:21:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <goodies/htmlview.hxx>

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#ifndef _STREAM_HXX //autogen
#include <tools/stream.hxx>
#endif


#ifndef _SV_PRINT_HXX //autogen
#include <vcl/print.hxx>
#endif

#ifndef _PRNDLG_HXX //autogen
#include <vcl/prndlg.hxx>
#endif

#ifndef _FACTORY_HXX //autogen
#include <so3/factory.hxx>
#endif


#include <goodies/hlpstyle.hxx>


class MyApp : public Application
{
public:
	virtual void Main();
};

class HTMLWindow : public WorkWindow
{
private:
	SimpleHTMLViewer	maView;


protected:
	virtual void    Resize();

public:
					HTMLWindow();
					~HTMLWindow();
};

HTMLWindow::HTMLWindow()
	: 	WorkWindow( NULL, WB_APP|WB_STDWORK ),
		maView( this )
{
	maView.GetStyle( "HTML_STDSTYLE" )->GetFontName() = "Arial";
	maView.Show();
	SvFileStream aStream( "d:\\x.html", STREAM_READ );
	maView.ShowHTML( aStream );
}

HTMLWindow::~HTMLWindow()
{
}

void HTMLWindow::Resize()
{
	maView.SetPosSizePixel( Point(0,0), GetOutputSizePixel() );
	BOOL bDebug = FALSE;
	if ( bDebug )
	{
		Printer* pPrn = new Printer;
//		PrinterSetupDialog aDlg( this, WB_STDWORK );
//		aDlg.SetPrinter( pPrn );
//		aDlg.Execute();
//		aDlg.SetPrinter( 0 );
		pPrn->SetPageQueueSize( 1 );
		pPrn->StartJob( "Test!!!" );
		maView.Print( pPrn );
		pPrn->EndJob();
		// delete pPrn;
	}
}

void MyApp::Main()
{
//	SvFactory::Init();

	HTMLWindow aWindow;
	aWindow.Show();

	Execute();
}

MyApp aMyApp;
