/*
 * MakeModule.java
 *
 * Created on May 31, 2002, 5:11 PM
 */

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.StringBuffer;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.Map;


/** This application creates a NetBeans Module for the OpenOffice.org Support.
 * @author Bertram Nolte
 * @version 1.0
 */
public class MakeModule {
    private static String stringTopDirectory = "./";
        
    /** Creates new MakeModule */
    public MakeModule() {
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        // Create a new file instance for the directory.
        File fileInfoDirectory = new File( stringTopDirectory, "Info/" );
        
        // Create a directory for the module information.
        fileInfoDirectory.mkdirs();
        
        // Create a new file instance for the information.
        File fileInfo = new File( fileInfoDirectory, "info.xml" );
        
        // Name of the jar module.
        String stringJarName = "oosupport.jar";
        
        // Create a new file instance for the module.
        File fileModule = new File( stringTopDirectory,
        "netbeans/modules/" + stringJarName );
        
        // NBM name.
        String stringModuleName = "oosupport.nbm";
        
        // Address of the homepage.
        String stringHomepage = "http://www.openoffice.org/";
        
        // Address of the distribution page.
        String stringDistribution = "http://www.openoffice.org/";
        
        // Name of the file, containing the license.
        String stringLicense = "openoffice-nbm-license.txt";
        
        // The module needs a restart of the IDE.
        String stringNeedsRestart = "true";
        
        try {
            // Create a jar file for reading the manifest.
            JarFile jarfileModule = new JarFile( fileModule );

            // Get the main attributes of the manifest.
            Attributes attributes =
            jarfileModule.getManifest().getMainAttributes();
            
            // Create an output stream for the information file.
            OutputStream outputstreamInfo = new FileOutputStream( fileInfo );
            try {
                // Create a new print writer in order to add information.
                PrintWriter printwriter = new PrintWriter(
                new OutputStreamWriter( outputstreamInfo, "UTF-8" ) );
                
                // Write the XML header.
                printwriter.println(
                "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" );
                
                // Get the code base name.
                String stringCodeNameBase =
                attributes.getValue( "OpenIDE-Module" );
                
                // Strip major release number if any.
                int intIndexReleaseNumber = 
                stringCodeNameBase.lastIndexOf( '/' );
                
                // If there is a release number.
                if ( intIndexReleaseNumber != -1 ) {
                    // Get the name without the release number.
                    stringCodeNameBase = stringCodeNameBase.substring( 0, 
                    intIndexReleaseNumber );
                }
                
                // Write the code base name.
                printwriter.println( "<module codenamebase=\""
                + stringCodeNameBase + "\"" );
                
                // Write the project homepage.
                printwriter.println( "        homepage=\""
                + xmlEscape( stringHomepage ) + "\"" );
                
                // Write the distribution address.
                printwriter.println( "        distribution=\""
                + xmlEscape( stringDistribution ) + "\"" );
                
                // Write the license name.
                printwriter.println( "        license=\""
                + xmlEscape( stringLicense ) + "\"" );
                
//                printwriter.println("        downloadsize=\"0\"");
                
                // Write the needs restart.
                printwriter.println( "        needsrestart=\""
                + stringNeedsRestart + "\"" );
                
                // Write end of tag module.
                printwriter.println( ">" );
                
                // Write manifest attributes.
                printwriter.print("  <manifest ");
                
                // Is this the first line?
                boolean booleanFirstLine = true;
                
                // Returns an iterator over the attribute set.
                Iterator iterator = attributes.entrySet().iterator();
                
                // For every attribute in the set.
                while ( iterator.hasNext() ) {
                    // Get the next attribute.
                    Map.Entry entry = ( Map.Entry ) iterator.next();
                    
                    // Get the name of the attribute.
                    String stringName = 
                    ( ( Attributes.Name )entry.getKey() ).toString();
                    
                    // Ignore irrelevant attributes:
                    if ( ! stringName.startsWith( "OpenIDE-Module" ) ) {
                        continue;
                    }
                    
                    if ( stringName.equals(
                    "OpenIDE-Module-Localizing-Bundle" ) ) {
                        continue;
                    }
                    
                    if ( stringName.equals( "OpenIDE-Module-Install" ) ) {
                        continue;
                    }
                    
                    if ( stringName.equals( "OpenIDE-Module-Layer" ) ) {
                        continue;
                    }
                    
                    if ( stringName.equals( "OpenIDE-Module-Description" ) ) {
                        continue;
                    }
                    
                    // No indentation in the first line.
                    if ( booleanFirstLine ) {
                        booleanFirstLine = false;
                    }
                    else {
                        printwriter.print("            ");
                    }
                    
                    // Write attribute name and value.
                    printwriter.println( stringName + "=\"" 
                    + xmlEscape( ( String ) entry.getValue() ) + "\"" );
                }
                
                // write end of tag manifest.
                printwriter.println("  />");
                
                // Write license name.
                printwriter.print("  <license name=\"" 
                + xmlEscape( stringLicense ) + "\">");
                
                // Create string buffer for files to be added.
                StringBuffer stringbuffer = new StringBuffer();
                
                try {
                    // Create a file input stream for the license.
                    InputStream inputstream = new FileInputStream(
                    new File( stringTopDirectory, stringLicense ) );
                    
                    try {
                        // Create a reader of the input stream.
                        Reader reader = new InputStreamReader( inputstream );
                        
                        // Create a character array.
                        char[] charBuffer = new char[ 4096 ];
                        
                        // Declare a variable for the length of the buffer.
                        int intLength;
                        
                        // While buffer is not empty:
                        while ( ( intLength = reader.read( charBuffer ) )
                        != -1 ) {
                            // Append string buffer.
                            stringbuffer.append( charBuffer, 0, intLength );
                        }
                    }
                    finally {
                        // Close the input stream.
                        inputstream.close();
                    }
                }
                catch( IOException ioexception ) {
                    System.out.println( ioexception.getMessage() );
                }
                
                // Write the license to the information file.
                printwriter.println(
                "<![CDATA[" + stringbuffer.toString() + "]]>" );
                
                // Write end of tag license.
                printwriter.println("</license>");
                
                // Write end of the tag module.
                printwriter.println("</module>");
                
                // Flush the stream.
                printwriter.flush();
            } finally {
                // Close output stream.
                outputstreamInfo.close();
            }
            
            // Close the jar file.
            jarfileModule.close();
        }
        catch( IOException ioexception ) {
            System.out.println( ioexception.getMessage() );
        }
        
        // Initialize the jar output stream with null.
        JarOutputStream jaroutputstream = null;
        
        try {
            // Create a new jar output stream.
            jaroutputstream = new JarOutputStream(new FileOutputStream( 
            stringTopDirectory + stringModuleName ),
            new Manifest());
        }
        catch( IOException ioexception ) {
        }
        
        // Print information.
        System.out.println( stringModuleName + " created.");

        // Create a string array for the file names to be added to the jar.
        String[] stringFileName = { 
            "Info/info.xml", 
            "netbeans/modules/oosupport.jar"
        };
        
        try {
            // Allocate a buffer for reading the input files.
            byte[] byteBuffer = new byte[ 1024 ];
            
            // Hold the number of bytes read.
            int intBytesRead;
            
            // Loop through the file names.
            for (int i = 0; i < stringFileName.length; i++ ) {
                // Get the file name.
                String fileName = stringFileName[ i ];
                
                try {
                    // Create a file input stream and open the file.
                    FileInputStream fileinputstream = 
                    new FileInputStream( fileName );
                    
                    try {
                        // Create a jar entry.
                        JarEntry jarentry = new JarEntry( fileName );
                        
                        //  Add the jar entry to the jar.
                        jaroutputstream.putNextEntry(jarentry);
                        
                        // Read the file. While there are bytes to process:
                        while ( ( intBytesRead =
                        fileinputstream.read( byteBuffer ) ) != -1 ) {
                            // Write the bytes to the jar file.
                            jaroutputstream.write( byteBuffer, 0, 
                            intBytesRead );
                        }
                        
                        // Print information.
                        System.out.println( jarentry.getName() + " added." );
                    }
                    catch (Exception ex) {
                        System.out.println(ex);
                    }
                    finally {
                        // Close the file input stream.
                        fileinputstream.close();
                    }
                }
                catch ( IOException ioexception ) {
                    System.out.println( ioexception );
                }
            }
        }
        finally {
            try {
                // Close the jar output stream.
                jaroutputstream.close();
            }
            catch( IOException ioexception ) {
            }
            
            // Print information.
            System.out.println( stringModuleName + " closed." );
        }
    }
    
    // Similar to org.openide.xml.XMLUtil methods.
    private static String xmlEscape(String s) {
        int max = s.length();
        StringBuffer s2 = new StringBuffer((int)(max * 1.1 + 1));
        for (int i = 0; i < max; i++) {
            char c = s.charAt(i);
            switch (c) {
                case '<':
                    s2.append("&lt;");
                    break;
                case '>':
                    s2.append("&gt;");
                    break;
                case '&':
                    s2.append("&amp;");
                    break;
                case '"':
                    s2.append("&quot;");
                    break;
                default:
                    s2.append(c);
                    break;
            }
        }
        return s2.toString();
    }
    
    private void runJavaHelpIndexer() {
        //        // Name of the documenation directory.
        //        String stringDocumentationDirectory = "docs";
        //
        //        // Create a new file instance for the directory.
        //        File fileDocumentationDirectory =
        //        new File( stringTopDirectory + File.pathSeparator
        //        + stringDocumentationDirectory, "Info/" );
        //
        //        // Create a directory for the module information.
        //        fileDocumentationDirectory.mkdirs();
        //
        //        // Create a new file instance for the information.
        //        File fileInfo = new File( fileDocumentationDirectory, "info.xml" );
    }
}
