package org.netbeans.modules.openoffice;

/*
 * InstallationPanel.java
 *
 * Created on April 24, 2002, 2:07 PM
 */

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import java.io.File;

/**
 *
 * @author  Bertram Nolte
 */
public class InstallationPanel extends javax.swing.JPanel {

    /** Creates new form jpanelInstallation */
    public InstallationPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jlabelSDKDirectory = new javax.swing.JLabel();
        jtextfieldSDKDirectory = new javax.swing.JTextField();
        jbuttonSDKDirectory = new javax.swing.JButton();
        jlabelOfficeDirectory = new javax.swing.JLabel();
        jtextfieldOfficeDirectory = new javax.swing.JTextField();
        jtextareaIntroduction = new javax.swing.JTextArea();
        jbuttonOfficeDirectory = new javax.swing.JButton();
        
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        jlabelSDKDirectory.setText("Installation directory of the OpenOffice.org SDK:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(jlabelSDKDirectory, gridBagConstraints1);
        
        jtextfieldSDKDirectory.setToolTipText("Enter the absolute path to the SDK directory");
        jtextfieldSDKDirectory.setPreferredSize(new java.awt.Dimension(200, 20));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(jtextfieldSDKDirectory, gridBagConstraints1);
        
        jbuttonSDKDirectory.setText("Browse");
        jbuttonSDKDirectory.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbuttonSDKDirectoryActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(jbuttonSDKDirectory, gridBagConstraints1);
        
        jlabelOfficeDirectory.setText("Installation directory of the OpenOffice.org:");
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(jlabelOfficeDirectory, gridBagConstraints1);
        
        jtextfieldOfficeDirectory.setPreferredSize(new java.awt.Dimension(200, 20));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(jtextfieldOfficeDirectory, gridBagConstraints1);
        
        jtextareaIntroduction.setLineWrap(true);
        jtextareaIntroduction.setRows(19);
        jtextareaIntroduction.setText("The OpenOffice.org software is a complete,feature-rich office productivity product, that provides in combination with the OpenOffice.org Developer Kit (ODK) all the essential tools for building and deploying custom solutions to build on, or integrate with, the OpenOffice.org suite of products.\n\nThe ODK is a set of tools, libraries, jar files, header files and idl files which are necessary to develop components for the OpenOffice.org using the OpenOffice API and the OpenOffice.org component technology UNO (Universal Network Objects).\n\nFurther on, the ODK is the basic stuff for external developers to develop components in any language for which a binding exists. Currently there are language bindings for OpenOffice.org Basic, Java and different C++ compilers on different platforms for OpenOffice.org without using OpenOffice.org build environment, thus covering the two most commonly used programming languages. There will be no limit for office automation in heterogeneous environments.\n\nCurrently supported platforms of the ODK are Linux, Solaris (sparc) and Windows.\n\nIn order to get to know the OpenOffice.org reference manual and some examples (C++, Java, and Basic), which demonstrate the UNO technology and the use of the OpenOffice.org API, you can visit http://api.openoffice.org/.");
        jtextareaIntroduction.setWrapStyleWord(true);
        jtextareaIntroduction.setPreferredSize(new java.awt.Dimension(500, 320));
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(jtextareaIntroduction, gridBagConstraints1);
        
        jbuttonOfficeDirectory.setText("Browse");
        jbuttonOfficeDirectory.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jbuttonOfficeDirectoryActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 2;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.insets = new java.awt.Insets(1, 1, 1, 1);
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        add(jbuttonOfficeDirectory, gridBagConstraints1);
        
    }//GEN-END:initComponents

    private void jbuttonOfficeDirectoryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbuttonOfficeDirectoryActionPerformed
        JFileChooser jfilechooser = new JFileChooser();
        jfilechooser.setFileSelectionMode( 1 );
        Component componentParent =
        ( ( JButton ) evt.getSource() ).getParent();
        jfilechooser.setDialogTitle(
        "Select the OpenOffice.org installation directory" );
        if ( jfilechooser.showDialog(
        componentParent, "Select" ) == 0 ) {
            File file = jfilechooser.getSelectedFile();
            if ( file != null )
                jtextfieldOfficeDirectory.setText( file.getPath() );
        }
    }//GEN-LAST:event_jbuttonOfficeDirectoryActionPerformed

    private void jbuttonSDKDirectoryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jbuttonSDKDirectoryActionPerformed
        JFileChooser jfilechooser = new JFileChooser();
        jfilechooser.setFileSelectionMode( 1 );
        Component componentParent =
        ( ( JButton ) evt.getSource() ).getParent();
        jfilechooser.setDialogTitle(
        "Select the OpenOffice.org SDK installation directory" );
        if ( jfilechooser.showDialog(
        componentParent, "Select" ) == 0 ) {
            File file = jfilechooser.getSelectedFile();
            if ( file != null )
                jtextfieldSDKDirectory.setText( file.getPath() );
        }
    }//GEN-LAST:event_jbuttonSDKDirectoryActionPerformed

    protected final String getSDKDirectory() {
        return jtextfieldSDKDirectory.getText();
    }    

    public final String getOfficeDirectory() {
        return jtextfieldOfficeDirectory.getText();
    }    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jlabelSDKDirectory;
    private javax.swing.JTextField jtextfieldSDKDirectory;
    private javax.swing.JButton jbuttonSDKDirectory;
    private javax.swing.JLabel jlabelOfficeDirectory;
    private javax.swing.JTextField jtextfieldOfficeDirectory;
    private javax.swing.JTextArea jtextareaIntroduction;
    private javax.swing.JButton jbuttonOfficeDirectory;
    // End of variables declaration//GEN-END:variables

}
