
package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import org.netbeans.modules.openoffice.wizard.panels.idl.AttributePanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.netbeans.modules.openoffice.wizard.keys.*;

import org.openide.nodes.*;
import java.util.Vector;


public class AttributeNode extends LeafNode
    implements org.openide.nodes.Node.Cookie
{

    public AttributeNode(NameKey namedkey)
    {
        super(namedkey);
        getCookieSet().add(this);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/attribute");
    }

    public String generateSelf(int i)
    {
        String s = new String();
        String s1 = new String();
        for(int j = 0; j < i; j++)
            s1 = s1 + "    ";

        AttributeKey attributekey = (AttributeKey)key;
        s = s1 + "[ ";
        if(attributekey.isReadOnly())
            s = s + "readonly ";
        s = s + "attribute ] " + attributekey.getType() + " " + getName() + ";\n";
        return s;
    }

    public BasePanel getEditPanel()
    {
        AttributePanel attributepanel = new AttributePanel();
        String s = ((AttributeKey)key).getType();
        boolean flag = ((AttributeKey)key).isReadOnly();
        attributepanel.setName(getName());
        attributepanel.setType(s);
        attributepanel.setReadOnly(flag);
        return attributepanel;
    }

    public void reInit(BasePanel BasePanel)
    {
        if(BasePanel instanceof AttributePanel)
        {
            String s = ((AttributePanel)BasePanel).getName();
            String s1 = ((AttributePanel)BasePanel).getType();
            boolean flag = ((AttributePanel)BasePanel).isReadOnly();
            if(!getName().equals(s))
            {
                setName(s);
                ((AttributeKey)key).setName(s);
            }
            if(!s1.equals(((AttributeKey)key).getType()))
                ((AttributeKey)key).setType(s1);
            if(flag != ((AttributeKey)key).isReadOnly())
                ((AttributeKey)key).setReadOnly(flag);
        }
    }

    public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
    
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/attribute";
}
