
package org.netbeans.modules.openoffice.wizard.panels.idl;

import java.awt.*;
import java.util.ResourceBundle;
import javax.swing.*;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
//import org.netbeans.modules.openoffice.wizard.nodes.utils.IdlUtilities;


public class UnionPanel extends BasePanel
    implements DocumentListener
{

    public UnionPanel()
    {
        initComponents();
        postInitComponents();
    }

    private void postInitComponents()
    {
        name.getDocument().addDocumentListener(this);
        type.getDocument().addDocumentListener(this);
    }

    private void initComponents()
    {
        jLabel1 = new JLabel();
        jLabel2 = new JLabel();
        name = new JTextField();
        name.setPreferredSize(new Dimension(100, 16));
        name.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TIP_UnionName"));
        type = new JTextField();
        type.setPreferredSize(new Dimension(100, 16));
        type.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TIP_UnionDiscriminator"));
        setLayout(new GridBagLayout());
        jLabel1.setText(ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TXT_ModuleName"));
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(8, 8, 4, 4);
        gridbagconstraints.anchor = 17;
        add(jLabel1, gridbagconstraints);
        jLabel2.setText(ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle").getString("TXT_DiscriminatorType"));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.insets = new Insets(4, 8, 8, 4);
        gridbagconstraints.anchor = 17;
        add(jLabel2, gridbagconstraints);
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(8, 4, 4, 8);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(name, gridbagconstraints);
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(4, 4, 8, 8);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        add(type, gridbagconstraints);
        setPreferredSize(new Dimension(250, 88));
    }

    public String getName()
    {
        return name.getText().trim();
    }

    public void setName(String s)
    {
        name.setText(s);
    }

    public String getType()
    {
        return type.getText().trim();
    }

    public void setType(String s)
    {
        type.setText(s);
    }

    private void checkState()
    {
//        if(IdlUtilities.isValidIDLIdentifier(name.getText()) && IdlUtilities.isValidIDLIdentifier(type.getText()))
//            enableOk();
//        else
//            disableOk();
    }

    public void removeUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void changedUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void insertUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField name;
    private JTextField type;
}
