/*************************************************************************
 *
 *  $RCSfile: inetdlg.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:32:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifdef PRECOMPILED
#include "ofapch.hxx"
#endif
#ifndef _SFX_INIMGR_HXX
#include <sfx2/inimgr.hxx>
#endif
#pragma hdrstop

#include "inetdlg.hxx"
#include "resid.hxx"
#include "opthtml.hxx"

#include "app.hrc"

#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SVX_DIALOGS_HRC
#include <svx/dialogs.hrc>
#endif
#ifndef _SVX_OPTINET_HXX
#include <svx/optinet2.hxx>
#endif
#ifndef _SVX_OPTMAIL_HXX
#include <svx/optmail.hxx>
#endif
#ifndef _SVX_OPTLDAP_HXX
#include <svx/optldap.hxx>
#endif
#ifndef _SVX_OPTEXTBR_HXX
#include <svx/optextbr.hxx>
#endif

// class OfaINetTabDialog ------------------------------------------------

OfaINetTabDialog::OfaINetTabDialog( Window *pParent,
									const SfxItemSet& rCoreSet ) :

	SfxTabDialog( pParent, OffResId( RID_OFADLG_INTERNET ), &rCoreSet )

{
	FreeResource();

	AddTabPage(RID_SVXPAGE_INET_PROXY,         &SvxProxyTabPage::Create,         0);
	AddTabPage(RID_SVXPAGE_INET_SEARCH,        &SvxSearchTabPage::Create,        0);
	AddTabPage(RID_SVXPAGE_MAIL,               &SvxMailTabPage::Create,          0);
	AddTabPage(RID_SVXPAGE_LDAP,               &SvxLDAPServerTabPage::Create,    0);
	AddTabPage(RID_SVXPAGE_INET_OTHER,         &SvxOtherTabPage::Create,         0);
}

// -----------------------------------------------------------------------

OfaINetTabDialog::~OfaINetTabDialog()
{
}

// class OfaBrowserTabDialog ---------------------------------------------

OfaBrowserTabDialog::OfaBrowserTabDialog( Window *pParent, const SfxItemSet& rSet ) :

	SfxTabDialog( pParent, OffResId( RID_OFADLG_BROWSER ), &rSet )

{
	FreeResource();

	AddTabPage(RID_SVXPAGE_INET_CACHE,      &SvxCacheTabPage::Create,       0);
	AddTabPage(RID_SVXPAGE_INET_TYPE,       &SvxTypeTabPage::Create,        0);
	AddTabPage(RID_SVXPAGE_INET_SCRIPTING,  &SvxScriptingTabPage::Create,   0);
	AddTabPage(RID_SVXPAGE_BROWSER_OTHER,   &SvxBrowserOtherTabPage::Create,0);

	if( INetURLObject::HasSSLSupport() )
	{
		XubString aRiderText( OffResId(RID_RIDER_SLL_SITE) );
		AddTabPage( RID_SVXPAGE_INET_SSLSITE, aRiderText, &SvxSSLSiteTabPage::Create, 0 );

#ifdef SSL_PERSONAL_NOW_IMPL
		aRiderText = OffResId(RID_RIDER_SLL_PERSONAL);
		AddTabPage( RID_SVXPAGE_INET_SSLPERSONAL, aRiderText, &SvxSSLPersonalTabPage::Create, 0 );
#endif
	}
	AddTabPage(RID_SVXPAGE_INET_COOKIES,        &SvxCookiesTabPage::Create,         0);
	AddTabPage(RID_OFAPAGE_HTMLOPT,             &OfaHtmlTabPage::Create,            0);
	AddTabPage(RID_SVXPAGE_OPT_EXTERN_BROWSER,  &SvxExternBrowserTabPage::Create,   0);

	if ( !SFX_INIMANAGER()->IsInternetExplorerAvailable() )
		RemoveTabPage( RID_SVXPAGE_OPT_EXTERN_BROWSER );
}

// -----------------------------------------------------------------------

OfaBrowserTabDialog::~OfaBrowserTabDialog()
{
}


