/*************************************************************************
 *
 *  $RCSfile: CreateProcess.c,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: jsc $ $Date: 2001/06/13 14:57:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <systools/win32/StrConvert.h>

BOOL WINAPI CreateProcessW_9x(
  LPCWSTR lpApplicationName,                 // name of executable module
  LPWSTR lpCommandLine,                      // command line string
  LPSECURITY_ATTRIBUTES lpProcessAttributes, // SD
  LPSECURITY_ATTRIBUTES lpThreadAttributes,  // SD
  BOOL bInheritHandles,                      // handle inheritance option
  DWORD dwCreationFlags,                     // creation flags
  LPVOID lpEnvironment,                      // new environment block
  LPCWSTR lpCurrentDirectory,                // current directory name
  LPSTARTUPINFOW lpStartupInfo,              // startup information
  LPPROCESS_INFORMATION lpProcessInformation // process information
)
{
    LPVOID lpEnvironmentA = lpEnvironment;
    DWORD  dwCreationFlagsA = dwCreationFlags;

    LPSTR lpCurrentDirectoryA = NULL;
    LPSTR lpApplicationNameA = NULL;
    LPSTR lpCommandLineA = NULL;

    STARTUPINFOA StartupInfo;

    // convert unicode parameters 
    WC2MB( lpApplicationName, lpApplicationNameA );
    WC2MB( lpCommandLine, lpCommandLineA );
    WC2MB( lpCurrentDirectory, lpCurrentDirectoryA );

    // startup info structure contains string members
    StartupInfo.cb = min( sizeof( STARTUPINFOA ), lpStartupInfo->cb );

    StartupInfo.lpReserved = NULL;
    StartupInfo.lpDesktop = NULL;
    StartupInfo.lpTitle = NULL;

    // if string members are set in the unicode struct, convert it 
    WC2MB( lpStartupInfo->lpDesktop, StartupInfo.lpDesktop );
    WC2MB( lpStartupInfo->lpTitle, StartupInfo.lpTitle );

    // copy the remaining members to new structure 
    memcpy( &StartupInfo.dwX, &lpStartupInfo->dwX, StartupInfo.cb - 3 * sizeof(LPWSTR) - sizeof(DWORD) );

    // the environment may include unicode strings as well 
    if( dwCreationFlags & CREATE_UNICODE_ENVIRONMENT )
    {
        dwCreationFlagsA &= ~CREATE_UNICODE_ENVIRONMENT;
        lpEnvironmentA = NULL;

        WCL2MBL( (LPCWSTR) lpEnvironment, (LPSTR) lpEnvironmentA );
    }

    // memory will be freed automatically 
    return CreateProcessA( lpApplicationNameA, lpCommandLineA, 
        lpProcessAttributes, lpThreadAttributes, 
        bInheritHandles, dwCreationFlagsA, lpEnvironmentA,
        lpCurrentDirectoryA, &StartupInfo, lpProcessInformation
    );
};
