/*************************************************************************
 *
 *  $RCSfile: testuuid.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/04/15 17:49:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#if OSL_DEBUG_LEVEL == 0
#define NDEBUG
#endif
#include <assert.h>

#include <stdio.h>
#include <string.h>
#include <rtl/uuid.h>
#include <rtl/process.h>
#include <osl/time.h>
#include <sal/types.h>


/*****
 * For diagnostics
 ****/
void printUuid( sal_uInt8 *pNode )
{
	for( sal_Int32 i1 = 0 ; i1 < 4 ; i1++ )
	{
		for( sal_Int32 i2 = 0 ; i2 < 4 ; i2++ )
		{
			printf( "%02x" , pNode[i1*4 +i2] );
		}
		if( i1 == 3 )
			break;
		printf( "-" );
	}

	printf( "\n" );
}

sal_Int32 getSystemTimeResolution()
{
	TimeValue val,val2;
	osl_getSystemTime(&val);
	sal_Int32 nResolution = 0;

	for( sal_Int32 i = 0 ; i < 500000; i ++ )
	{
		osl_getSystemTime(&val2);

		if( val.Seconds != val2.Seconds || val.Nanosec != val2.Nanosec )
		{
			sal_uInt64 u =
				((sal_uInt64)val2.Seconds) * 10000000 +
				((sal_uInt64)val2.Nanosec) /100 -
                (
					((sal_uInt64)val.Seconds) * 10000000 +
					((sal_uInt64)val.Nanosec) /100
				);

			if( nResolution && nResolution > ( sal_uInt32 ) u )
			{
				/***
				 * Note :
				 ***/
				printf( "Warning: Jumping system clock resolution %d -> %d (100 ns Ticks)\n",
						nResolution , (sal_uInt32) u );

				nResolution = (sal_uInt32) u;
			}
			if( ! nResolution )
			{
				nResolution = (sal_uInt32) u;
			}
		}

		val.Seconds = val2.Seconds;
		val.Nanosec = val2.Nanosec;
	}

	return nResolution;
}

#include <osl/mutex.h>
#define TEST_UUID 2000
void test_uuid()
{
	sal_uInt8 pNode[16];
	sal_uInt8 aNode[TEST_UUID][16];
	sal_uInt8 pNode2[16];

	sal_Int32 i,i2;

	sal_Int32 nRes = getSystemTimeResolution();

	printf( "System time resolution : %d [100ns Ticks]\n", nRes );
	assert( UUID_SYSTEM_TIME_RESOLUTION_100NS_TICKS <= nRes );

	rtl_createUuid( pNode, 0 , sal_False );
	memcpy( pNode2 , pNode, 16 );
	assert( rtl_compareUuid( pNode , pNode2 ) == 0 );

	for( i = 0 ; i < TEST_UUID ; i ++ )
	{
		rtl_createUuid( aNode[i], pNode , sal_False );
	}

	for( i = 0 ; i < TEST_UUID ; i ++ )
	{
		for( i2 = i+1 ; i2 < TEST_UUID ; i2 ++ )
		{
			assert( rtl_compareUuid( aNode[i] , aNode[i2] ) != 0  );
		}
	}

	// test version 3 uuid : named uuid !
	{
		sal_uInt8 NameSpace_DNS[16] = RTL_UUID_NAMESPACE_DNS;
		sal_uInt8 NameSpace_URL[16] = RTL_UUID_NAMESPACE_URL;
		sal_uInt8 pPriorCalculatedUUID[16] = {
			0x52,0xc9,0x30,0xa5,
			0xd1,0x61,0x3b,0x16,
			0x98,0xc5,0xf8,0xd1,
			0x10,0x10,0x6d,0x4d };

		sal_uInt8 pNamedUUID[16], pNamedUUID2[16];

		// Same name does generate the same uuid
		rtl_String *pName = 0;
		rtl_string_newFromStr( &pName , "this is a bla.blubs.DNS-Name" );
		rtl_createNamedUuid( pNamedUUID , NameSpace_DNS , pName );
		rtl_createNamedUuid( pNamedUUID2 , NameSpace_DNS , pName );
		assert( ! memcmp( pNamedUUID , pNamedUUID2 , 16 ) );
		assert( ! memcmp( pNamedUUID  , pPriorCalculatedUUID , 16 ) );

		// Different names does not generate the same uuid
		rtl_string_newFromStr( &pName , "this is a bla.blubs.DNS-Namf" );
		rtl_createNamedUuid( pNamedUUID2 , NameSpace_DNS , pName );
		assert( memcmp( pNamedUUID , pNamedUUID2 , 16 ) );

		// the same name with different namespace uuid produces different uuids
		rtl_createNamedUuid( pNamedUUID , NameSpace_URL , pName );
		assert( memcmp( pNamedUUID , pNamedUUID2 , 16 ) );

		rtl_string_release( pName );
	}

	{
		sal_uInt8 pNode[16];
		rtl_getGlobalProcessId( pNode );
		rtl_getGlobalProcessId( pNode2 );
		assert( 0 == rtl_compareUuid( pNode , pNode2 ) );
	}
	printf( "test_uuid OK\n" );
}
