/*************************************************************************
 *
 *  $RCSfile: sclib.cxx,v $
 *
 *  $Revision: 1.25.122.2 $
 *
 *  last change: $Author: vg $ $Date: 2005/07/01 13:22:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma hdrstop

#define _SCALC_EXE

#ifdef WIN
#include <svwin.h>
#endif

#include <svtools/inettype.hxx>
#include <svtools/parhtml.hxx>
#include <so3/clsids.hxx>
#include <sfx2/docfilt.hxx>
#include <sfx2/fcontnr.hxx>
#include <sfx2/docfile.hxx>
#include <sfx2/app.hxx>
#include <unotools/configitem.hxx>
#include <comphelper/types.hxx>

#include <sot/formats.hxx>
#define SOT_FORMATSTR_ID_STARCALC_30 SOT_FORMATSTR_ID_STARCALC

#include <signal.h>

#include "scdll.hxx"

#include "docsh.hxx"
#include "sc.hrc"
#include "scdll0.hxx"


//------------------------------------------------------------------

//	Filter-Namen (wie in docsh.cxx)

static const sal_Char __FAR_DATA pFilterSc50[]		= "StarCalc 5.0";
static const sal_Char __FAR_DATA pFilterSc50Temp[]	= "StarCalc 5.0 Vorlage/Template";
static const sal_Char __FAR_DATA pFilterSc40[]		= "StarCalc 4.0";
static const sal_Char __FAR_DATA pFilterSc40Temp[]	= "StarCalc 4.0 Vorlage/Template";
static const sal_Char __FAR_DATA pFilterSc30[]		= "StarCalc 3.0";
static const sal_Char __FAR_DATA pFilterSc30Temp[]	= "StarCalc 3.0 Vorlage/Template";
static const sal_Char __FAR_DATA pFilterSc10[]		= "StarCalc 1.0";
static const sal_Char __FAR_DATA pFilterXML[]		= "StarOffice XML (Calc)";
static const sal_Char __FAR_DATA pFilterAscii[]		= "Text - txt - csv (StarCalc)";
static const sal_Char __FAR_DATA pFilterLotus[]		= "Lotus";
static const sal_Char __FAR_DATA pFilterExcel4[]	= "MS Excel 4.0";
static const sal_Char __FAR_DATA pFilterEx4Temp[]	= "MS Excel 4.0 Vorlage/Template";
static const sal_Char __FAR_DATA pFilterExcel5[]	= "MS Excel 5.0/95";
static const sal_Char __FAR_DATA pFilterEx5Temp[]	= "MS Excel 5.0/95 Vorlage/Template";
static const sal_Char __FAR_DATA pFilterExcel95[]	= "MS Excel 95";
static const sal_Char __FAR_DATA pFilterEx95Temp[]	= "MS Excel 95 Vorlage/Template";
static const sal_Char __FAR_DATA pFilterExcel97[]	= "MS Excel 97";
static const sal_Char __FAR_DATA pFilterEx97Temp[]	= "MS Excel 97 Vorlage/Template";
static const sal_Char __FAR_DATA pFilterDBase[]		= "dBase";
static const sal_Char __FAR_DATA pFilterDif[]		= "DIF";
static const sal_Char __FAR_DATA pFilterSylk[]		= "SYLK";
static const sal_Char __FAR_DATA pFilterHtml[]		= "HTML (StarCalc)";
static const sal_Char __FAR_DATA pFilterHtmlWeb[]	= "calc_HTML_WebQuery";
static const sal_Char __FAR_DATA pFilterRtf[]		= "Rich Text Format (StarCalc)";

//------------------------------------------------------------------

//	filter detection can't use ScFilterOptions (in sc-dll),
//	so access to wk3 flag must be implemented here again

class ScLibOptions : public utl::ConfigItem
{
	BOOL		bWK3Flag;

public:
				ScLibOptions();
	BOOL		GetWK3Flag() const			{ return bWK3Flag; }
};

#define CFGPATH_LIBFILTER		"Office.Calc/Filter/Import/Lotus123"
#define ENTRYSTR_WK3			"WK3"

ScLibOptions::ScLibOptions() :
	ConfigItem( rtl::OUString::createFromAscii( CFGPATH_LIBFILTER ) ),
	bWK3Flag( FALSE )
{
	com::sun::star::uno::Sequence<rtl::OUString> aNames(1);
	aNames[0] = rtl::OUString::createFromAscii( ENTRYSTR_WK3 );
	com::sun::star::uno::Sequence<com::sun::star::uno::Any> aValues = GetProperties(aNames);
	if ( aValues.getLength() == 1 && aValues[0].hasValue() )
		bWK3Flag = comphelper::getBOOL( aValues[0] );
}

//------------------------------------------------------------------

//	GlobalName der aktuellen Version:
SFX_IMPL_OBJECTFACTORY_LIB(ScDocShell, SFXOBJECTSHELL_STD_NORMAL, scalc,
							SvGlobalName(SO3_SC_CLASSID), Sc,
							String( RTL_CONSTASCII_USTRINGPARAM( DLL_NAME ) ))
{
	((SfxObjectFactory&)Factory()).
			SetDocumentServiceName( rtl::OUString::createFromAscii(
					"com.sun.star.sheet.SpreadsheetDocument" ) );

	const String	aEmptyStr;
									// Clipboard-IDs:
	const ULONG		nSc50Format	 = SOT_FORMATSTR_ID_STARCALC_50;

	String aVndCalc = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(CONTENT_TYPE_STR_APP_VND_CALC));

	Factory().GetFilterContainer()->SetDetectFilter( ScDLL::DetectFilter );

	//	5.0 muss mit vnd-Mime-Type registriert werden, aeltere mit dem alten x-starcalc
/*
	SFX_OWN_FILTER_REGISTRATION( ScDLL::DetectFilter,
						String::CreateFromAscii(pFilterSc50),
						String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("*.sdc")),
						SFX_FILTER_OWN | SFX_FILTER_TEMPLATE |
						SFX_FILTER_IMPORT | SFX_FILTER_EXPORT,
						nSc50Format,
						String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("SVsc0.sdc")),
						String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("StarCalc 5.0")),
						RID_SCICN_DOCUMENT,
						aVndCalc, aEmptyStr );

	SFX_OWN_FILTER_REGISTRATION( ScDLL::DetectFilter,
						String::CreateFromAscii(pFilterSc50Temp),
						String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("*.vor")),
						SFX_FILTER_OWN | SFX_FILTER_TEMPLATE | SFX_FILTER_TEMPLATEPATH |
						SFX_FILTER_IMPORT | SFX_FILTER_EXPORT,
						nSc50Format,
						String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("SVsc1.vor")),
						String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("StarCalc 5.0")),
						RID_SCICN_TEMPLATE,
						aVndCalc, aEmptyStr );
*/
	//	alle Im-/Exportfilter werden nur noch per install.ini registriert,
	//	damit sie bei der Installation weggelassen werden koennen.
}


// this is the right place for SFX_OBJECTFACTORY_LIB

//------------------------------------------------------------------
//
//	ScModuleDummy::Load() muss zur App gelinkt werden:
//
//------------------------------------------------------------------

SfxModule* ScModuleDummy::Load()
{
	if ( LoadLibSc() )
	{
		ScModuleDummy* pMod = SC_DLL();
		return pMod;
	}
	return NULL;
}

SvGlobalName ScModuleDummy::GetID(USHORT nFileFormat)
{
	SvGlobalName aName;

	switch (nFileFormat)
	{
		//	GlobalNames der ScDocShell:

		case SOFFICE_FILEFORMAT_31:
			aName = SvGlobalName( SO3_SC_CLASSID_30 );
			break;

		case SOFFICE_FILEFORMAT_40:
			aName = SvGlobalName( SO3_SC_CLASSID_40 );
			break;

		case SOFFICE_FILEFORMAT_50:
			aName = SvGlobalName( SO3_SC_CLASSID_50 );
			break;

		case SOFFICE_FILEFORMAT_60:
			aName = SvGlobalName( SO3_SC_CLASSID_60 );
			break;

		default:
			DBG_ERROR("ScModuleDummy::GetID: unbekanntes Fileformat");
			break;
	}
	return aName;
}

USHORT ScModuleDummy::HasID(const SvGlobalName& rName)
{
	if (GetID(SOFFICE_FILEFORMAT_31) == rName)
		return SOFFICE_FILEFORMAT_31;

	if (GetID(SOFFICE_FILEFORMAT_40) == rName)
		return SOFFICE_FILEFORMAT_40;

	if (GetID(SOFFICE_FILEFORMAT_50) == rName)
		return SOFFICE_FILEFORMAT_50;

	if (GetID(SOFFICE_FILEFORMAT_60) == rName)
		return SOFFICE_FILEFORMAT_60;

	return 0;           // unbekannter Name: kein passendes Fileformat
}

//------------------------------------------------------------------

ScDLL::ScDLL()
{
	// the ctor is called at the beginning of SfxApplication-subclass::Main()
	// do whatever you want, but no calls to Sxx-DLL-code!
}

ScDLL::~ScDLL()
{
	// the dtor is called at the end of SfxApplication-subclass::Main()
	// do whatever you want, but no calls to Sxx-DLL-code!
}

void ScDLL::LibInit()
{
	// this method is called before Application::Execute()
	// do whatever you want, but no calls to Sxx-DLL-code!

	// RegisterFactory must now be before ScModuleDummy is created
	ScDocShell::RegisterFactory( SDT_SC_DOCFACTPRIO );

	// create a dummy-module for Object-Factory-Pointer
	ScModuleDummy* pMod = new ScModuleDummy( NULL, TRUE, &ScDocShell::Factory() );
	SC_DLL() = pMod;
}

void ScDLL::PreExit()
{
	//	PreExit wird aus Exit() gerufen und loescht das Module.
	//	Der Module-dtor muss alle Daten loeschen, die z.B. noch die Svx-DLL brauchen.

	ScModuleDummy **ppShlPtr = (ScModuleDummy**) GetAppData(SHL_CALC);
	SvFactory *pFact = (SvFactory*)(*ppShlPtr)->pScDocShellFactory;
	delete (*ppShlPtr);
	(*ppShlPtr) = new ScModuleDummy( NULL, TRUE, NULL);
	(*ppShlPtr)->pScDocShellFactory = pFact;

	//	Der ModuleDummy mit der Factory wird z.B. noch bei SvFactory::DeInit() gebraucht.
}

void ScDLL::LibExit()
{
	//	LibExit wird am Ende von Main() gerufen und gibt die DLL selber frei

	FreeLibSc();	// DLL freigeben (ruft ScDLL::Exit)

	//	das sollte jetzt nur noch ein Dummy sein:

	ScModuleDummy **ppShlPtr = (ScModuleDummy**) GetAppData(SHL_CALC);
	delete (*ppShlPtr);
	(*ppShlPtr) = NULL;
}

//------------------------------------------------------------------

BOOL lcl_MayBeAscii( SvStream& rStream )
{
	//	ASCII is considered possible if there are no null bytes

	rStream.Seek(STREAM_SEEK_TO_BEGIN);

	BOOL bNullFound = FALSE;
	BYTE aBuffer[ 4097 ];
	const BYTE* p = aBuffer;
	ULONG nBytesRead = rStream.Read( aBuffer, 4096 );

	if ( nBytesRead >= 2 &&
			( ( aBuffer[0] == 0xff && aBuffer[1] == 0xfe ) ||
			  ( aBuffer[0] == 0xfe && aBuffer[1] == 0xff ) ) )
	{
		//	unicode file may contain null bytes
		return TRUE;
	}

	while( nBytesRead-- )
		if( !*p++ )
		{
			bNullFound = TRUE;
			break;
		}

	return !bNullFound;
}

BOOL lcl_MayBeDBase( SvStream& rStream )
{
	//	for dBase, look for the 0d character at the end of the header

	rStream.Seek(STREAM_SEEK_TO_END);
	ULONG nSize = rStream.Tell();

	// length of header starts at 8

	if ( nSize < 10 )
		return FALSE;
	rStream.Seek(8);
	USHORT nHeaderLen;
	rStream >> nHeaderLen;

	if ( nHeaderLen < 32 || nSize < nHeaderLen )
		return FALSE;

	// Last byte of header must be 0x0d, this is how it's specified.
    // #i9581# but some applications don't follow the specification and pad the
    // header with one byte 0x00 to reach an even boundary.

    rStream.Seek( nHeaderLen - 2 );
    BYTE nOneBefore, nEndFlag;
    rStream >> nOneBefore >> nEndFlag;

    return ( nEndFlag == 0x0d ||
            ((nHeaderLen % 2 == 0) && nOneBefore == 0x0d && nEndFlag == 0x00) );
}

BOOL lcl_IsAnyXMLFilter( const SfxFilter* pFilter )
{
	if ( !pFilter )
		return FALSE;

	//	TRUE for XML file or template
	//	(template filter has no internal name -> allow configuration key names)

	String aName = pFilter->GetFilterName();
	return aName.EqualsAscii(pFilterXML) ||
		   aName.EqualsAscii("calc_StarOffice_XML_Calc") ||
		   aName.EqualsAscii("calc_StarOffice_XML_Calc_Template");
}

ULONG __EXPORT ScDLL::DetectFilter( SfxMedium& rMedium, const SfxFilter** ppFilter,
									SfxFilterFlags nMust, SfxFilterFlags nDont )
{
	//	#59915# laut MBA darf hier nur ERRCODE_NONE, ERRCODE_ABORT und ERRCODE_FORCEQUIET
	//	zurueckgegeben werden...

	if ( SVSTREAM_OK != rMedium.GetError() )
		return ERRCODE_ABORT;	// ERRCODE_IO_GENERAL

	//	Formate, die sicher erkannt werden:

	SvStorage* pStorage = rMedium.GetStorage();
	if ( pStorage )
	{
		String		aStreamName;

		// Erkennung ueber contained streams
		// Excel-5 / StarCalc 3.0

		aStreamName = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("Workbook"));
		BOOL bExcel97Stream = ( pStorage->IsContained( aStreamName ) && pStorage->IsStream( aStreamName ) );

		aStreamName = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("Book"));
		BOOL bExcel5Stream = ( pStorage->IsContained( aStreamName ) && pStorage->IsStream( aStreamName ) );

		if ( bExcel97Stream )
		{
			String aOldName;
			if ( *ppFilter ) aOldName = (*ppFilter)->GetFilterName();
			if ( aOldName.EqualsAscii(pFilterEx97Temp) )
			{
				//	Excel 97 template selected -> keep selection
			}
			else if ( bExcel5Stream &&
						( aOldName.EqualsAscii(pFilterExcel5) || aOldName.EqualsAscii(pFilterEx5Temp) ||
						  aOldName.EqualsAscii(pFilterExcel95) || aOldName.EqualsAscii(pFilterEx95Temp) ) )
			{
				//	dual format file and Excel 5 selected -> keep selection
			}
			else
			{
				//	else use Excel 97 filter
				*ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
									  String::CreateFromAscii(pFilterExcel97) );
			}
			return ERRCODE_NONE;
		}
		if ( bExcel5Stream )
		{
			String aOldName;
			if ( *ppFilter ) aOldName = (*ppFilter)->GetFilterName();
			if ( aOldName.EqualsAscii(pFilterExcel95) || aOldName.EqualsAscii(pFilterEx95Temp) ||
					aOldName.EqualsAscii(pFilterEx5Temp) )
			{
				//	Excel 95 oder Vorlage (5 oder 95) eingestellt -> auch gut
			}
            else if ( aOldName.EqualsAscii(pFilterEx97Temp) )
            {
                // #101923# auto detection has found template -> return Excel5 template
                *ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
                                        String::CreateFromAscii(pFilterEx5Temp) );
            }
			else
			{
				//	sonst wird als Excel 5-Datei erkannt
				*ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
										String::CreateFromAscii(pFilterExcel5) );
			}
			return ERRCODE_NONE;
		}

		aStreamName = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM(STRING_SCSTREAM));
		if ( pStorage->IsContained( aStreamName ) && pStorage->IsStream( aStreamName ) )
		{
			//	Unterscheidung 3.0 / 4.0 / 5.0 ueber Clipboard-Id
			ULONG nStorFmt = pStorage->GetFormat();
			if ( nStorFmt == SOT_FORMATSTR_ID_STARCALC_30 )
				*ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
											String::CreateFromAscii(pFilterSc30) );
			else if ( nStorFmt == SOT_FORMATSTR_ID_STARCALC_40 )
				*ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
											String::CreateFromAscii(pFilterSc40) );
			else
				*ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
											String::CreateFromAscii(pFilterSc50) );
			return ERRCODE_NONE;
		}

		//	XML package file: Stream "Content.xml" or "content.xml"
		aStreamName = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("content.xml"));
		String aOldXML = String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("Content.xml"));
		if ( ( pStorage->IsContained( aStreamName ) && pStorage->IsStream( aStreamName ) ) ||
			 ( pStorage->IsContained( aOldXML ) && pStorage->IsStream( aOldXML ) ) )
		{
            rtl::OUString sMediaType;
            com::sun::star::uno::Any aAny;
            pStorage->GetProperty(rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("MediaType")), aAny);
            if ((aAny >>= sMediaType) && (sMediaType.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("application/vnd.oasis.opendocument.spreadsheet"))) ||
                                        (sMediaType.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM("application/vnd.oasis.opendocument.spreadsheet-template")))) 
            {
                if ((*ppFilter)->GetFilterName().EqualsAscii("calc8") || (*ppFilter)->GetFilterName().EqualsAscii("calc8_template"))
                    return ERRCODE_NONE;
                else
                {
					*ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
													String::CreateFromAscii("calc8") );
				    return ERRCODE_NONE;
                }
            }
            else
            {
                //	#85794# don't accept other applications' xml formats,
			    //	recognized by clipboard id
			    ULONG nStorageFormat = pStorage->GetFormat();
			    if ( nStorageFormat == 0 || nStorageFormat == SOT_FORMATSTR_ID_STARCALC_60 )
			    {
				    //	if XML template is set, don't modify
				    if (!lcl_IsAnyXMLFilter(*ppFilter))
					    *ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
													    String::CreateFromAscii(pFilterXML) );
				    return ERRCODE_NONE;
			    }
            }
		}
	}
	else 	// no storage
	{
		SvStream &rStr = *rMedium.GetInStream();
		if ( &rStr == NULL )
			return ERRCODE_ABORT;	// ERRCODE_IO_GENERAL

		// Tabelle mit Suchmustern
		// Bedeutung der Sequenzen
		// 0x00??: genau Byte 0x?? muss an dieser Stelle stehen
		// 0x0100: ein Byte ueberlesen (don't care)
		// 0x02nn: ein Byte aus 0xnn Alternativen folgt
		// 0x8000: Erkennung abgeschlossen
		//

#define M_DC		0x0100
#define M_ALT(ANZ)	0x0200+ANZ
#define M_ENDE		0x8000

		const UINT16 pLotus[] = 		// Lotus 1/1A/2
			{ 0x0000, 0x0000, 0x0002, 0x0000,
			  M_ALT(2), 0x0004, 0x0006,
			  0x0004, M_ENDE };

		const UINT16 pExcel1[] =		// Excel Biff/3/4 Tabellen
			{ 0x0009,
			  M_ALT(2), 0x0002, 0x0004,
			  0x0006, 0x0000, M_DC, M_DC, 0x0010, 0x0000,
			  M_DC, M_DC, M_ENDE };

		const UINT16 pExcel2[] =		// Excel Biff3/4 Workbooks
			{ 0x0009,
			  M_ALT(2), 0x0002, 0x0004,
			  0x0006, 0x0000, M_DC, M_DC, 0x0000, 0x0001,
			  M_DC, M_DC, M_ENDE };

		const UINT16 pExcel3[] =		// Excel Biff2 Tabellen
			{ 0x0009, 0x0000, 0x0004, 0x0000,
			  M_DC, M_DC, 0x0010, 0x0000, M_ENDE };

		const UINT16 pSc10[] =			// StarCalc 1.0 Dokumente
			{ 'B', 'l', 'a', 'i', 's', 'e', '-', 'T', 'a', 'b', 'e', 'l', 'l',
			  'e', 0x000A, 0x000D, 0x0000,    // Sc10CopyRight[16]
			  M_DC, M_DC, M_DC, M_DC, M_DC, M_DC, M_DC, M_DC, M_DC, M_DC, M_DC,
			  M_DC, M_DC, 					// Sc10CopyRight[29]
			  M_ALT(2), 0x0065, 0x0066,		// Versionsnummer 101 oder 102
			  0x0000,
			  M_ENDE };

		const UINT16 pLotus2[] =		// Lotus >3
			{ 0x0000, 0x0000, 0x001A, 0x0000,	// Rec# + Len (26)
			  M_ALT(2), 0x0000, 0x0002,			// File Revision Code
			  0x0010,
			  0x0004, 0x0000,					// File Revision Subcode
			  M_ENDE };

		const UINT16 pDIF1[] =			// DIF mit CR-LF
			{
			'T', 'A', 'B', 'L', 'E',
			M_DC, M_DC,
			'0', ',', '1',
			M_DC, M_DC,
			'\"',
			M_ENDE };

		const UINT16 pDIF2[] =			// DIF mit CR oder LF
			{
			'T', 'A', 'B', 'L', 'E',
			M_DC,
			'0', ',', '1',
			M_DC,
			'\"',
			M_ENDE };

		const UINT16 pSylk[] =			// Sylk
			{
			'I', 'D', ';', 'P',
			M_ENDE };

#ifdef SINIX
		const UINT16 nAnzMuster = 9;	// sollte fuer indiz. Zugriff stimmen...
		UINT16 *ppMuster[ nAnzMuster ];			// Arrays mit Suchmustern
		ppMuster[ 0 ] = pLotus;
		ppMuster[ 1 ] = pExcel1;
		ppMuster[ 2 ] = pExcel2;
		ppMuster[ 3 ] = pExcel3;
		ppMuster[ 4 ] = pSc10;
		ppMuster[ 5 ] = pDIF1;
		ppMuster[ 6 ] = pDIF2;
		ppMuster[ 7 ] = pSylk;
		ppMuster[ 8 ] = pLotus2;				// Lotus immer ganz hinten wegen Ini-Eintrag
#else
		const UINT16 *ppMuster[] =		// Arrays mit Suchmustern
			{
			pLotus,
			pExcel1,
			pExcel2,
			pExcel3,
			pSc10,
			pDIF1,
			pDIF2,
			pSylk,
			pLotus2
			};
		const UINT16 nAnzMuster = sizeof(ppMuster) / sizeof(ppMuster[0]);
#endif

		const sal_Char* pFilterName[ nAnzMuster ] = 	// zugehoerige Filter
			{
			pFilterLotus,
			pFilterExcel4,
			pFilterExcel4,
			pFilterExcel4,
			pFilterSc10,
			pFilterDif,
			pFilterDif,
			pFilterSylk,
			pFilterLotus
			};

		const UINT16 nByteMask = 0xFF;

		// suchen Sie jetzt!
		// ... realisiert ueber 'Mustererkennung'

		BYTE			nAkt;
		BOOL			bSync;			// Datei und Muster stimmen ueberein
		USHORT			nFilter;		// Zaehler ueber alle Filter
		const UINT16	*pSearch;		// aktuelles Musterwort
		UINT16			nFilterLimit = nAnzMuster;

		// nur solange, bis es etwas Globales gibt
		// funzt nur, solange Eintraege fuer WK3 letzte Muster-Tabelle ist!
		ScLibOptions aLibOpt;
		if( !aLibOpt.GetWK3Flag() )
			nFilterLimit--;

		for ( nFilter = 0 ; nFilter < nFilterLimit ; nFilter++ )
		{
			rStr.Seek( 0 ); // am Anfang war alles Uebel...
			rStr >> nAkt;
			pSearch = ppMuster[ nFilter ];
			bSync = TRUE;
			while( !rStr.IsEof() && bSync )
			{
				register UINT16 nMuster = *pSearch;

				if( nMuster < 0x0100 )
				{ // 								direkter Byte-Vergleich
					if( ( BYTE ) nMuster != nAkt )
						bSync = FALSE;
				}
				else if( nMuster & M_DC )
				{ // 											 don't care
				}
				else if( nMuster & M_ALT(0) )
				{ // 									  alternative Bytes
					BYTE nAnzAlt = ( BYTE ) nMuster;
					bSync = FALSE;			// zunaechst unsynchron
					while( nAnzAlt > 0 )
					{
						pSearch++;
						if( ( BYTE ) *pSearch == nAkt )
							bSync = TRUE;	// jetzt erst Synchronisierung
						nAnzAlt--;
					}
				}
				else if( nMuster & M_ENDE )
				{ // 										Format detected
					if ( pFilterName[nFilter] == pFilterExcel4 && *ppFilter &&
							(*ppFilter)->GetFilterName().EqualsAscii(pFilterEx4Temp) )
					{
						//	Excel 4 erkannt, Excel 4 Vorlage eingestellt -> auch gut
					}
					else
					{	// gefundenen Filter einstellen
						*ppFilter = SFX_APP()->GetFilter(
							ScDocShell::Factory(),
							String::CreateFromAscii(pFilterName[ nFilter ]) );
					}

					return ERRCODE_NONE;
				}
				else
				{ // 										 Tabellenfehler
					DBG_ERROR( "-ScApplication::DetectFilter(): Fehler in Mustertabelle");
				}

				pSearch++;
				rStr >> nAkt;
			}
		}

        String aPresetFilterName;
        if ( *ppFilter )
            aPresetFilterName = (*ppFilter)->GetFilterName();

        // ASCII cannot be recognized.
        // #i3341# But if the Text/CSV filter was set (either by the user or
        // file extension) it takes precedence over HTML and RTF and dBase
        // detection. Otherwise something like, for example, "lala <SUP> gugu"
        // would trigger HTML to be recognized.

        if ( aPresetFilterName.EqualsAscii(pFilterAscii) && lcl_MayBeAscii( rStr ) )
            return ERRCODE_NONE;

        // get file header

		rStr.Seek( 0 );
		const int nTrySize = 80;
		ByteString aHeader;
		for ( int j = 0; j < nTrySize && !rStr.IsEof(); j++ )
		{
			sal_Char c;
			rStr >> c;
			aHeader += c;
		}
		aHeader += '\0';

		// test for HTML

		if ( HTMLParser::IsHTMLFormat( aHeader.GetBuffer() ) )
		{
			if ( aPresetFilterName.EqualsAscii(pFilterHtml) )
			{
				// old HTML filter is allowed, default is WebQuery filter
			}
			else
				*ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
											  	String::CreateFromAscii(pFilterHtmlWeb) );
			return ERRCODE_NONE;
		}

        // test for RTF

		if ( aHeader.CompareTo( "{\\rtf", 5 ) == COMPARE_EQUAL )
		{
			*ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
											  String::CreateFromAscii(pFilterRtf) );
			return ERRCODE_NONE;
		}

        // #97832#; we don't have a flat xml filter
/*		if ( aHeader.CompareTo( "<?xml", 5 ) == COMPARE_EQUAL )
		{
			//	if XML template is set, don't modify
			if (!lcl_IsAnyXMLFilter(*ppFilter))
				*ppFilter = SFX_APP()->GetFilter( ScDocShell::Factory(),
												  String::CreateFromAscii(pFilterXML) );
			return ERRCODE_NONE;
		}*/

        // dBase cannot safely be recognized - only test if the filter was set
        if ( aPresetFilterName.EqualsAscii(pFilterDBase) && lcl_MayBeDBase( rStr ) )
            return ERRCODE_NONE;
	}

	return ERRCODE_ABORT;		// war nix
}


