/*************************************************************************
 *
 *  $RCSfile: fupoor.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: aw $ $Date: 2002/07/18 09:32:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SC_FUPOOR_HXX
#define _SC_FUPOOR_HXX

#ifndef _EVENT_HXX //autogen
#include <vcl/event.hxx>
#endif
#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif

class SdrView;
class ScTabViewShell;
class Window;
class SdrModel;
class Dialog;

// #98185# Create default drawing objects via keyboard
class SdrObject;

//	Return-Werte fuer Command
#define SC_CMD_NONE		0
#define SC_CMD_USED		1
#define SC_CMD_IGNORE	2

/*************************************************************************
|*
|* Basisklasse fuer alle Funktionen
|*
\************************************************************************/

class FuPoor
{
 protected:
	SdrView* 		pView;
	ScTabViewShell*	pViewShell;
	Window*			pWindow;
	SdrModel* 		pDrDoc;

	SfxRequest		aSfxRequest;
	Dialog* 		pDialog;

	Timer			aScrollTimer;			// fuer Autoscrolling
	DECL_LINK( ScrollHdl, Timer * );
	void ForceScroll(const Point& aPixPos);

	Timer			aDragTimer; 			// fuer Drag&Drop
	DECL_LINK( DragTimerHdl, Timer * );
	DECL_LINK( DragHdl, void * );
	BOOL			bIsInDragMode;
	Point			aMDPos; 				// Position von MouseButtonDown

	// #95491# member to hold state of the mouse buttons for creation
	// of own MouseEvents (like in ScrollHdl)
private:
	sal_uInt16		mnCode;

 public:
	FuPoor(ScTabViewShell* pViewSh, Window* pWin, SdrView* pView,
		   SdrModel* pDoc, SfxRequest& rReq);
	virtual ~FuPoor();

	// #95491# see member
	void SetMouseButtonCode(sal_uInt16 nNew) { if(nNew != mnCode) mnCode = nNew; }
	const sal_uInt16 GetMouseButtonCode() const { return mnCode; }

	virtual void Paint(const Rectangle& rRect, Window* pWin) {}

	virtual void DoCut();
	virtual void DoCopy();
	virtual void DoPaste();

	// Mouse- & Key-Events; Returnwert=TRUE: Event wurde bearbeitet
	virtual BOOL KeyInput(const KeyEvent& rKEvt);
	virtual BOOL MouseMove(const MouseEvent& rMEvt) { return FALSE; }

	// #95491# moved from inline to *.cxx
	virtual BOOL MouseButtonUp(const MouseEvent& rMEvt); // { return FALSE; }

	// #95491# moved from inline to *.cxx
	virtual BOOL MouseButtonDown(const MouseEvent& rMEvt); // { return FALSE; }

	virtual BYTE Command(const CommandEvent& rCEvt);

	virtual void Activate();		// Function aktivieren
	virtual void Deactivate();		// Function deaktivieren

	virtual void ScrollStart() {}	// diese Funktionen werden von
	virtual void ScrollEnd() {} 	// ForceScroll aufgerufen

	void SetWindow(Window* pWin) { pWindow = pWin; }

	USHORT GetSlotID() const { return( aSfxRequest.GetSlot() ); }

	BOOL	IsDetectiveHit( const Point& rLogicPos );

	void	StopDragTimer();

	// #98185# Create default drawing objects via keyboard
	virtual SdrObject* CreateDefaultObject(const sal_uInt16 nID, const Rectangle& rRectangle);
protected:
	void ImpForceQuadratic(Rectangle& rRect);
};



#endif		// _SD_FUPOOR_HXX

