/*************************************************************************
 *
 *  $RCSfile: datalog.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/26 18:00:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "datalog.hxx"

#define SCHLOGBOOK_DEFOVERHEAD 20

#define MAX(a,b)   ((a>b)?(a):(b))


BOOL SchDataLogBook::IsValid() const
{
	return mbValid;
}
BOOL SchDataLogBook::IsChanged() const
{
	if(mbGetCol)return mbColChanged;
	return(mbRowChanged);
}
BOOL SchDataLogBook::IsRowChanged() const
{
	return mbRowChanged;
}
BOOL SchDataLogBook::IsColChanged() const
{
	return mbColChanged;
}
SchDataLogBook::SchDataLogBook(const SchMemChart& aMemChart)
{
	mnColsAdded=0;
	mnRowsAdded=0;
	mbGetCol=TRUE; //Achtung, nur damit es ueberhaupt definiert ist!
	mbValid=TRUE;
	mbColChanged=FALSE;
	mbRowChanged=FALSE;

	//Zusaetzlich allozierter Speicher, um Fragmentierung klein zu halten
	mnRowsLeft=SCHLOGBOOK_DEFOVERHEAD;
	mnColsLeft=SCHLOGBOOK_DEFOVERHEAD;

	mnRows=aMemChart.GetRowCount();
	mnCols=aMemChart.GetColCount();

	mnRowsInitial=mnRows;
	mnColsInitial=mnCols;

	mpRowCoordinates=new long[mnRows+mnRowsLeft];
	mpColCoordinates=new long[mnCols+mnColsLeft];

	if(!mpRowCoordinates || !mpColCoordinates)
	{
		mbValid=FALSE;
	}
	else   //initialisieren
	{
		long n;
		for(n=0;n<mnRows;n++)
			mpRowCoordinates[n]=n;
		for(n=0;n<mnCols;n++)
			mpColCoordinates[n]=n;
	}
}
SchDataLogBook::~SchDataLogBook()
{
	if(mpColCoordinates)
		delete [] mpColCoordinates;

	if(mpRowCoordinates)
		delete [] mpRowCoordinates;
}

void SchDataLogBook::Reset()
{
	mbValid=TRUE;
	mbColChanged=FALSE;
	mbRowChanged=FALSE;

	mnColsAdded=0;
	mnRowsAdded=0;

	mnRowsInitial=mnRows;
	mnColsInitial=mnCols;


	if(!mpRowCoordinates || !mpColCoordinates)
	{
		mbValid=FALSE;
	}
	else   //initialisieren
	{
		long n;
		for(n=0;n<mnRows;n++)
			mpRowCoordinates[n]=n;
		for(n=0;n<mnCols;n++)
			mpColCoordinates[n]=n;
	}
}


void SchDataLogBook::DeleteRow(const long nRow)
{
	if( (nRow<mnRows) && mbValid)
	{
		long n;

		//Speicher freigeben
		mnRows--;
		mnRowsLeft++;

		if(mpRowCoordinates[nRow]==SCH_DATALOG_ANY)
			mnRowsAdded--;

		//loeschen der CoordinatenInformation
		for(n=nRow;n<mnRows;n++)
			mpRowCoordinates[n]=mpRowCoordinates[n+1];

		mbRowChanged=TRUE;
	}
}

void SchDataLogBook::DeleteCol(const long nCol)
{
	if( (nCol<mnCols)  && mbValid)
	{
		long n;

		//Speicher freigeben
		mnCols--;
		mnColsLeft++;
		if(mpColCoordinates[nCol]==SCH_DATALOG_ANY)
			mnColsAdded--;

		//loeschen der CoordinatenInformation
		for(n=nCol;n<mnCols;n++)
			mpColCoordinates[n]=mpColCoordinates[n+1];

		mbColChanged=TRUE;
	}
}

void SchDataLogBook::SwapRows(long nRow1,long nRow2)
{

	if (nRow1 > nRow2)
	{
		long nTemp = nRow1;

		nRow1 = nRow2;
		nRow2 = nTemp;
	}

	if (nRow1 >= mnRows - 1) nRow1 = mnRows - 2;
	if (nRow2 >= mnRows)     nRow2 = mnRows - 1;

	nRow1 = MAX(nRow1, 0);
	nRow2 = MAX(nRow2, 0);



	if(  (nRow1<mnRows) && (nRow2<mnRows) && mbValid )
	{
		long tmp=mpRowCoordinates[nRow1];

		mpRowCoordinates[nRow1]=mpRowCoordinates[nRow2];
		mpRowCoordinates[nRow2]=tmp;
		mbRowChanged=TRUE;
	}
}
void SchDataLogBook::SwapCols(long nCol1,long nCol2)
{


	//Wie im MemChart die Args korrigieren:
	if (nCol1 > nCol2)
	{
		long nTemp = nCol1;

		nCol1 = nCol2;
		nCol2 = nTemp;
	}
	if (nCol1 >= mnCols - 1) nCol1 = mnCols - 2;
	if (nCol2 >= mnCols)     nCol2 = mnCols - 1;
	nCol1 = MAX(nCol1, 0);
	nCol2 = MAX(nCol2, 0);


	if(  (nCol1<mnCols) && (nCol2<mnCols) && mbValid )
	{
		long tmp=mpColCoordinates[nCol1];

		mpColCoordinates[nCol1]=mpColCoordinates[nCol2];
		mpColCoordinates[nCol2]=tmp;
		mbColChanged=TRUE;
	}
}
void SchDataLogBook::IncreaseRowCount()
{
	long *pNewCoord;

	pNewCoord= new long[mnRows+SCHLOGBOOK_DEFOVERHEAD];
	if(pNewCoord)
	{
		mnRowsLeft=SCHLOGBOOK_DEFOVERHEAD;
		memcpy(pNewCoord,mpRowCoordinates,sizeof(long)*mnRows);
		delete [] mpRowCoordinates;
		mpRowCoordinates=pNewCoord;
	}
	else
	{
		mbValid=FALSE;
	}
}
void SchDataLogBook::IncreaseColCount()
{
	long *pNewCoord;

	pNewCoord= new long[mnCols+SCHLOGBOOK_DEFOVERHEAD];
	if(pNewCoord)
	{
		mnColsLeft=SCHLOGBOOK_DEFOVERHEAD;
		memcpy(pNewCoord,mpColCoordinates,sizeof(long)*mnCols);
		delete [] mpColCoordinates;
		mpColCoordinates=pNewCoord;
	}
	else
	{
		mbValid=FALSE;
	}
}



void SchDataLogBook::InsertRow(const long nRow)
{
	if(mbValid && (nRow >= 0) )
	{
		if(mnRowsLeft == 0)
			IncreaseRowCount();//Buffer vergrern

		//Einfuegen:
		if(mbValid)
		{
			mnRows++;
			mnRowsLeft--;
			mnRowsAdded++;
			long n=mnRows-1;
			while(n > nRow)
			{
				mpRowCoordinates[n]=mpRowCoordinates[n-1];
				n--;
			}
			mbRowChanged=TRUE;
			mpRowCoordinates[nRow]=SCH_DATALOG_ANY;
		}
	}
}

void SchDataLogBook::InsertCol(const long nCol)
{
	if(mbValid && (nCol >= 0) )
	{
		if(mnColsLeft == 0)
			IncreaseColCount();

		//Einfuegen:
		if(mbValid)
		{
			mnCols++;
			mnColsLeft--;
			mnColsAdded++;
			long n=mnCols-1;
			while(n > nCol)
			{
				mpColCoordinates[n]=mpColCoordinates[n-1];
				n--;
			}
			mbColChanged=TRUE;
			mpColCoordinates[nCol]=SCH_DATALOG_ANY;
		}
	}
}

