/*************************************************************************
 *
 *  $RCSfile: schgroup.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: iha $ $Date: 2002/10/31 12:48:44 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdopath.hxx>
#endif
#ifndef _SVDHDL_HXX //autogen
#include <svx/svdhdl.hxx>
#endif
#ifndef _SVDPAGE_HXX //autogen
#include <svx/svdpage.hxx>
#endif

#include "glob.hxx"
#include "schdll.hxx"
#include "objid.hxx"
#include "chtmodel.hxx"
#include "schgroup.hxx"
#include <math.h>

TYPEINIT1(SchObjGroup, SdrObjGroup);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchObjGroup::SchObjGroup(ChartModel *pChmodel) :
	SdrObjGroup(),
	bAskForLogicRect(TRUE),
    mbUseChartInventor( true )
{
	// FG: Damit soll es Objekten im chart ermoeglicht werden sich wie ein
	//     Objekt im Draw zu verhalten falls gewnscht. Nicht alles was
	//     prinzipiell geht soll man auch koennen.
	aInfo.bResizeFreeAllowed    = TRUE;
	aInfo.bResizePropAllowed    = TRUE;
	aInfo.bRotateFreeAllowed    = TRUE;
	aInfo.bRotate90Allowed      = TRUE;
	aInfo.bMirrorFreeAllowed    = FALSE;
	aInfo.bMirror45Allowed      = FALSE;
	aInfo.bMirror90Allowed      = FALSE;
	aInfo.bShearAllowed         = TRUE;

	eChartGroupType = NOTHING;
	pChartmodel = pChmodel;
	SetModel( pChartmodel );
}

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

SchObjGroup::~SchObjGroup()
{
}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

UINT32 SchObjGroup::GetObjInventor() const
{
    if( mbUseChartInventor )
        return SchInventor;
    else
        return SdrInventor;
}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

UINT16 SchObjGroup::GetObjIdentifier() const
{
	return SCH_OBJGROUP_ID;
}

/*************************************************************************
|*
|* Handle-Anzahl bestimmen
|*
\************************************************************************/

USHORT SchObjGroup::GetHdlCount() const
{
	USHORT nCount = 0;
	BOOL bLine = FALSE;

	SdrObjListIter aIterator(*GetSubList(), IM_DEEPNOGROUPS);

	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pId = GetObjectId(*pObj);

		if (pId)
			if (!bLine)
			{
				if (pId && pId->GetObjId() == CHOBJID_LINE)
				{
					bLine = TRUE;
					nCount = 2;
				}
				else if (pObj->GetObjIdentifier() != OBJ_TEXT) nCount++;
			}
			else if (pId && pId->GetObjId() == CHOBJID_LINE) nCount += 2;
	}

	return nCount;
}

/*************************************************************************
|*
|* Handle erzeugen
|*
\************************************************************************/

SdrHdl* SchObjGroup::GetHdl(USHORT nHdlNum) const
{
	USHORT nCount = 0;
	BOOL bLine = FALSE;

	SdrObject* pObj = NULL;
	SdrObjListIter aIterator(*GetSubList(), IM_DEEPNOGROUPS);

	while (nCount <= nHdlNum && aIterator.IsMore())
	{
		pObj = aIterator.Next();
		SchObjectId* pId = GetObjectId(*pObj);

		if (pId)
			if (!bLine)
			{
				if (pId && pId->GetObjId() == CHOBJID_LINE)
				{
					bLine = TRUE;
					nCount = 2;
				}
				else if (pObj->GetObjIdentifier() != OBJ_TEXT) nCount++;
			}
			else if (pId && pId->GetObjId() == CHOBJID_LINE) nCount += 2;
	}

	Point aPos;

	if (pObj)
	{
		if (bLine)
		{
			const XPolygon& rXPoly = ((SdrPathObj*)pObj)->GetPathPoly()[0];
			aPos = rXPoly[nHdlNum % 2];
		}
		else if (pObj->ISA(SdrPathObj))
		{
			const XPolygon& rXPoly = ((SdrPathObj*)pObj)->GetPathPoly()[0];
			aPos = rXPoly[1];
		}
		else
			aPos = pObj->GetBoundRect().Center();
	}

	return new SdrHdl(aPos, HDL_MOVE);
}

/*************************************************************************
|*
|* Handle-Liste fuellen
|*
\************************************************************************/

void SchObjGroup::AddToHdlList(SdrHdlList& rHdlList) const
{
	BOOL bLine = FALSE;

	SdrObjListIter aIterator(*GetSubList(), IM_DEEPWITHGROUPS);

	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pId = GetObjectId(*pObj);
		if (pId && (pId->GetObjId() == CHOBJID_LINE))
		{
			bLine = TRUE;
			break;
		}
	}

	aIterator.Reset();

	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchObjectId* pId = GetObjectId(*pObj);
		Point aPos;

		if (pId)
			if (!bLine)
			{
				if (pObj->GetObjIdentifier() != OBJ_TEXT)
				{
					if (pObj->ISA(SdrPathObj))
					{
                        const XPolyPolygon& rPolyPoly = static_cast< const SdrPathObj & >( *pObj ).GetPathPoly();
                        if( rPolyPoly.Count() > 0 )
                            aPos = (rPolyPoly[ 0 ])[ 1 ];
					}
					else aPos = pObj->GetBoundRect().Center();

					SdrHdl* pHdl = new SdrHdl(aPos, HDL_MOVE);
					rHdlList.AddHdl(pHdl);
				}
			}
			else if (pId)
				 {
					 switch (pId->GetObjId())
					 {
						 case CHOBJID_LINE :
						 case CHOBJID_DIAGRAM_AVERAGEVALUE :
						 {
                             DBG_ASSERT( pObj->ISA( SdrPathObj ), "chart line is no path object" );
                             const XPolyPolygon& rPolyPoly = static_cast< const SdrPathObj & >( *pObj ).GetPathPoly();
                             DBG_ASSERT( rPolyPoly.Count() > 0, "Empty poly-polygon found" );
							 for (USHORT i = 0; i < 2; i++)
							 {
								 aPos = (rPolyPoly[ 0 ])[ i ];
								 SdrHdl* pHdl = new SdrHdl(aPos, HDL_MOVE);
								 rHdlList.AddHdl(pHdl);
							 }
						 }

						 case CHOBJID_DIAGRAM_NET :
						 {
							 aPos = pObj->GetBoundRect().Center();

							 SdrHdl* pHdl = new SdrHdl(aPos, HDL_MOVE);
							 rHdlList.AddHdl(pHdl);
						 }

						 default :
							 ;
					 }
				 }
	}
}

/*************************************************************************
|*
|* Identifier zurueckgeben
|*
\************************************************************************/

FASTBOOL SchObjGroup::HasSpecialDrag() const
{
	return TRUE;
}


/*************************************************************************
|*
|* Faehigkeiten der Chart-Gruppe feststellen
|*
\************************************************************************/

void SchObjGroup::TakeObjInfo(SdrObjTransformInfoRec& rInfo) const
{
	// FG: Damit soll es Objekten im chart ermoeglicht werden sich wie ein
	//     Objekt im Draw zu verhalten falls gewnscht.
	rInfo.bResizeFreeAllowed    = aInfo.bResizeFreeAllowed;
	rInfo.bResizePropAllowed    = aInfo.bResizePropAllowed;
	rInfo.bRotateFreeAllowed    = aInfo.bRotateFreeAllowed;
	rInfo.bRotate90Allowed      = aInfo.bRotate90Allowed;
	rInfo.bMirrorFreeAllowed    = aInfo.bMirrorFreeAllowed;
	rInfo.bMirror45Allowed      = aInfo.bMirror45Allowed;
	rInfo.bMirror90Allowed      = aInfo.bMirror90Allowed;
	rInfo.bShearAllowed         = aInfo.bShearAllowed;
}

/*************************************************************************
|*
|* Faehigkeiten der Chart-Gruppe zuweisen
|*
\************************************************************************/

void	SchObjGroup::SetObjInfo(SdrObjTransformInfoRec aMyInfo)
{
	// FG: Damit soll es Objekten im chart ermoeglicht werden sich wie ein
	//     Objekt im Draw zu verhalten falls gewnscht.
	aInfo.bResizeFreeAllowed    = aMyInfo.bResizeFreeAllowed;
	aInfo.bResizePropAllowed    = aMyInfo.bResizePropAllowed;
	aInfo.bRotateFreeAllowed    = aMyInfo.bRotateFreeAllowed;
	aInfo.bRotate90Allowed      = aMyInfo.bRotate90Allowed;
	aInfo.bMirrorFreeAllowed    = aMyInfo.bMirrorFreeAllowed;
	aInfo.bMirror45Allowed      = aMyInfo.bMirror45Allowed;
	aInfo.bMirror90Allowed      = aMyInfo.bMirror90Allowed;
	aInfo.bShearAllowed         = aMyInfo.bShearAllowed;
}

/*************************************************************************
|*
|* Wirkliches Resize einer Chart-Gruppe (ohne Broadcast)
|* Bei manchen Chart-Gruppen ist eine Neuberechnung bei einem Resize
|* besser als ein hartes Resize.
|*
\************************************************************************/

void SchObjGroup::NbcResize(const Point& rRef, const Fraction& xFact, const Fraction& yFact)
{
}

/*************************************************************************
|*
|* Um das Verhalten bei einem Resize in Abhaehngigkeit des selektierten
|* Objektes zu ernoeglichen. Bei Diagramme werden nicht die Teilobjekte
|* Resized sondern das Chart in den neuen Grenzen aufgebaut.
|*
\************************************************************************/

void SchObjGroup::Resize(const Point& rRef, const Fraction& xFact, const Fraction& yFact)
{
	if (eChartGroupType == DIAGRAM)
	{
		DBG_ASSERT(pChartmodel, "Bei der Diagrammgruppe muss das Model gesetzt sein!");
		if (pChartmodel != NULL)
		{
			// FG: Der folgende Teil ist noetig da das BoundRect die Gre des Charts ohne
			//     die Beschriftung darstellt und genau dieses wird Resized.
			//     Die Handles der 2d-Charts sitzen an den Achsen, die Textgroesse
			//     der Beschriftung soll ja nicht veraendert werden.
			//     CreateChart und BuildChart achten aber auf das ChartRect, das eigentlich
			//     nichts mit dem BoundRect der Subliste oder aehnlichem zu tun hat.
			//     Man verkleinert also das "falsche" BoundRect und zaehlt am Schluss den Platz
			//     fuer die Beschriftung hinzu.
			//     Ein besserer Weg waere es hier zwischen dem Platz fuer die Beschriftung und
			//     dem der eigentlichen Diagrammflaeche zu unterscheiden.
			//
			Rectangle aRectChart = pChartmodel->GetChartRect();
			Rectangle aRect = GetBoundRect();
			Point aPointBottomLeftRectChart = aRectChart.BottomLeft();
			Point aPointBottomLeftBoundRect = aRect.BottomLeft();
			Point aPointTopRightRectChart = aRectChart.TopRight();
			Point aPointTopRightBoundRect = aRect.TopRight();
			Point aDifferenceLeftBottom = aPointBottomLeftRectChart - aPointBottomLeftBoundRect;
			Point aDifferenceTopRight = aPointTopRightRectChart - aPointTopRightBoundRect;
			aRect.nRight = rRef.nA + (long) ((aRect.nRight - rRef.nA) * xFact.GetNumerator()
															/ xFact.GetDenominator());
			aRect.nLeft = rRef.nA + (long) ((aRect.nLeft - rRef.nA) * xFact.GetNumerator()
														  / xFact.GetDenominator());
			aRect.nTop = rRef.nB + (long) ((aRect.nTop - rRef.nB) * yFact.GetNumerator()
													  / yFact.GetDenominator());
			aRect.nBottom = rRef.nB + (long) ((aRect.nBottom - rRef.nB) * yFact.GetNumerator()
															 / yFact.GetDenominator());
			// FG: 11.3.97 Dies hier soll ein BuildChart mit geaenderten Koordinaten fuer diese
			//     eine Gruppe erzwingen.
// 			pSub->Clear();
            // The above does not result in a BuildChart and besides it is bad style
            // to flush an object on resize.  And by the way it results in a GPF (#97355#)
			bAskForLogicRect = FALSE;
			aRect.Left() += aDifferenceLeftBottom.X();
			aRect.Bottom() += aDifferenceLeftBottom.Y();
			aRect.Right() += aDifferenceTopRight.X();
			aRect.Top() += aDifferenceTopRight.Y();
			pChartmodel->SetDiagramRectangle(aRect);
			SetChanged();
		}
		if (pUserCall!=NULL) pUserCall->Changed(*this,SDRUSERCALL_RESIZE,GetLogicRect());
	}
	else
	{
		SdrObjGroup::Resize(rRef, xFact, yFact);
	}
}

/*************************************************************************
|*
|* Um mitzubekommen welche Objekte bewegt werden. Leider wird das
|* nicht nur vom Benutzer verursacht.
|*
\************************************************************************/

void SchObjGroup::Move(const Size& rSiz)
{

	if (eChartGroupType == DIAGRAM)
	{
		DBG_ASSERT( pChartmodel, "No Model" );
		if (pChartmodel != NULL)
		{
			Rectangle aRectChart = pChartmodel->GetChartRect();
			Rectangle aRect = GetBoundRect();
			Point aPointBottomLeftRectChart = aRectChart.BottomLeft();
			Point aPointBottomLeftBoundRect = aRect.BottomLeft();
			Point aPointTopRightRectChart = aRectChart.TopRight();
			Point aPointTopRightBoundRect = aRect.TopRight();
			Point aDifferenceLeftBottom = aPointBottomLeftRectChart - aPointBottomLeftBoundRect;
			Point aDifferenceTopRight = aPointTopRightRectChart - aPointTopRightBoundRect;
			aRect.Left() += rSiz.Width();
			aRect.Right() += rSiz.Width();
			aRect.Top() += rSiz.Height();
			aRect.Bottom() += rSiz.Height();
			bAskForLogicRect = FALSE;
			aRect.Left() += aDifferenceLeftBottom.X();
			aRect.Bottom() += aDifferenceLeftBottom.Y();
			aRect.Right() += aDifferenceTopRight.X();
			aRect.Top() += aDifferenceTopRight.Y();
			pChartmodel->SetDiagramRectangle(aRect);
		}
	}
	else
	{
		SdrObjGroup::Move(rSiz);
	}
}

/*************************************************************************
|*
|* Um mitzubekommen welche Objekte bewegt werden. Leider wird das
|* nicht nur vom Benutzer verursacht.
|*
\************************************************************************/

void SchObjGroup::SetGroupMoved(BOOL value)
{
	switch (eChartGroupType)
	{
		case (DIAGRAM):
			if (pChartmodel != NULL)
			{
				pChartmodel->SetDiagramHasBeenMovedOrResized(value);
			}
			break;
		case (LEGEND):
			if (pChartmodel != NULL)
			{
				pChartmodel->SetLegendHasBeenMoved( value );
                pChartmodel->SetLegendPos( GetLogicRect().TopLeft());
			}
			break;

	}
}

void SchObjGroup::SetUseChartInventor( bool bUseChartInventor )
{
    mbUseChartInventor = bUseChartInventor;
}

