/*************************************************************************
 *
 *  $RCSfile: AccessibleUniqueId.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: bm $ $Date: 2002/04/23 16:44:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _ACCESSIBLEUNIQUEID_HXX_
#define _ACCESSIBLEUNIQUEID_HXX_

#ifndef _SAL_TYPES_H_ 
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#include <hash_map>

namespace accessibility
{

/** Provide a unique id for every chart object.  With this it is possible to
    easily find an accessible object to some core object, especially when change
    notifications have to be broadcast.
 */
class AccessibleUniqueId
{
public:
    typedef sal_uInt64 IdType;

    /// initializes the internal id to 0, which is equivalent to invalid.
    AccessibleUniqueId();
    /** The unique id is calculated using the object id and two indices (which
        both are 0 for most objects) that are shifted.
    */
	AccessibleUniqueId( sal_uInt16 nObjectId,
                        sal_uInt16 nIndex1 = 0,
                        sal_uInt16 nIndex2 = 0 );

    IdType      GetId() const;

    sal_uInt16  GetObjectId() const;
    sal_uInt16  GetIndex1() const;
    sal_uInt16  GetIndex2() const;

    bool        IsValid() const;

    bool operator == ( const AccessibleUniqueId & ) const;

    ::rtl::OUString toString() const;

private:
    IdType      m_nId;

    friend class AccessibleUniqueIdHash;
};

/** Provides a hash key for unique ids.  The hash key is equal to the internal
    id AccessibleUniqueId::m_nId.
 */
class AccessibleUniqueIdHash : public ::std::unary_function< const AccessibleUniqueId &, size_t >
{
public:
    size_t operator()( const AccessibleUniqueId & a ) const
    {
        /* the id is of the form:

           | 63-48 | 47-32 | 31-16 | 15-0 |
           unused  index2  index1  objid

           To create an 'intelligent' hash-key for 32-bit architectures, push the
           parts together such that they overlap a little bit.

           Usually the object id is less than 256.  The first index is mostly 0,
           otherwise you can expect it to be small (series index).  The second index
           is also mostly 0, but may be larger (data-point index).

           =>
           | 31-24  23-16  |
               index 2
                 | (23-16) 15- 8 |
                       index 1
                        | (15- 8)  7- 0 |
                            object-id
        */
        if( sizeof( size_t ) < 8 )
            return static_cast< size_t >(
                (static_cast< sal_uInt32 >(a.m_nId >> 16) & 0xffff0000 ) |
                (static_cast< sal_uInt32 >(a.m_nId >> 8 ) & 0x00ffff00 ) |
                (static_cast< sal_uInt32 >(a.m_nId)       & 0x0000ffff ) );
        else
            return static_cast< size_t >( a.m_nId );
    }
};
 
}    // namespace accessibility

// _ACCESSIBLEUNIQUEID_HXX_
#endif
