/*************************************************************************
 *
 *  $RCSfile: attrib.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: bm $ $Date: 2002/06/03 10:06:51 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SCH_ATTRIB_HXX
#define _SCH_ATTRIB_HXX

#ifndef _SFXTABDLG_HXX
#include <sfx2/tabdlg.hxx>
#endif

#ifndef _SVX_TAB_AREA_HXX
#include <svx/tabarea.hxx>
#endif

#ifndef _SVX_CHRTITEM_HXX //autogen
#include <svx/chrtitem.hxx>
#endif

class SfxObjectShell;
class ChartModel;

#ifndef WORIENT_HXX //autogen
#include <svx/worient.hxx>
#endif
// header for FixedLine
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif

enum AttrType
{
	ATTR_TITLE,
	ATTR_LEGEND,
	ATTR_DATA_ROW,
	ATTR_DATA_LINE,
	ATTR_DATA_POINT,
	ATTR_AXIS,
	ATTR_X_AXIS_2D,
	ATTR_X_AXIS_3D,
	ATTR_Y_AXIS_2D,
	ATTR_Y_AXIS_3D,
	ATTR_Z_AXIS,
	ATTR_GRID,
	ATTR_DIAGRAM_AREA,
	ATTR_DIAGRAM_WALL,
	ATTR_DIAGRAM_FLOOR,
	ATTR_LINE,
	ATTR_DIAGRAM_STOCK_LOSS,
	ATTR_DIAGRAM_STOCK_PLUS
};

#define CHATTR_COUNT	(CHATTR_DIAGRAM_FLOOR + 1)

enum OrderMode
{
	CHORDMODE_NONE,
	CHORDMODE_X_AXIS,
	CHORDMODE_Y_AXIS
};

#define CHORDMODE_COUNT	(CHORDMODE_Y_AXIS + 1)

#define AxisTypeX 1
#define AxisTypeY 2
#define AxisTypeZ 3

/*************************************************************************
|*
|* Attributs-Tab-Dialog
|*
\************************************************************************/
class SchAttribTabDlg : public SfxTabDialog
{
private:
	Graphic			maSymbolGraphic;
	ChartModel      *pMyModel;
	XColorTable*  	pColorTab;
	XGradientList*	pGradientList;
	XHatchList*	  	pHatchingList;
	XBitmapList*  	pBitmapList;
	XDashList*	  	pDashList;
	XLineEndList* 	pLineEndList;
	long            nAxisType;

	USHORT		  	nPageType;
	USHORT		  	nDlgType;
	USHORT		  	nPos;
	ChangeType	  	nColorTableState;
	ChangeType	  	nBitmapListState;
	ChangeType	  	nGradientListState;
	ChangeType	  	nHatchingListState;

	const SfxItemSet *mpSymbolAttr;

	AttrType eAttrType;

	const SfxObjectShell& rDocShell;

	static USHORT GetResId(AttrType eType);

	virtual void PageCreated(USHORT nId, SfxTabPage& rPage);

public:
	SchAttribTabDlg(Window* pParent, AttrType eType,
					const SfxItemSet* pAttr,
					const SfxObjectShell* pDocShell,
					const ChartModel* pModel,
					int   nID,
					int   nType,
					const SfxItemSet* pSymbolAttr=NULL,
					Graphic aSymbolGraphic=Graphic());
	virtual ~SchAttribTabDlg();
};

/*************************************************************************
|*
|* Legenden-Anordnungs-Tab-Page
|*
\************************************************************************/
class SchLegendPosTabPage : public SfxTabPage
{
private:
	FixedLine	aGrpLegend;
	RadioButton	aRbtLeft;
	RadioButton	aRbtTop;
	RadioButton	aRbtBottom;
	RadioButton	aRbtRight;

	const SfxItemSet&	rOutAttrs;

public:
	SchLegendPosTabPage(Window* pParent, const SfxItemSet& rInAttrs);
	virtual ~SchLegendPosTabPage();

	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
	virtual void Reset(const SfxItemSet& rInAttrs);
};

/*************************************************************************
|*
|* Layout-Tab-Page
|*
\************************************************************************/
class SchLayoutTabPage : public SfxTabPage
{
private:
	FixedText	aFtLayout;
	ListBox     aListShapes;

	const SfxItemSet&	rOutAttrs;

public:
	SchLayoutTabPage(Window* pParent, const SfxItemSet& rInAttrs);
	virtual ~SchLayoutTabPage();

	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
	virtual void Reset(const SfxItemSet& rInAttrs);
};
/*************************************************************************
|*
|* Layout-Tab-Page
|*
\************************************************************************/
class SchOptionTabPage : public SfxTabPage
{
private:
	FixedLine	aGrpAxis;
    RadioButton aRbtAxis1;
    RadioButton aRbtAxis2;

	FixedLine	aGrpBar;
	FixedText   aFTGap;
	MetricField aMTGap;
	FixedText   aFTOverlap;
	MetricField aMTOverlap;
	CheckBox	aCBConnect;

    const SfxItemSet&   rOutAttrs;
public:
	SchOptionTabPage(Window* pParent, const SfxItemSet& rInAttrs);
	virtual ~SchOptionTabPage();

	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
	virtual void Reset(const SfxItemSet& rInAttrs);
};
/*************************************************************************
|*
|* Datenbeschriftungs-Tab-Page
|*
\************************************************************************/
class SchDataDescrTabPage : public SfxTabPage
{
private:
	CheckBox			aCbValue;
	RadioButton			aRbNumber;
	RadioButton			aRbPercent;
	CheckBox			aCbText;
	CheckBox			aCbSymbol;

	const SfxItemSet&	rOutAttrs;

	DECL_LINK(EnableHdl, CheckBox * );

public:
	SchDataDescrTabPage(Window* pParent, const SfxItemSet& rInAttrs);
	virtual ~SchDataDescrTabPage();

	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
	virtual void Reset(const SfxItemSet& rInAttrs);
};

/*************************************************************************
|*
|* Datenbeschriftungs-Tab-Page
|*
\************************************************************************/
class SchStatisticTabPage : public SfxTabPage
{
private:
	CheckBox    aCbxAverage;
	FixedLine   aFlDescr;
	RadioButton aRbtNone;
	RadioButton aRbtVariant;
	RadioButton aRbtSigma;
	RadioButton aRbtPercent;
	RadioButton aRbtBigError;
	RadioButton aRbtConst;
	MetricField aMtrFldPercent;
	MetricField aMtrFldBigError;
	FixedText	aFTConstPlus;
	MetricField aMtrFldConstPlus;
	FixedText	aFTConstMinus;
	MetricField aMtrFldConstMinus;
	FixedText	aFTIndicate;
	ValueSet 	aSet;
	FixedText	aFTRegress;
	ValueSet 	aRegression;

	BOOL                bRegressionDisabled;
	BOOL                bDisabled;
	SvxChartKindError   eKindError;
	SvxChartIndicate    eIndicate;
	SvxChartRegress     eRegression;

	const SfxItemSet&	rOutAttrs;

	DECL_LINK(CbxClick, CheckBox *);
	DECL_LINK(RBtnClick, Button *);
	DECL_LINK(SelectIndicate, void *);
	DECL_LINK(SelectRegression, void *);
	DECL_LINK(EditLoseFocusHdl, Control*);

    void FillValueSets();

public:
	SchStatisticTabPage (Window* pParent, const SfxItemSet& rInAttrs);
	virtual ~SchStatisticTabPage ();

	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
	virtual void Reset(const SfxItemSet& rInAttrs);

	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
};

/*************************************************************************
|*
|* Textausrichtungs-Tab-Page
|*
\************************************************************************/
class SchAlignmentTabPage : public SfxTabPage
{
private:


	//Seit 4/1998 koennen Texte frei gedreht werden: SID_ATTR_ALIGN_DEGREES
	SvxWinOrientation	aWinOrient;

	CheckBox   	aCbxTextOverlap;

	CheckBox   	aCbxTextBreak;
	FixedLine  	aFlTextBreak;

	RadioButton	aRbtSideBySide;
	RadioButton	aRbtUpDown;
	RadioButton	aRbtDownUp;
	RadioButton	aRbtAutoOrder;
	FixedLine	aFlOrder;
	OrderMode	eOrderMode;

	const SfxItemSet&	rOutAttrs;

	DECL_LINK(CheckButtonHdl, Button*);
	BOOL bTextCanOverlap;
public:
	SchAlignmentTabPage(Window* pParent, const SfxItemSet& rInAttrs);
	virtual ~SchAlignmentTabPage();

	static SfxTabPage* Create(Window* pParent, const SfxItemSet& rInAttrs);
	virtual BOOL FillItemSet(SfxItemSet& rOutAttrs);
	virtual void Reset(const SfxItemSet& rInAttrs);

	void SetOrderMode(OrderMode eMode);
	void SetTextCanOverlap(BOOL b){bTextCanOverlap=b;}
};

#endif	// _SCH_ATTRIB_HXX

