/*************************************************************************
 *
 *  $RCSfile: mover.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ka $ $Date: 2000/11/03 15:23:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SD_MOVER_HXX
#define _SD_MOVER_HXX

#include "movedef.hxx"
#include "sdmtf.hxx"
#include "speedctl.hxx"

// -----------------
// - SdBitmapMover -
// -----------------

class XPolyPolygon;
class GDIMetaFile;
class FuSlideShow;
class SdMetaFile;

class SdBitmapMover
{
private:

	FuSlideShow*		pFuSlideShow;
	Window* 			pWin;
	List*				pListOfImages;
	OutputDevice*		pInitDev;
	BitmapEx*			pTopLayer;
	SdMetaFile**		ppTopMtf;
	Polygon*			pPolygon;
	Marker				aObjStartMarker;
	Marker				aObjEndMarker;
	Region				aClip;
	ULONG				nMulti;
	ULONG				nMagic;
	MoveSpeed			eSpeed;
	MoverSpeedControl	aCtrl;
	double				mfStartScaleX;
	double				mfStartScaleY;
	double				mfEndScaleX;
	double				mfEndScaleY;

public:

						SdBitmapMover( Window* pWindow, FuSlideShow* pFu );
	virtual				~SdBitmapMover();
						
	void				SetPath( const XPolyPolygon& rXPolyPolygon, 
								 const double* pStartScaleX = NULL, const double* pEndScaleX = NULL,
								 const double* pStartScaleY = NULL, const double* pEndScaleY = NULL );
	void				SetPath( const Point& rStart, const Point& rEnd,
								 const double* pStartScaleX = NULL, const double* pEndScaleX = NULL,
								 const double* pStartScaleY = NULL, const double* pEndScaleY = NULL );
						
						// oberen Layer ueber TopLayer-BitmapEx zeichen
	void				SetGraphicInfo ( OutputDevice* pInitDevice, BitmapEx* _pTopLayer )
						{
							pInitDev = pInitDevice;
							pTopLayer = _pTopLayer;
							ppTopMtf = NULL; 
						}
						
						// oberen Layer ueber Metafile ab dem Ende-Marker zeichen
	void				SetGraphicInfo( OutputDevice* pInitDevice, SdMetaFile** _ppTopMtf, 
										const Marker& rObjStartMarker, const Marker& rObjEndMarker )
						{
							pInitDev = pInitDevice;
							pTopLayer = NULL;
							ppTopMtf = _ppTopMtf;
							aObjStartMarker = rObjStartMarker;
							aObjEndMarker = rObjEndMarker; 
						}
						
	void				SetWindow (Window* pWindow) { pWin = pWindow; }
	Window* 			GetWindow() const { return pWin; }
						
	void				SetSpeed( MoveSpeed eNewSpeed, ULONG nNewMulti = 1UL) { eSpeed = eNewSpeed; nMulti = nNewMulti; }
	MoveSpeed			GetSpeed() const { return eSpeed; }
						
	void				SetClipRegion(const Region& rR) { aClip = rR; }
	Region				GetClipRegion() const { return aClip; }
						
	void				SetListOfImages(List* pList) { pListOfImages = pList; }
	void				Terminate() { aCtrl.Terminate(); nMagic = 0UL; }
						
public:					
						
	BOOL				Move();
};


#endif // _SD_MOVER_HXX

