/*************************************************************************
 *
 *  $RCSfile: deinst.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: vg $ $Date: 2003/05/22 11:02:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#if (_MSC_VER < 1300)
#define VCL_NEED_BASETSD
#else
#define VCL_NEED_BASETSD 1
#endif

#ifdef WNT
#include <tools/presys.h>
#include <windows.h>
#include <shlobj.h>
#include <tools/postsys.h>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#include <sicustom.hxx>

#ifdef OS2
#include <tools/svpm.h>
#endif

SiSetupFnc aSetupFnc;

/////// EntryPoint ///////////////////////////////////////////////////////////// /*FOLD01*/
extern "C" {
	BOOL _SV_CALL CustomInit(SiSetupFnc* pSetupFnc, SiCustomFnc* pCustomFnc)
	{
		// inkompatibel oder nicht vorhanden ?
		if( !pSetupFnc || pSetupFnc->nVersion > SICUSTOM_VERSION ) return FALSE;

		pCustomFnc->fncMain = (FncPtrCustomMain)CustomMain;

		aSetupFnc.nVersion     	= pSetupFnc->nVersion;
		aSetupFnc.fncHideSetup	= pSetupFnc->fncHideSetup;
		aSetupFnc.fncShowSetup	= pSetupFnc->fncShowSetup;

		return TRUE;
	}
};

// Methoden fuer Windows-Registry
#ifdef WNT
BOOL getRegKey(HKEY rKey, const ByteString name, HKEY &result) /*fold01*/
{
	return (RegOpenKeyEx(rKey, name.GetBuffer(), 0, KEY_ALL_ACCESS, &result) == ERROR_SUCCESS);
}

BOOL getRegValue(HKEY rKey, const ByteString name, DWORD &type, void *buf, DWORD &len) /*fold01*/
{
	return (RegQueryValueEx(rKey, name.GetBuffer(), 0, &type, (unsigned char *) buf, &len) == ERROR_SUCCESS);
}

BOOL getRegSTRING(HKEY rKey, const ByteString name, ByteString &result) /*fold01*/
{
	DWORD type = REG_SZ;
	DWORD len = 1024;
	char *c = new char[len];
	if (!getRegValue(rKey, name, type, c, len)) return FALSE;
	result = c;
	return TRUE;
}

BOOL delRegKey(HKEY rKey, const char *rSubKey) /*fold01*/
{
	HKEY hKey;
	LONG lErr = RegOpenKeyEx(rKey, rSubKey, 0, KEY_ALL_ACCESS, &hKey);
	if (lErr != ERROR_SUCCESS) return TRUE;
	DWORD SubKeys, bMaxSubKeyLen;
	lErr = RegQueryInfoKey(hKey, 0, 0, 0, &SubKeys, &bMaxSubKeyLen, 0, 0, 0, 0, 0, 0);
	if (lErr != ERROR_SUCCESS)
	{
		if (hKey) RegCloseKey(hKey);
		return FALSE;
	}
	if (SubKeys > 0)
	{ // die Unterschluessel muessen in WinNT rekursiv geloescht werden
		bMaxSubKeyLen++;
		char *subNames = new char[bMaxSubKeyLen];
		for (int i = SubKeys - 1; i >= 0; i--)
		{
			DWORD l = bMaxSubKeyLen;
			lErr = RegEnumKeyEx(hKey, i, subNames, &l, 0, 0, 0, 0);
			if (lErr == ERROR_SUCCESS) delRegKey(hKey, subNames);
		}
		delete [] subNames;
	}
	if (hKey) RegCloseKey(hKey);
	lErr = RegDeleteKey(rKey, rSubKey);
	return (lErr == ERROR_SUCCESS);
}

#endif /*FOLD01*/

/////// CustomMain ///////////////////////////////////////////////////////////// /*FOLD00*/
BOOL _SV_CALL CustomMain(SiCustomEnvironment* pEnv, SiCustomModuleList* pList)
{
#ifdef WNT
	ByteString aAppName = "\"";
	aAppName += pEnv->GetInstalledPath();
	aAppName += "\\soffice.exe\" \"%1\"";
	ByteString prots[] = {"ftp", "http", "https", "mailto", "news"};
#define protCount sizeof(prots) / sizeof(prots[0])
	for (int i = protCount - 1; i >= 0; i--)
	{
		ByteString t = prots[i];
		t += "\\shell\\open\\command";
		BOOL bIsOffice = FALSE;
		HKEY command;
		if (getRegKey(HKEY_CLASSES_ROOT, t, command))
		{
			ByteString s;
			if (getRegSTRING(command, "", s))
			{
				if (stricmp(s.GetBuffer(), aAppName.GetBuffer()) == 0) bIsOffice = TRUE;
			}
			RegCloseKey(command);
			if (bIsOffice)
			{ // entfernen der WinRegEintraege, die von ProtChk gesetzt wurden (shell/open/command; defaulticon)
				delRegKey(HKEY_CLASSES_ROOT, prots[i].GetBuffer());
			}
		}
	}
#endif
#ifdef OS2
	ByteString aAppName = pEnv->GetInstalledPath();
	aAppName += "\\soffice.exe";
	char szBuffer[256];
	ULONG ulBytes = PrfQueryProfileByteString(HINI_PROFILE, "WPURLDEFAULTSETTINGS", "DefaultBrowserExe", NULL, szBuffer, 256);
	if (ulBytes)
	{
		if (stricmp(szBuffer, aAppName.GetBuffer()) == 0)
		{
			HOBJECT hObject = WinCreateObject("WPUrl", "", "DEFAULTBROWSER=EXPLORE.EXE;DEFAULTPARAMETERS=;DEFAULTWORKINGDIR=", "<WP_NOWHERE>", 0);
			if(hObject) WinDestroyObject(hObject);
			PrfWriteProfileByteString(HINI_PROFILE, "WPURLDEFAULTSETTINGS", "DefaultBrowserExe", "EXPLORE.EXE");
			PrfWriteProfileByteString(HINI_PROFILE, "WPURLDEFAULTSETTINGS", "DefaultParameters", "");
			PrfWriteProfileByteString(HINI_PROFILE, "WPURLDEFAULTSETTINGS", "DefaultWorkingDir", "");
		}
	}
#endif
	return TRUE;
}
