/*************************************************************************
#*
#*    $RCSfile: update.hxx,v $
#*
#*    class classname(s)
#*
#*    Implementation    UPDATE.HXX
#*
#*    Description       setup custom plugin for updateing a 6.0 to 6.x
#*                      main purpose is to provide an environment for a
#*                      XSLT parser/processor
#*                      
#*    Creation date     TPF  04/22/2002
#*    last change       $Author: hr $ $Date: 2003/03/27 11:08:28 $
#*    $Revision: 1.4 $
#*
#*    Copyright 2000 Sun Microsystems, Inc. All Rights Reserved.
#*
#*************************************************************************/

#ifndef _UPDATE_HXX_
#define _UPDATE_HXX_

//#include <vcl/resmgr.hxx>
#include <vos/security.hxx>
#include <osl/file.hxx>

using ::rtl::OUString;
using ::osl::Directory;
using ::osl::DirectoryItem;

class UpdatePlugIn
{
  public:
                        UpdatePlugIn            (   SiCustomEnvironment*    pEnvironment,
                                                    SiCustomModuleList*     pListOfModules,
                                                    const String            aSetupDir,
                                                    const String            aInstallDir,
                                                    const String            sInstalledDir,
                                                    const String            sProductName);
    virtual            ~UpdatePlugIn            (   );
    virtual BOOL        doUpdate                (   );

  private:
    void                recurseUpdateDirs       (       Directory &     aDir );
    void                transform               ( const OUString &      sSourceXml,
                                                  const OUString &      sTransformXml,
                                                  const OUString &      sDrainXml);

  private:
    SiCustomEnvironment*    m_pEnvironment;
    SiCustomModuleList*     m_pListOfModules;
        OUString            m_sXsltFile;
        OUString            m_sOldRootDir;
        OUString            m_sNewRootDir;
    const String            m_sSetupDir;
    const String            m_sInstallDir;
    const String            m_sInstalledDir;
    const String            m_sProductName;

};

#endif

