/*************************************************************************
 *
 *  $RCSfile: zipfile.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: ok $ $Date: 2000/09/26 09:41:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif

#include <svunzip.h>

#include "zipfile.hxx"
#include "decltor.hxx"

#define HIDE_SVUNZIP
#if defined(UNX) && defined(HIDE_SVUNZIP)

#include <vos/diagnose.hxx>
#include <vos/module.hxx>

extern "C" {
	typedef int SVUnzipE_type( const char* pZipFilePath, const char* pPattern,
							   UnzipEnumFilesCallBack*, void* pExtraData);
	typedef int SVUnzip_type(  const char* pZipFilePath, const char* pDestPath,
							   const char* pFlags,
							   UnzipCallBack *pCallBackFunc );
	typedef unsigned long getCRC32_type( const char* pZipFilePath );
	static BOOL SetupInitUnzip();
}

BOOL           bSetupOnce = SetupInitUnzip();
SVUnzip_type  *pSetupSVUnzip;
SVUnzipE_type *pSetupSVUnzipEnumFiles;
getCRC32_type *pSetupGetCRC32;

static BOOL SetupInitUnzip()
{
	ByteString  aZipName;
	NAMESPACE_VOS(OModule)  *pUnzipLib;

	aZipName  = "libzip";
	aZipName += ByteString::CreateFromInt32( SUPD );
	aZipName += __DLLEXTENSION;

	::rtl::OUString aModName( UniString(aZipName,osl_getThreadTextEncoding()) );
	pUnzipLib = new NAMESPACE_VOS(OModule);
	if( !pUnzipLib->load( aModName ) )
	{
		fprintf (stderr, "Can't load Zip-library %s\n", (const char*) aZipName.GetBuffer());
		delete pUnzipLib;
		abort();
	}

	pSetupSVUnzip          = (SVUnzip_type*) pUnzipLib->getSymbol(UniString::CreateFromAscii("SVUnzip"));
	pSetupSVUnzipEnumFiles = (SVUnzipE_type*)pUnzipLib->getSymbol(UniString::CreateFromAscii("SVUnzipEnumFiles"));
	pSetupGetCRC32		   = (getCRC32_type*)pUnzipLib->getSymbol(UniString::CreateFromAscii("getCRC32"));
	if( !pSetupSVUnzip || !pSetupSVUnzipEnumFiles )
	{
		fprintf (stderr, "Can't load symbols from Zip-library %s\n", (const char*) aZipName.GetBuffer());
		delete pUnzipLib;
		abort();
	}

	return TRUE;
}

#define SVUnzip pSetupSVUnzip
#define SVUnzipEnumFiles pSetupSVUnzipEnumFiles
#define getCRC32 pSetupGetCRC32

#endif // UNX && HIDE_SVUNZIP


SiZipFile* SiZipFile::m_pThis = NULL;

SiZipFile::SiZipFile()
{
	DBG_ASSERT(m_pThis == NULL, "ZipFile::ZipFile() more than one instance");
	m_pFile         = NULL;
	m_lBytesWritten = 0;
}

SiZipFile::~SiZipFile()
{}

// Auslesen der im Archiv enthaltenen Dateien
//

BOOL SiZipFile::AddSubfileListTo(ByteString const& aZipFile, SiFile *pFile, const char *pPattern)
{
	m_pFile = pFile;
	int n = SVUnzipEnumFiles( aZipFile.GetBuffer(), pPattern,
			(UnzipEnumFilesCallBack*)SiZipFile::EnumFilesCallBack, this );
	m_pFile = NULL;
	return n==0;
}

void SiZipFile::DetectFilesAndSize(const ByteString& rFilename)
{
	m_nFiles	= 0;
	m_nSize		= 0;
	m_pFile		= NULL;
	int n = SVUnzipEnumFiles( rFilename.GetBuffer(), "*",
			(UnzipEnumFilesCallBack*)SiZipFile::EnumFilesCallBack, this );
}

void SiZipFile::EnumFilesCallBack(char *pFile, ULONG nSize, void *pObject)
{
	((SiZipFile*)pObject)->OnEnumFile(pFile, nSize);
}

void SiZipFile::OnEnumFile(char *pFile, ULONG nSize)
{
	m_nFiles++;
	m_nSize += nSize;
	if( m_pFile )
		m_pFile->AddSubfile(pFile, nSize);
}

ULONG SiZipFile::GetCRC32(ByteString const& aZipFile)
{
	return getCRC32( aZipFile.GetBuffer() );
}

int SiZipFile::CRCCheck(ByteString const& aZipFile)
{
	m_pThis = this;
	#ifdef UNX
		int nErr = SVUnzip(aZipFile.GetBuffer(),"*","t",UnzipCallback);
	#else
		int nErr = SVUnzip(aZipFile.GetBuffer(),"*","t",(UnzipCallBack*)UnzipCallback);
	#endif
	m_pThis = NULL;
	return nErr;
}

// Auspacken einer Dateien
//

int SiZipFile::Unzip(ByteString const& aZipFile, ByteString const& anExtractName, BOOL bDoDontOverwriteUnzip )
{
	DBG_ASSERT(m_pThis == NULL, "ZipFile::Unzip() is not reentrant");
	m_pThis = this;

	ByteString aFlags;
	if( bDoDontOverwriteUnzip ) {
		#if defined(UNX)
		aFlags = "nqq";
		#elif defined(WIN)
		aFlags = "nqqs";
		#else
		aFlags = "nqq";
		#endif
	} else {
		#if defined(UNX)
		aFlags = "qqo";
		#elif defined(WIN)
		aFlags = "qqos";
		#else
		aFlags = "qqo";
		#endif
	}


	int nErr = SVUnzip( aZipFile.GetBuffer(), anExtractName.GetBuffer(), aFlags.GetBuffer(),
						(UnzipCallBack*) UnzipCallback );
	m_pThis = NULL;

	return nErr;
}

void SiZipFile::UnzipCallback(long lBytesWritten)
{
	// ACHTUNG:
	// Diese Callback-Funktion kann nicht den This-Pointer dieses
	// Objektes mit zurueckgeben. Deshalb speichert Unzip
	// den aktuellen This-Pointer in einer globalen Variable.
	if( m_pThis->m_aProgressLink.IsSet() &&
		lBytesWritten > 0 )
	{
		m_pThis->m_lBytesWritten = (ULONG) lBytesWritten;
		m_pThis->m_aProgressLink.Call(m_pThis);
	}
}
