/*************************************************************************
 *
 *  $RCSfile: modview.cxx,v $
 *
 *  $Revision: 1.11 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:08:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "modview.hxx"
#include "decltor.hxx"
#include "sihelp.hxx"

#include "environ.hxx"

#include "modview.hrc"
#include "strings.hrc"

#include <tools/l2txtenc.hxx>


class MyEntryString : public SvLBoxString
{
public:
	MyEntryString( SvLBoxEntry* pEntry, USHORT nFlags, const String& rStr ) :
		SvLBoxString(pEntry,nFlags,rStr) {}

	virtual void Paint( const Point& rPos, SvLBox& rDev, USHORT nFlags,
		SvLBoxEntry* pEntry);
};

void MyEntryString::Paint( const Point& rPos, SvLBox& rDev, USHORT nFlags,
						   SvLBoxEntry* pEntry )
{
	Font aOldFont( rDev.GetFont());
	Font aFont( aOldFont );
	ColorName nCol = COL_LIGHTRED;
	if( rDev.IsSelected(pEntry) )
		nCol = COL_YELLOW;
	Color aCol( nCol );
	aFont.SetColor( aCol );
	rDev.SetFont( aFont );
	rDev.DrawText( rPos, GetText() );
	rDev.SetFont( aOldFont );
}

bool SiModuleView::isHighContrast(Window* pParent)
{
	// HC Check

	// use normal bitmaps
	bool bReturn = false;

	if (pParent)
	{
		const Wallpaper& rWallpaper = pParent->GetDisplayBackground();
		if (rWallpaper.GetColor().IsDark())
		{
			// use HC bitmaps
			bReturn = true;
		}
	}
	return bReturn;
}

void SiModuleView::DataChanged( DataChangedEvent const & _rDCEvt )
{
	if (( _rDCEvt.GetType() == DATACHANGED_SETTINGS ) &&
        ( _rDCEvt.GetFlags() & SETTINGS_STYLE ))
    {
		// Do some changes for High contrast
		
		m_bHighContrastMode = isHighContrast(m_pParent);
		CommonConstruct();
		// Repaint();
    }
    // call super function
	SvTabListBox::DataChanged(_rDCEvt);

	// set all text colors
	// SetFTColor( m_aFTPrepare, TRUE );
}

SiModuleView::SiModuleView(Window* pParent, WinBits nWinStyle, USHORT nLanguage, BOOL bTop )
		: SvTabListBox(pParent,nWinStyle),
		  m_pParent(pParent),
		  m_bHighContrastMode(isHighContrast(pParent)),
		  m_pButtons(new SvLBoxButtonData())
{
	m_nLanguage = nLanguage;
	m_bTopLevelMode = bTop;
	CommonConstruct();
}

SiModuleView::SiModuleView(Window* pParent, const ResId& rResId, USHORT nLanguage, BOOL bTop)
		: SvTabListBox(pParent,rResId),
		  m_pParent(pParent),
		  m_bHighContrastMode(isHighContrast(pParent)),
		  m_pButtons(new SvLBoxButtonData())
{
	m_nLanguage = nLanguage;
	m_bTopLevelMode = bTop;
	CommonConstruct();
}

void SiModuleView::CommonConstruct()
{
	m_pTopClicked = NULL;

	SetDoubleClickHdl( LINK(this,SiModuleView,DblClickHdl) );

	// Bank fuer Erstinstallation
	if( m_bTopLevelMode )
	{
		m_pButtons->aBmps[SV_BMP_UNCHECKED]     = Image(ResId(BMP_TOP_NOT_INSTALLED));
		m_pButtons->aBmps[SV_BMP_HIUNCHECKED]   = Image(ResId(BMP_TOP_NOT_INSTALLED));
		m_pButtons->aBmps[SV_BMP_CHECKED]       = Image(ResId(BMP_TOP_INSTALL));
		m_pButtons->aBmps[SV_BMP_HICHECKED]     = Image(ResId(BMP_TOP_INSTALL));
		m_pButtons->aBmps[SV_BMP_TRISTATE]      = Image(ResId(BMP_TOP_INSTALLED));
		m_pButtons->aBmps[SV_BMP_HITRISTATE]    = Image(ResId(BMP_TOP_INSTALLED));
	}
	else
	{
		if (m_bHighContrastMode == false)
		{
			m_pButtons->aBmps[SV_BMP_UNCHECKED]     = Image(ResId(BMP_NOT_INSTALLED));
			m_pButtons->aBmps[SV_BMP_HIUNCHECKED]   = Image(ResId(BMP_NOT_INSTALLED));
			m_pButtons->aBmps[SV_BMP_CHECKED]       = Image(ResId(BMP_INSTALL));
			m_pButtons->aBmps[SV_BMP_HICHECKED]     = Image(ResId(BMP_INSTALL));
			m_pButtons->aBmps[SV_BMP_TRISTATE]      = Image(ResId(BMP_TRISTATE));
			m_pButtons->aBmps[SV_BMP_HITRISTATE]    = Image(ResId(BMP_TRISTATE));
		}
		else
		{
			m_pButtons->aBmps[SV_BMP_UNCHECKED]     = Image(ResId(BMP_NOT_INSTALLED_HC));
			m_pButtons->aBmps[SV_BMP_HIUNCHECKED]   = Image(ResId(BMP_NOT_INSTALLED_HC));
			m_pButtons->aBmps[SV_BMP_CHECKED]       = Image(ResId(BMP_INSTALL_HC));
			m_pButtons->aBmps[SV_BMP_HICHECKED]     = Image(ResId(BMP_INSTALL_HC));
			m_pButtons->aBmps[SV_BMP_TRISTATE]      = Image(ResId(BMP_TRISTATE_HC));
			m_pButtons->aBmps[SV_BMP_HITRISTATE]    = Image(ResId(BMP_TRISTATE_HC));
		}
	}
	
	// Bank fuer Deinstallation
	m_pButtons->aBmps[6+SV_BMP_UNCHECKED]   = Image(ResId(BMP_INSTALLED));
	m_pButtons->aBmps[6+SV_BMP_HIUNCHECKED] = Image(ResId(BMP_INSTALLED));
	m_pButtons->aBmps[6+SV_BMP_CHECKED]     = Image(ResId(BMP_DEINSTALL));
	m_pButtons->aBmps[6+SV_BMP_HICHECKED]   = Image(ResId(BMP_DEINSTALL));
	m_pButtons->aBmps[6+SV_BMP_TRISTATE]    = Image(ResId(BMP_TRISTATE));
	m_pButtons->aBmps[6+SV_BMP_HITRISTATE]  = Image(ResId(BMP_TRISTATE));

	EnableCheckButton(m_pButtons);
	// SetNodeBitmaps(Image(ResId(BMP_PLUS)), Image(ResId(BMP_MINUS)));
	SetNodeBitmaps( Image( ResId( BMP_PLUS )), Image( ResId( BMP_MINUS )), BMP_COLOR_NORMAL );
	SetNodeBitmaps( Image( ResId( BMP_PLUS_HC )), Image( ResId( BMP_MINUS_HC )), BMP_COLOR_HIGHCONTRAST );

#if SUPD >= 363
	long Tabs [4] = { 3, 24 };

	if( m_bTopLevelMode )
	{
		Tabs[2] = 300;
		Tabs[3] = 305;
	}
	else
	{
		Tabs[2] = 150;
		Tabs[3] = 185;
	}
#else
	long Tabs [] = { 2, 25, 180 };
#endif

	SetTabs( Tabs );
	SetTabJustify( 1, AdjustRight );
	SetHighlightRange( 1 );
}

SiModuleView::~SiModuleView()
{
	delete m_pButtons;
}

void SiModuleView::KeyInput( const KeyEvent &rKeyEvent )
{
	BOOL bProcessKey = FALSE;

	if( !rKeyEvent.GetKeyCode().IsShift()	&&
		!rKeyEvent.GetKeyCode().IsMod1()	&&
		!rKeyEvent.GetKeyCode().IsMod2() )
	{
		SvLBoxEntry* pEntry = GetCurEntry();

		switch( rKeyEvent.GetKeyCode().GetCode() )
		{
			case KEY_SPACE:
				CheckButtonHdl();
				bProcessKey = TRUE;
				break;

			case KEY_LEFT:
				if( pEntry ) {
					Collapse( pEntry );
					bProcessKey = TRUE;
				}
				break;

			case KEY_RIGHT:
				if( pEntry ) {
					Expand( pEntry );
					bProcessKey = TRUE;
				}
				break;
		}
	}
	SvTabListBox::KeyInput(rKeyEvent);
}

IMPL_LINK(SiModuleView,DblClickHdl,void*,pFoo)
{
	CheckButtonHdl();
	return 1;
}

void SiModuleView::InitEntry( SvLBoxEntry* pEntry, const String& rStr,
		const Image& rImg1, const Image& rImg2 )
{
	USHORT nColToHilite = 2;
	SvTabListBox::InitEntry( pEntry, rStr, rImg1, rImg2 );

	SiModule *pModule = (SiModule*)pEntry->GetUserData();
	if( pModule->DontSelectByUser() )
	{
		SvLBoxString* pCol = (SvLBoxString*)pEntry->GetItem( nColToHilite );
		MyEntryString* pStr = new MyEntryString( pEntry, 0, pCol->GetText() );
		pEntry->ReplaceItem( pStr, nColToHilite );
	}
}

SiModule* SiModuleView::IsMaxSelected(SiModule* pModule)
{
	if( pModule->DontSelectByUser() || pModule->GetModuleList()->Count() )
		return NULL;

	USHORT nModMaxSelCnt = pModule->GetMaxSelect();
	USHORT nParMaxSelCnt = 0;
	SiModule* pParMaxMod = NULL;
	SiModule* pMostParMaxMod = NULL;
	SiModule* pMod = pModule;

	if( !nModMaxSelCnt )
		do
		{
			pMod = pMod->GetParent();
			if( !pMod )
				continue;

			if( pMod->GetMaxSelect() )
			{
				if( !pParMaxMod )
				{
					pParMaxMod = pMod;
					nParMaxSelCnt = pMod->GetMaxSelect();
				}

				if( !pMostParMaxMod ||
					pMostParMaxMod->GetMaxSelect() <= pMod->GetMaxSelect() )
					pMostParMaxMod = pMod;
			}
		} while( /*nParMaxSelCnt == 0 */pMod != NULL );

	if( !pParMaxMod || (!nModMaxSelCnt && !nParMaxSelCnt) )
		return FALSE;

	USHORT nThisSelCnt = SiHelp::GetSelectedModuleCount( pParMaxMod );
	USHORT nMaxSelCnt = pMostParMaxMod? SiHelp::GetSelectedModuleCount(pMostParMaxMod) : 0;

	BOOL a = nThisSelCnt >= pParMaxMod->GetMaxSelect();
	BOOL b = pMostParMaxMod && nMaxSelCnt >= pMostParMaxMod->GetMaxSelect();

	if( a || b )
		return pMostParMaxMod && !a ? pMostParMaxMod : pParMaxMod;

	return NULL;
}

void SiModuleView::CheckButtonHdl()
{
	m_bOnceWarn = FALSE;
	SvLBoxEntry *pEntry  = GetHdlEntry();
	SiModule    *pModule = (SiModule*)pEntry->GetUserData();

	m_pTopClicked = pModule;

	if( m_bTopLevelMode && pModule->GetModuleList()->Count() )
	{
		SetCheckButtonState( pEntry, SV_BUTTON_TRISTATE );
		return;
	}

	if( pModule != NULL )
	{
		BOOL bForInstall;
		if(	pModule->DontSelectByUser() )
			bForInstall = pModule->IsSelected() || pModule->IsInstalled();
		else
			bForInstall = (!pModule->IsInstalled() && !pModule->IsSelected()) ||
						  (pModule->IsInstalled() &&  pModule->IsSelected() );


		MySelect( pEntry, bForInstall );
	}
	else
		// "Nicht-SiModule" nicht checken
		SetCheckButtonState(pEntry,SV_BUTTON_UNCHECKED);

    SetCurEntry( pEntry );
    SvTabListBox::CheckButtonHdl();
	UpdateAllTriStates();

	// Baum aufklappen, wenn Modul selektiert wird.
	//
	// Ist nicht gewuenscht!
/*	if (pModule != NULL
	&&  pModule->IsSelected()
	&& !pModule->IsInstalled())
		Expand(pEntry);
*/
	m_pTopClicked = NULL;
}

void SiModuleView::MySelect(SvLBoxEntry *pEntry, BOOL bForInstall)
{
	SiModule *pModule = (SiModule*) pEntry->GetUserData();

	if( pModule == NULL )
		return;

	// dieses Module selektieren
	if (bForInstall)
	{
		SiModule* pMaxSelMod = IsMaxSelected(pModule);
		if( pMaxSelMod )
		{
			SetCheckButtonState(pEntry, pModule->IsInstalled() || pModule->IsSelected() ?
								SV_BUTTON_CHECKED : SV_BUTTON_UNCHECKED );
			pModule->Select(pModule->IsInstalled() || pModule->IsSelected() ?
								SiModule::THIS_SEL : SiModule::THIS_UNSEL );

			if( !m_bOnceWarn )
			{
				BOOL bSure = pMaxSelMod == m_pTopClicked ? TRUE :
							 pMaxSelMod == m_pTopClicked->GetParent();
				if( bSure )
				{
					m_bOnceWarn = TRUE;
					m_aWarnLink.Call( (void*)pMaxSelMod );
				}
			}
		}
		else
		{
			SetCheckButtonState(pEntry, pModule->IsInstalled() ? SV_BUTTON_UNCHECKED : SV_BUTTON_CHECKED);
			pModule->Select( SiModule::THIS_SEL );
		}
	}
	else // for Uninstall
	{
		SetCheckButtonState(pEntry, pModule->IsInstalled() ? SV_BUTTON_CHECKED : SV_BUTTON_UNCHECKED);
		pModule->Select( SiModule::THIS_UNSEL );
	}

	// Alle Kinder auch selektieren
	//
	if (pEntry->HasChilds())
	{
		SvLBoxEntry *pSibling = (SvLBoxEntry*) GetModel()->FirstChild(pEntry);

		while (pSibling != NULL)
		{
			SiModule *pSibMod = (SiModule*)pSibling->GetUserData();
			if( pSibMod->DontSelectByUser() )
				MySelect( pSibling, pSibMod->IsSelected() || pSibMod->IsInstalled() );
			else
				MySelect( pSibling,bForInstall );
			pSibling = (SvLBoxEntry*) GetModel()->NextSibling(pSibling);
		}
	}
}

void SiModuleView::List
(
	SiModule *pModule,
	ULONG	  lClusterSize,
	BOOL	  bWorkstation,
	BOOL	  bDisplayRoot,
	BOOL	  bModulesOnly
)
{
	if (pModule != NULL)
	{
		List(pModule, NULL, lClusterSize, bWorkstation, bDisplayRoot, bModulesOnly);
		UpdateAllTriStates();
	}
}

void SiModuleView::List
(
	SiModule	 *pModule,
	SvLBoxEntry	 *pParent,
	ULONG		  lClusterSize,
	BOOL		  bWorkstation,
	BOOL		  bDisplayLevel,
	BOOL		  bModulesOnly
)
{
	if (pModule == NULL)
		return;

	SiEnvironment aEmptyEnv;
	ULONG  lSize  = pModule->CalculateSize( aEmptyEnv, SiModule::ALL, lClusterSize, FALSE /* bSystem*/, bWorkstation) / 1024;

	String aName;
	SiModule* pLangRef = NULL;
	if( pModule->HasLangRef() )
	{
		pLangRef = (SiModule*) pModule->GetLangRef(m_nLanguage);
		if( pLangRef ) pLangRef->JoinWithParent();
	}

	aName = pLangRef?
 			UniString( pLangRef->GetName(), Langcode2TextEncoding(m_nLanguage) ) :
			UniString( pModule->GetName(),  Langcode2TextEncoding(m_nLanguage) );

	if( !m_bTopLevelMode )
		( ( ( aName += '\t' ) += UniString::CreateFromInt32(lSize) ) += ' ' ) += UniString( ResId( STR_KB ) );

	SiModuleList const* pList  = pModule->GetModuleList();
	SvLBoxEntry       * p      = NULL;

	if( bDisplayLevel && !pModule->IsHidden() && !pModule->IsHiddenRecursive() )
		p = SvTreeListBox::InsertEntry( aName, pParent, FALSE, LIST_APPEND, (void*)pModule );

	if (p != NULL)
	{
		// z.Zt. noch noetig
		SetEntryText(aName,p);

		// Bitmap-Bereich setzen
		SvLBoxButton *pButton = (SvLBoxButton *)p->GetFirstItem(SV_ITEM_ID_LBOXBUTTON);
		pButton->SetBaseOffs(pModule->IsInstalled() ? 6 : 0);

		// Modulselektion sichtbar machen
		if( m_bTopLevelMode )
		{
			if( pList->Count() )
				SetCheckButtonState( p, SV_BUTTON_TRISTATE );
			else
			if( pModule->IsSelected() )
				SetCheckButtonState( p, SV_BUTTON_CHECKED );
			else
				SetCheckButtonState( p, SV_BUTTON_UNCHECKED );
		}
		else
			if( pModule->IsSelected() )
				SetCheckButtonState( p, SV_BUTTON_CHECKED );
	}

	// Untermodule rekursiv abarbeiten
	for (USHORT i=0; i < pList->Count(); i++)
		List(pList->GetObject(i),p,lClusterSize,bWorkstation,TRUE,bModulesOnly);

	// zus"azliche Informationen anzeigen
	if( bDisplayLevel && !bModulesOnly && !m_bTopLevelMode )
	{
		SiFileList const& Files = pModule->GetFileList();

		if (Files.Count() > 0)
		{
			SvLBoxEntry *pF = SvTreeListBox::InsertEntry(UniString::CreateFromAscii("Files"), p);

			for (USHORT i=0; i < Files.Count(); i++)
			{
				List(Files.GetObject(i), pF);
			}
		}

		SiFolderItemList const& rFolderItems = pModule->GetFolderItemList();

		if (rFolderItems.Count() > 0)
		{
			SvLBoxEntry *pF = SvTreeListBox::InsertEntry(UniString::CreateFromAscii("Folder Items"), p);

			for (USHORT i=0; i < rFolderItems.Count(); i++)
			{
				SiFolderItem const* pFolderItem = rFolderItems.GetObject(i);

				SvLBoxEntry *pFI  = SvTreeListBox::InsertEntry(UniString::CreateFromAscii(pFolderItem->GetName().GetBuffer()), pF);
				SvLBoxEntry *pFld = SvTreeListBox::InsertEntry(UniString::CreateFromAscii("Folder"),pFI);

				if (pFolderItem->GetFolder() != NULL)
				{
					SvTreeListBox::InsertEntry(pFolderItem->GetFolder()->GetName(), pFld);
					List(pFolderItem->GetFile(), pFI);
				}
			}
		}
	}
}

void SiModuleView::List(SiFile const* pFile, SvLBoxEntry* pParent)
{
	if (pFile == NULL)
		return;

	SvLBoxEntry			*pThisFile = SvTreeListBox::InsertEntry(UniString::CreateFromAscii(pFile->GetName().GetBuffer()), pParent);
	SiDirectory   const *pDir      = pFile->GetDirectory();

	if (pDir != NULL)
		SvTreeListBox::InsertEntry(UniString::CreateFromAscii( pDir->GetName().GetBuffer()), pThisFile );
}

void SiModuleView::Select(Selection eSel)
{
	for (SvLBoxEntry *p=First(); p!=NULL; p=Next(p))
	{
		SiModule *pModule = (SiModule*)p->GetUserData();

		if (pModule != NULL)
		{
			BOOL bSel  = eSel == ALL
					  || eSel == MINIMAL &&	pModule->IsMinimal()
					  || eSel == DEFAULT &&	pModule->IsDefault();

			pModule->Select(bSel ? SiModule::THIS_SEL : SiModule::THIS_UNSEL);
			SetCheckButtonState(p, bSel ? SV_BUTTON_CHECKED : SV_BUTTON_UNCHECKED);
		}
	}

	UpdateAllTriStates();
}

void SiModuleView::UpdateAllTriStates()
{
	SvTreeList   *pTreeList = GetModel();
	SvLBoxEntry  *pEntry    = (SvLBoxEntry*)pTreeList->First();

	// Alle Knoten der ersten Ebene traversieren
	//
	while (pEntry != NULL)
	{
		UpdateTriStates(pEntry);
		pEntry = (SvLBoxEntry*) GetModel()->NextSibling(pEntry);
	}
}


SiModuleView::TriState SiModuleView::UpdateTriStates(SvLBoxEntry *pEntry)
{
	if( m_bTopLevelMode )
		return STATE_NON;

	if (pEntry->GetUserData() == NULL)
		return STATE_NON; // kein Modul/nicht selektierbar

	SiModule *pModule = (SiModule *)pEntry->GetUserData();

	// Blatt ?
	//
	if (!pEntry->HasChilds())
	{
		if ((pModule->IsSelected() && !pModule->IsInstalled())
		|| (!pModule->IsSelected() &&  pModule->IsInstalled())) // ?
			return STATE_ALL;
		else
			return STATE_NON;
	}

	// kein Blatt: Status der Kinder feststellen
	//
	int nAll	= 0;
	int nSel	= 0;
	int nUnSel	= 0;

	SvLBoxEntry *pSibling = (SvLBoxEntry*) GetModel()->FirstChild(pEntry);

	while (pSibling != NULL)
	{
		nAll++;

		switch (UpdateTriStates(pSibling))
		{
			case STATE_ALL: nSel++;   break;
			case STATE_NON: nUnSel++; break;
			case STATE_SOME:		  break;
		}

		pSibling = (SvLBoxEntry*) GetModel()->NextSibling(pSibling);
	}

	// Wenn das Modul abhaengige Objekte hat (ausser Kindmodule)
	// muss noch der Status dieses Moduls mit beruecksichtigt werden.
	//
/*	if (pModule->HasObjects())
	{
		nAll++;

		if (pModule->IsSelected())
		{
			if (pModule->IsInstalled())
				nUnSel++;
			else
				nSel++;
		}
		else
		{
			if (pModule->IsInstalled())
				nSel++;
			else
				nUnSel++;
		}
	}
*/
	// Status vom aktuellen Knoten setzen
	//
	if (nAll == nSel)
	{
		// Alle Kinder und "ich" sind installiert oder sollen es werden:
		//
		SetCheckButtonState(pEntry, !pModule->IsInstalled() ?
				SV_BUTTON_CHECKED : SV_BUTTON_UNCHECKED);

		pModule->Select( SiModule::THIS_SEL );

		return STATE_ALL;
	}
	else if (nAll == nUnSel)
	{
		// Alle Kinder und "ich" sind deinstalliert oder sollen es werden:
		//
		SetCheckButtonState(pEntry, pModule->IsInstalled() ?
				SV_BUTTON_CHECKED : SV_BUTTON_UNCHECKED);

		pModule->Select( SiModule::THIS_UNSEL );

		return STATE_NON;
	}
	else
	{
		SetCheckButtonState(pEntry, SV_BUTTON_TRISTATE);
		return STATE_SOME;
	}
}

