/*************************************************************************
 *
 *  $RCSfile: pupdate.cxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:09:15 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _OSL_THREAD_H_
#include <osl/thread.h>
#endif

#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#include "maindlg.hxx"
#include "environ.hxx"
#include "event.hxx"
#include "script.hxx"

#include "pupdate.hxx"
#include "pupdate.hrc"

PageUpdateInstall::PageUpdateInstall( SvAgentDlg* pParent, const ResId& rResId ) :
	SvAgentPage		( pParent, rResId ),
	aFTInfo1		( this, ResId(FT_INFO1, rResId.GetResMgr()) ),
	aFTInfo2		( this, ResId(FT_INFO2, rResId.GetResMgr()) ),
	aFLInfo3		( this, ResId(FL_INFO3, rResId.GetResMgr()) ),
    aRBUpdate       ( this, ResId(RB_UPDATE,        rResId.GetResMgr()) ),
    aRBCreateNew    ( this, ResId(RB_CREATE_NEW,    rResId.GetResMgr()) ),
	aFTInfo4		( this, ResId(FT_INFO4, rResId.GetResMgr()) ),
	aFTInfo8		( this, ResId(FT_INFO8, rResId.GetResMgr()) ),
	aMsgWrongLang	(       ResId(STR_WRONG_LANG, rResId.GetResMgr()) ),
	aMsgUpdateOnly  (       ResId(STR_UPDATE_ONLY, rResId.GetResMgr()) ),
	aMsgNoRights    (       ResId(STR_UPDATE_NO_RIGHTS, rResId.GetResMgr()) ),
	aMsgCantUpdateNetInst ( ResId(STR_CANT_UPDATE_NET_INST, rResId.GetResMgr()) ),
	aMsgCantUpdateStdInst ( ResId(STR_CANT_UPDATE_STD_INST, rResId.GetResMgr()) ),
	aMsgCantUpdateStdInst2( ResId(STR_CANT_UPDATE_STD_INST_WRK, rResId.GetResMgr()) ),
	aMsgCantUpdateWrkInst ( ResId(STR_CANT_UPDATE_WRK_INST, rResId.GetResMgr()) ),
    aMsgCantUpdateTitle   ( ResId(STR_CANT_UPDATE_TITLE, rResId.GetResMgr()) )
{
	String aTitle( ResId(STR_TITLE, rResId.GetResMgr()) );
	aTitle.SearchAndReplace( UniString::CreateFromAscii("%1"),
			UniString::CreateFromAscii(GETDLG()->GetEnv()->GetProductName().GetBuffer()) );

	pParent->SetTitleStr( aTitle );

	FreeResource();

    String aText = aFTInfo2.GetText();
    String aReplacement;
    if ( GETDLG()->GetOldCScript() )
    {
        ByteString aText = GETDLG()->GetOldCScript()->GetInstallation()->GetDestPath();
        aReplacement = String( aText, osl_getThreadTextEncoding() );
    }
    else
    {
        ByteString aText = GETDLG()->GetEnv()->GetInstalledPath();
        aReplacement = String( aText, osl_getThreadTextEncoding() );
    }
    aText.SearchAndReplaceAscii( "%1", aReplacement );
    aFTInfo2.SetText( aText );
    aFTInfo2.Show();

    aMsgWrongLang.SearchAndReplaceAscii( "%1", aReplacement );
    aMsgNoRights.SearchAndReplaceAscii( "%1", aReplacement );

#ifndef UNX
	aFTInfo4.Show();    // bitte alle Anwendungen schliessen!
#endif

    SiEnvironment::UpdateError eError = GETDLG()->GetEnv()->GetUpdateError();

    switch ( eError )
    {
        case SiEnvironment::UPDATE_NO_VERSION:
	        aFTInfo2.Hide();
		    aFTInfo4.Hide();
            aFTInfo8.Show();
            break;

        case SiEnvironment::CANT_UPDATE_WRONG_LANG:
        case SiEnvironment::CANT_UPDATE_NO_RIGHTS:
        case SiEnvironment::CANT_UPDATE_NET_INSTALL:
        case SiEnvironment::CANT_UPDATE_STD_INSTALL_NET:
        case SiEnvironment::CANT_UPDATE_STD_INSTALL_WRK:
        case SiEnvironment::CANT_UPDATE_WRK_INSTALL:
		    aFLInfo3.Show();
            aRBUpdate.Show();
            aRBUpdate.Disable();
            aRBCreateNew.Show();
            break;

        case SiEnvironment::ONLY_UPDATE_ALLOWED:
		    aFLInfo3.Show();
            aRBUpdate.Show();
            aRBCreateNew.Show();
            aRBCreateNew.Disable();
            break;

        default:
		    aFLInfo3.Show();
            aRBUpdate.Show();
            aRBCreateNew.Show();
            break;
	}

	Font aBold( aFTInfo1.GetFont() );
	aBold.SetWeight( WEIGHT_BOLD );
	aFTInfo1.SetFont( aBold );
}

PageUpdateInstall::~PageUpdateInstall()
{
}

ULONG PageUpdateInstall::GetProperty()
{
    if ( aRBCreateNew.IsChecked() )
        return RETURN_CREATE_NEW;

    return RETURN_UPDATE;
}

void PageUpdateInstall::ShowCantUpdateMsg( const String& rMsg ) const
{
    String   aMsg( rMsg );
    QueryBox aQuery( NULL, WB_OK_CANCEL | WB_DEF_CANCEL, aMsg );

    aMsg.SearchAndReplaceAscii( "%OK", aQuery.GetButtonText( BUTTONID_OK ) );
    aMsg.SearchAndReplaceAscii( "%CANCEL", aQuery.GetButtonText( BUTTONID_CANCEL ) );

    aQuery.SetMessText( aMsg );
    aQuery.SetText( aMsgCantUpdateTitle );

    if ( aQuery.Execute() != RET_OK )
        Application::PostUserEvent( EVT_END );
}

void PageUpdateInstall::InitProperty( ULONG nProp )
{
    if ( nProp == PROP_NOTSET )
    {
        if ( GETDLG()->GetCScript()->GetInstallation()->KeepOldVersion() )
            nProp = RETURN_CREATE_NEW;
        else
            nProp = RETURN_UPDATE;
        
        SiEnvironment::UpdateError eError = GETDLG()->GetEnv()->GetUpdateError();
        
        switch ( eError )
        {
            case SiEnvironment::CANT_UPDATE_THAT_VERSION:  break;
            case SiEnvironment::CANT_UPDATE_WRONG_LANG:
                {
                    ShowCantUpdateMsg( aMsgWrongLang );
                    nProp = RETURN_CREATE_NEW;
                }
                break;
            case SiEnvironment::CANT_UPDATE_NO_RIGHTS:
                {
                    ShowCantUpdateMsg( aMsgNoRights );
                    nProp = RETURN_CREATE_NEW;
                }
                break;
            case SiEnvironment::ONLY_UPDATE_ALLOWED:
                {
                    InfoBox aInfo( NULL, aMsgUpdateOnly );
                    aInfo.Execute();
                    nProp = RETURN_UPDATE;
                }
                break;
            case SiEnvironment::CANT_UPDATE_NET_INSTALL:
                {
                    ShowCantUpdateMsg( aMsgCantUpdateNetInst );
                    nProp = RETURN_CREATE_NEW;
                }
                break;
            case SiEnvironment::CANT_UPDATE_STD_INSTALL_NET:
                {
                    ShowCantUpdateMsg( aMsgCantUpdateStdInst );
                    nProp = RETURN_CREATE_NEW;
                }
                break;
            case SiEnvironment::CANT_UPDATE_STD_INSTALL_WRK:
                {
                    ShowCantUpdateMsg( aMsgCantUpdateStdInst2 );
                    nProp = RETURN_CREATE_NEW;
                }
                break;
            case SiEnvironment::CANT_UPDATE_WRK_INSTALL:
                {
                    ShowCantUpdateMsg( aMsgCantUpdateWrkInst );
                    nProp = RETURN_CREATE_NEW;
                }
                break;
        }
    }

    if ( nProp == RETURN_CREATE_NEW )
    {
        aRBUpdate.Check( FALSE );
        aRBCreateNew.Check( TRUE );
    }
    else
    {
        aRBUpdate.Check( TRUE );
        aRBCreateNew.Check( FALSE );
    }
}

USHORT PageUpdateInstall::GetReturnVal()
{
    if ( aRBUpdate.IsVisible() && aRBUpdate.IsChecked() )
    {
        GETDLG()->GetEnv()->SetUpdateOldVersion( TRUE );
        GETDLG()->GetEnv()->SetMigrationAvailable( FALSE );     // No migration when updating
    }
    else
        GETDLG()->GetEnv()->SetUpdateOldVersion( FALSE );

    return USHRT_MAX;
}

SvAgentPage* PageUpdateInstall::Create( SvAgentDlg* pParent, const ResId& rResId )
{
	return new PageUpdateInstall( pParent, rResId );
}
