/*************************************************************************
 *
 *  $RCSfile: texture.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:51:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_OUTDEV_HXX //autogen
#include <vcl/outdev.hxx>
#endif

#define _TEXTURE_CXX
#define private public

#include "texture.hxx"

ImpTexture::ImpTexture()
{
	nRefCount       = 1;
	eStyle          = TEXTURE_NULL;
}

ImpTexture::ImpTexture( const ImpTexture& rImpTexture ) :
				aBitmap( rImpTexture.aBitmap )
{
	nRefCount       = 1;
	eStyle          = rImpTexture.eStyle;
}

inline void ImpMakeUnique( Texture* p )
{
	if ( p->pImpTexture->nRefCount != 1 )
	{
		if ( p->pImpTexture->nRefCount )
			p->pImpTexture->nRefCount--;
		p->pImpTexture = new ImpTexture( *(p->pImpTexture) );
	}
}

Texture::Texture()
{
	pImpTexture = new ImpTexture;
}

Texture::Texture( const Texture& rTexture )
{
	pImpTexture = rTexture.pImpTexture;
	pImpTexture->nRefCount++;
}

Texture::Texture( const Bitmap& rBitmap, TextureStyle eStyle )
{
	pImpTexture           = new ImpTexture;
	pImpTexture->aBitmap  = rBitmap;
	pImpTexture->eStyle   = eStyle;
}

Texture::~Texture()
{
	if ( pImpTexture->nRefCount == 1 )
		delete pImpTexture;
	else
		pImpTexture->nRefCount--;
}

void Texture::SetStyle( TextureStyle eStyle )
{
	ImpMakeUnique( this );
	pImpTexture->eStyle = eStyle;
}

void Texture::SetBitmap( const Bitmap& rBitmap )
{
	ImpMakeUnique( this );
	pImpTexture->aBitmap = rBitmap;
}

void Texture::SetOffsetPixel( const Point& rPos )
{
	ImpMakeUnique( this );
	pImpTexture->aOffset = rPos;
}

Texture& Texture::operator=( const Texture& rTexture )
{
	rTexture.pImpTexture->nRefCount++;

	if ( pImpTexture->nRefCount == 1 )
		delete pImpTexture;
	else
		pImpTexture->nRefCount--;
	pImpTexture = rTexture.pImpTexture;

	return *this;
}

BOOL Texture::operator==( const Texture& rTexture ) const
{
	if ( pImpTexture == rTexture.pImpTexture )
		return TRUE;

	if ( (pImpTexture->eStyle     == rTexture.pImpTexture->eStyle)          ||
		 (pImpTexture->aBitmap    == rTexture.pImpTexture->aBitmap)          ||
		 (pImpTexture->aOffset    == rTexture.pImpTexture->aOffset) )
		return TRUE;
	else
		return FALSE;
}

void DrawTexture( OutputDevice* pWindow, const Texture& rTexture )
{
	 if ( (rTexture.GetStyle() == TEXTURE_NULL) || !(rTexture.GetBitmap()) )
		return;

	TextureStyle  eStyle = rTexture.GetStyle();
	const Bitmap&   rBitmap = rTexture.GetBitmap();
	Size            aOutSize = pWindow->GetOutputSizePixel();

	BOOL bIsMapModeEnabled = pWindow->IsMapModeEnabled();
	pWindow->EnableMapMode( FALSE );

	if ( eStyle == TEXTURE_CENTER )
	{
		Size    aBmpSize = rBitmap.GetSizePixel();
		Point   aPos( (aOutSize.Width()-aBmpSize.Width())/2,
					  (aOutSize.Height()-aBmpSize.Height())/2 );
		if ( aPos.X() < 0 )
			aPos.X() = 0;
		if ( aPos.Y() < 0 )
			aPos.Y() = 0;
		pWindow->DrawBitmap( aPos, rBitmap );
	}
	else if ( eStyle == TEXTURE_TILE )
	{
		Point   aOff = rTexture.GetOffsetPixel();
		Size    aBmpSize = rBitmap.GetSizePixel();

		aOff.X() -= (aOff.X()/aBmpSize.Width())*aBmpSize.Width();
		aOff.Y() -= (aOff.Y()/aBmpSize.Height())*aBmpSize.Height();

		Point aPos = aOff;
		do
		{
			aPos.X() = aOff.X();
			do
			{
				pWindow->DrawBitmap( aPos, rBitmap );
				aPos.X() += aBmpSize.Width();
			}
			while ( aPos.X() < aOutSize.Width() );
			aPos.Y() += aBmpSize.Height();
		}
		while ( aPos.Y() < aOutSize.Height() );
	}
	else if ( eStyle == TEXTURE_SCALE )
		pWindow->DrawBitmap( Point(), aOutSize, rBitmap );

	pWindow->EnableMapMode( bIsMapModeEnabled );
}

