/*************************************************************************
 *
 *  $RCSfile: fsetobsh.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:52:23 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _FSETOBJSH_HXX
#define _FSETOBJSH_HXX

#include "objsh.hxx"
#include "docfac.hxx"

class SfxFrameSetDescriptor;
class SfxFrameSetObjectShell_Impl;
class SvStrings;

//==========================================================================
// Eine SfxFrameSetObjectShell ist ein Dokument, das praktisch nur aus
// ::com::sun::star::sdbcx::View-Daten besteht. Es stellt eine Anweisung dar, wie andere Inhalte,
// repr"asentiert durch URLs, in SfxFrames dargestellt werden sollen. Das so
// aufgebaute SfxFrameSet umfa\st die vollst"andigen FrameSets in der
// Netscape-HTML-Erweiterung.
// Die SfxFrameSet-Dokumente bieten HTML-Import und -Export.
//==========================================================================

class SfxFrameSetObjectShell: public SfxObjectShell
{
friend class SfxFrameHTMLParser;
	SfxFrameSetDescriptor*          pDescriptor;
	SfxFrameSetObjectShell_Impl*	pImp;

protected:
	virtual void    FillClass( SvGlobalName * pClassName,
								   sal_uInt32 * pClipFormat,
								   String * pAppName,
								   String * pLongUserName,
								   String * pUserName ) const;
public:
					TYPEINFO();
					SfxFrameSetObjectShell(SfxObjectCreateMode = SFX_CREATE_MODE_EMBEDDED);
					~SfxFrameSetObjectShell();

					SFX_DECL_INTERFACE(SFX_INTERFACE_SFXFRAMESETOBJ);
                    SFX_DECL_SIMPLE_OBJECTFACTORY(SfxFrameSetObjectShell);

	virtual sal_Bool    ConvertTo( SfxMedium& rMed );
	virtual sal_Bool    ConvertFrom( SfxMedium& rMed );
	void 			Exec_Impl(SfxRequest&);
	void 			State_Impl(SfxItemSet&);
	virtual sal_Bool	InitNew( SvStorage* );
	virtual sal_Bool	Load( SvStorage* );
	virtual sal_Bool    Save();
	virtual sal_Bool    SaveAs( SvStorage* );
	virtual sal_Bool	SaveCompleted( SvStorage* );

	const SfxFrameSetDescriptor*
					GetFrameSetDescriptor() const
					{ return pDescriptor; }
	sal_Bool			Initialize( const String& );
	void			TakeDescriptor( SfxFrameSetDescriptor *pSet );
	void			ReInit_Impl( SfxFrameSetDescriptor *pSet);
	String			GetSource();
	void			TakeSource( const String& rSource );
	void			SetScriptsAndComments( SvStrings*, SvStrings* );
};

#include <cppuhelper/weak.hxx>
#include "objuno.hxx"
#ifndef _COM_SUN_STAR_FRAME_XFRAMESETMODEL_HPP_
#include <com/sun/star/frame/XFrameSetModel.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICENAME_HPP_
#include <com/sun/star/lang/XServiceName.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
namespace com{namespace sun{namespace star{namespace lang{
class XMultiServiceFactory;
}}}}

class SfxFrameSetModel	:	public SfxBaseModel								,
							public ::com::sun::star::frame::XFrameSetModel	,
							public ::com::sun::star::lang::XServiceInfo
{
	SfxFrameSetObjectShell* pDoc;
	::rtl::OUString				aSource;
public:
	SfxFrameSetModel( const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > & xFactory );
	SfxFrameSetModel( SfxFrameSetObjectShell *pDoc );
	virtual ~SfxFrameSetModel();

	// XInterface, XTypeProvider, XServiceInfo + Helper + createInstance + createFactory + static
	SFX_DECL_XINTERFACE_XTYPEPROVIDER_XSERVICEINFO

	// XFrameSetModel
	virtual	void SAL_CALL setSource( const ::rtl::OUString& rSource ) throw ( ::com::sun::star::uno::RuntimeException );
	virtual ::rtl::OUString SAL_CALL getSource() throw ( ::com::sun::star::uno::RuntimeException );
};

#endif

