/*************************************************************************
 *
 *  $RCSfile: sysprxsettings.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: tra $ $Date: 2001/05/28 06:30:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//------------------------------------------------------------------------
// includes
//------------------------------------------------------------------------

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef _SYSPRXSETTINGS_HXX_
#include "sysprxsettings.hxx"
#endif

#include <malloc.h>
#include <map>
#include <utility>

//------------------------------------------------------------------------
// namespace directives
//------------------------------------------------------------------------

using com::sun::star::uno::Reference;
using com::sun::star::uno::RuntimeException;
using com::sun::star::uno::Sequence;
using com::sun::star::lang::XServiceInfo;
using com::sun::star::system::XProxySettings;
using rtl::OUString;
using osl::Mutex;

using namespace cppu;

//------------------------------------------------------------------------
// defines
//------------------------------------------------------------------------

#define COMP_IMPL_NAME   "com.sun.star.comp.system.SystemProxySettings"
#define WININET_DLL_NAME "wininet.dll" 

#define EQUAL_SIGN '='
#define COLON      ':'
#define SPACE      ' '
#define SEMI_COLON ';'

//------------------------------------------------------------------------
// constants
//------------------------------------------------------------------------

const OUString FTP    = OUString::createFromAscii( "ftp" );
const OUString HTTP   = OUString::createFromAscii( "http" );
const OUString HTTPS  = OUString::createFromAscii( "https" );
const OUString SOCKS  = OUString::createFromAscii( "socks" );  
const OUString GOPHER = OUString::createFromAscii( "gopher" );

//------------------------------------------------------------------------
// helper functions
//------------------------------------------------------------------------

namespace // private
{
	Sequence< OUString > SAL_CALL Component_getSupportedServiceNames()
	{
		Sequence< OUString > aRet(2);
		aRet[0] = OUString::createFromAscii("com.sun.star.system.ProxySettings");
        aRet[1] = OUString::createFromAscii("com.sun.star.system.SystemProxySettings");

		return aRet;
	}
    
    CSysProxySettings::ProxyEntry getNextProxy( const OUString& aProxyList, sal_Int32& aIndex )
    {
        OSL_ASSERT( aIndex > -1 );

        CSysProxySettings::ProxyEntry pE;
        
        // get the next token, e.g. ftp=server:port
        OUString nextToken = aProxyList.getToken( 0, SPACE, aIndex );
        
        // split the next token again into the parts separated 
        // through '=', e.g. ftp=server:port -> ftp and server:port
        sal_Int32 i = 0;              
        if ( nextToken.indexOf( EQUAL_SIGN ) > -1 )
            pE.Type = nextToken.getToken( 0, EQUAL_SIGN, i );
        
        pE.Server = nextToken.getToken( 0, COLON, i );

        if ( i > -1 )
            pE.Port   = nextToken.getToken( 0, COLON, i );

        return pE;
    }

    inline
    sal_Bool isTypeIndepProxy( const CSysProxySettings::ProxyEntry& aProxyEntry )
    {
        return ( 0 == aProxyEntry.Type.getLength( ) );
    }

} // end private namespace

//-------------------------------------------------
//
//-------------------------------------------------

CSysProxySettings::CSysProxySettings( ) : 
	WeakComponentImplHelper2< XProxySettings, XServiceInfo >( m_aMutex )
{	     
	m_lpfnInternetQueryOption = NULL;

    m_hWinInetDll = LoadLibrary( WININET_DLL_NAME );
    if ( m_hWinInetDll )
        m_lpfnInternetQueryOption = 
            reinterpret_cast< InternetQueryOption_Proc_T >( 
                GetProcAddress( m_hWinInetDll, "InternetQueryOptionA" ) );
}

//-------------------------------------------------
//
//-------------------------------------------------

CSysProxySettings::~CSysProxySettings( )
{
    if ( m_hWinInetDll )
        FreeLibrary( m_hWinInetDll );
}

//-------------------------------------------------
//
//-------------------------------------------------

OUString SAL_CALL CSysProxySettings::getFtpProxyAddress(  ) throw (RuntimeException)
{
    return getProxyEntry( FTP ).Server;
}

//-------------------------------------------------
//
//-------------------------------------------------

OUString SAL_CALL CSysProxySettings::getFtpProxyPort(  ) throw (RuntimeException)
{  
    return getProxyEntry( FTP ).Port;
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSysProxySettings::getGopherProxyAddress(  ) throw (RuntimeException)
{
    return getProxyEntry( GOPHER ).Server;
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSysProxySettings::getGopherProxyPort(  ) throw (RuntimeException)
{
    return getProxyEntry( GOPHER ).Port;
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSysProxySettings::getHttpProxyAddress(  ) throw (RuntimeException)
{
    return getProxyEntry( HTTP ).Server;
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSysProxySettings::getHttpProxyPort(  ) throw (RuntimeException)
{
    return getProxyEntry( HTTP ).Port;
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSysProxySettings::getHttpsProxyAddress(  ) throw (RuntimeException)
{
    return getProxyEntry( HTTPS ).Server;
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSysProxySettings::getHttpsProxyPort(  ) throw (RuntimeException)
{
    return getProxyEntry( HTTPS ).Port;
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSysProxySettings::getSocksProxyAddress(  ) throw (RuntimeException)
{
    return getProxyEntry( SOCKS ).Server;
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSysProxySettings::getSocksProxyPort(  ) throw (RuntimeException)
{
    return getProxyEntry( SOCKS ).Port;
}

//-------------------------------------------------
//
//-------------------------------------------------

sal_Bool SAL_CALL CSysProxySettings::isProxyEnabled( ) throw (RuntimeException)
{
    return queryProxySettings( ).bProxyEnabled;
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSysProxySettings::getProxyBypassAddress(  ) throw (RuntimeException)
{
    OUString aProxyBypassList = queryProxySettings( ).ProxyBypassList;

    if ( aProxyBypassList.getLength( ) > 0 )        
        aProxyBypassList = aProxyBypassList.replace( SPACE, SEMI_COLON );

    return aProxyBypassList;
}

//-------------------------------------------------
// this implementation follows the algorithm
// of the internet explorer
// if there are type-dependent proxy settings
// and type independent proxy settings in the
// registry the internet explorer chooses the
// type independent proxy for all settings
// e.g. imagine the following registry entry
// ftp=server:port;http=server:port;server:port
// the last token server:port is type independent
// so the ie chooses this proxy server
    
// if there is no port specified for a type independent 
// server the ie uses the port of an http server if 
// there is one and it has a port
//-------------------------------------------------

CSysProxySettings::ProxyEntry CSysProxySettings::getProxyEntry( const OUString& aProxyType ) const
{
    OUString aProxyList = queryProxySettings( ).ProxyList;
    if ( !aProxyList.getLength( ) )
        return ProxyEntry( );

    // we do enumerate all entries and save the entries
    // in a map
    std::map< OUString, ProxyEntry > aTypeDependProxyMap;          
    sal_Int32  nIndex = 0;
    ProxyEntry aTypeIndepProxy;
    ProxyEntry aProxy;

    do
    {
        aProxy = getNextProxy( aProxyList, nIndex );
        if ( isTypeIndepProxy( aProxy ) )
        {
            aTypeIndepProxy = aProxy;
            continue;
        }

        aTypeDependProxyMap.insert( 
            std::make_pair( aProxy.Type, aProxy ) );
    }
    while ( nIndex >= 0 );
    
    std::map< OUString, ProxyEntry >::const_iterator iter;

    aProxy = ProxyEntry( );
    if ( aTypeIndepProxy.Server.getLength( ) )
    {
        if ( 0 == aTypeIndepProxy.Port.getLength( ) )
        {
            iter = aTypeDependProxyMap.find( HTTP );
            if ( iter != aTypeDependProxyMap.end( ) )
                aTypeIndepProxy.Port = iter->second.Port;
        }

        aProxy = aTypeIndepProxy;
    }
    else
    {
        iter = aTypeDependProxyMap.find( aProxyType );
        if ( iter != aTypeDependProxyMap.end( ) )
            aProxy = iter->second;
    }

    return aProxy;
}

//-------------------------------------------------
//
//-------------------------------------------------

CSysProxySettings::ProxySettings CSysProxySettings::queryProxySettings( ) const
{    
    ProxySettings aProxySettings;

    if ( m_lpfnInternetQueryOption )
    {
        LPINTERNET_PROXY_INFO lpi = NULL;

        // query for the neccessary space
        DWORD dwLength = 0;
        BOOL bRet = m_lpfnInternetQueryOption(
            NULL,
            INTERNET_OPTION_PROXY,
            (LPVOID)lpi,
            &dwLength );
        
        // allocate sufficient space on the heap
        // insufficient space on the heap results
        // in a stack overflow exception, we assume
        // this never happens, because of the relatively
        // small amount of memory we need
        // _alloca is nice because it is fast and we don't
        // have to free the allocated memory, it will be
        // automatically done
        lpi = reinterpret_cast< LPINTERNET_PROXY_INFO >(
            _alloca( dwLength ) );
        
        bRet = m_lpfnInternetQueryOption( 
            NULL,
            INTERNET_OPTION_PROXY,
            (LPVOID)lpi,
            &dwLength );

        // if a proxy is disabled, InternetQueryOption returns
        // an empty proxy list, so we don't have to check if
        // proxy is enabled or not
        if ( bRet )
        {
            aProxySettings.ProxyList       = OUString::createFromAscii( lpi->lpszProxy );
            aProxySettings.ProxyBypassList = OUString::createFromAscii( lpi->lpszProxyBypass );
            aProxySettings.bProxyEnabled   = (lpi->dwAccessType & INTERNET_OPEN_TYPE_PROXY);
        }
    }

    return aProxySettings;
}

// -------------------------------------------------
// XServiceInfo
// -------------------------------------------------

OUString SAL_CALL CSysProxySettings::getImplementationName(  ) 
	throw( RuntimeException )
{
	return OUString::createFromAscii( COMP_IMPL_NAME );
}

// -------------------------------------------------
//	XServiceInfo
// -------------------------------------------------

sal_Bool SAL_CALL CSysProxySettings::supportsService( const OUString& ServiceName ) 
	throw( RuntimeException )
{
	Sequence < OUString > SupportedServicesNames = Component_getSupportedServiceNames();

	for ( sal_Int32 n = SupportedServicesNames.getLength(); n--; )
		if (SupportedServicesNames[n].compareTo(ServiceName) == 0)
			return sal_True;

	return sal_False;
}

// -------------------------------------------------
//	XServiceInfo
// -------------------------------------------------

Sequence< OUString > SAL_CALL CSysProxySettings::getSupportedServiceNames(	 ) 
	throw( RuntimeException )
{
	return Component_getSupportedServiceNames();
}

