/*************************************************************************
 *
 *  $RCSfile: printdlg.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 14:36:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_PRINTDLG_HXX_
#define _SV_PRINTDLG_HXX_

#ifndef _VCL_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif
#ifndef _VCL_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _VCL_BUTTON_HXX
#include <vcl/button.hxx>
#endif
#ifndef _VCL_GROUP_HXX
#include <vcl/group.hxx>
#endif
#ifndef _VCL_FIELD_HXX
#include <vcl/field.hxx>
#endif
#ifndef _VCL_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _VCL_LSTBOX_HXX
#include <vcl/lstbox.hxx>
#endif
#ifndef _STDCTRL_HXX
#include <stdctrl.hxx>
#endif

class Printer;
class QueueInfo;
struct SvtPrinterImpl;

// ---------------------
// - PrintDialog-Types -
// ---------------------

enum PrintDialogRange { PRINTDIALOG_ALL, PRINTDIALOG_SELECTION,
						PRINTDIALOG_FROMTO, PRINTDIALOG_RANGE };

// ---------------
// - PrintDialog -
// ---------------

class PrintDialog : public ModalDialog
{
private:
	FixedLine			maFlPrinter;
	FixedText			maFtName;
	ListBox 			maLbName;
	PushButton			maBtnProperties;
	FixedText			maFtStatus;
	FixedInfo			maFiStatus;
	FixedText			maFtType;
	FixedInfo			maFiType;
	FixedText			maFtLocation;
	FixedInfo			maFiLocation;
	FixedText			maFtComment;
	FixedInfo			maFiComment;
	CheckBox			maCbxFilePrint;
	FixedInfo			maFiPrintFile;
	FixedText			maFiFaxNo;
	Edit				maEdtFaxNo;
	PushButton			maBtnBrowse_nomore;
	FixedLine			maFlPrintRange;
	RadioButton 		maRbtAll;
	RadioButton 		maRbtPages;
	RadioButton 		maRbtSelection;
	Edit				maEdtPages;
	FixedLine			maFlCopies;
	FixedText			maFtCopies;
	NumericField		maNumCopies;
	FixedImage			maImgCollate;
	FixedImage			maImgNotCollate;
	CheckBox			maCbxCollate;
	PushButton			maBtnOptions;
	OKButton			maBtnOK;
	CancelButton		maBtnCancel;
	HelpButton			maBtnHelp;
	AutoTimer			maStatusTimer;
    FixedLine			maFlSepCopiesRange;
    FixedLine			maFlSepButtonLine;

	Printer*			mpPrinter;
	SvtPrinterImpl*		mpPrinterImpl;

	XubString			maRangeText;
	USHORT				mnCopyCount;
	USHORT				mnFirstPage;
	USHORT				mnLastPage;
	USHORT				mnMinPage;
	USHORT				mnMaxPage;
	PrintDialogRange	meCheckRange;
	BOOL				mbAll;
	BOOL				mbSelection;
	BOOL				mbFromTo;
	BOOL				mbRange;
	BOOL				mbCollate;
	BOOL				mbCollateCheck;
	BOOL				mbOptions;
	Link				maOptionsHdlLink; // Link zum Options-Handler
	Link				maOKHdlLink;	  // Link zum OK-Handler

    String				maAllFilterStr;

	void				ImplCheckOK();
	void				ImplInitControls();
	void				ImplFillDialogData();
	void				ImplSetInfo();
    void                ImplSetImages();
    bool				ImplGetFilename();

						DECL_LINK( ImplPropertiesHdl, void* );
						DECL_LINK( ImplChangePrinterHdl, void* );
						DECL_LINK( ImplModifyControlHdl, void* );
						DECL_LINK( ImplStatusHdl, Timer* );

public:
						PrintDialog( Window* pWindow );
						~PrintDialog();

	virtual long		OK();
	virtual long		ClickOptionsHdl();

	void				SetPrinter( Printer* pNewPrinter ) { mpPrinter = pNewPrinter; }
	Printer*			GetPrinter() const { return mpPrinter; }

	void				EnableRange( PrintDialogRange eRange );
	void				DisableRange( PrintDialogRange eRange );
	BOOL				IsRangeEnabled( PrintDialogRange eRange ) const;

	void				CheckRange( PrintDialogRange eRange = PRINTDIALOG_ALL )
							{ meCheckRange = eRange; }
	PrintDialogRange	GetCheckedRange() const { return meCheckRange; }
	BOOL				IsRangeChecked( PrintDialogRange eRange ) const;

	void				SetRangeText( const XubString& rRange ) { maRangeText = rRange; }
	const XubString& 	GetRangeText() const { return maRangeText; }

	void				SetFirstPage( USHORT nPage = 0 );
	USHORT				GetFirstPage() const { return mnFirstPage; }
	void				SetLastPage( USHORT nPage = 0 );
	USHORT				GetLastPage() const { return mnLastPage; }

	void				SetMinPage( USHORT nPage = 1 ) { mnMinPage = nPage; }
	USHORT				GetMinPage() const { return mnMinPage; }
	void				SetMaxPage( USHORT nPage = 65535 ) { mnMaxPage = nPage; }
	USHORT				GetMaxPage() const { return mnMaxPage; }

	void				SetCopyCount( USHORT nCopies = 1 ) { mnCopyCount = nCopies; }
	USHORT				GetCopyCount() const { return mnCopyCount; }

	void				EnableCollate( BOOL bEnable = TRUE )
							{ mbCollate = bEnable; }
	BOOL				IsCollateEnabled() const { return mbCollate; }
	void				CheckCollate( BOOL bCheck = TRUE )
							{ mbCollateCheck = bCheck; }
	BOOL				IsCollateChecked() const { return mbCollateCheck; }

	void				ShowOptionsButton( BOOL bShow = TRUE )
							{ mbOptions = bShow; }
	BOOL				IsOptionsButtonVisible() const { return mbOptions; }

	void				SetOptionsHdl( const Link& rLink ) { maOptionsHdlLink = rLink; }
	const Link& 		GetOptionsHdl() const { return maOptionsHdlLink; }

	void				SetOKHdl( const Link& rLink ) { maOKHdlLink = rLink; }
	const Link& 		GetOKHdl() const { return maOKHdlLink; }

	virtual void		DataChanged( const DataChangedEvent& rDCEvt );
	virtual long		Notify( NotifyEvent& rNEvt );

	virtual short		Execute();

	void				DisableHelp();
};


inline void PrintDialog::EnableRange( PrintDialogRange eRange )
{
	if ( eRange == PRINTDIALOG_ALL )
		mbAll = TRUE;
	else if ( eRange == PRINTDIALOG_SELECTION )
		mbSelection = TRUE;
	else if ( eRange == PRINTDIALOG_FROMTO )
		mbFromTo = TRUE;
	else
		mbRange = TRUE;
}

inline void PrintDialog::DisableRange( PrintDialogRange eRange )
{
	if ( eRange == PRINTDIALOG_ALL )
		mbAll = FALSE;
	else if ( eRange == PRINTDIALOG_SELECTION )
		mbSelection = FALSE;
	else if ( eRange == PRINTDIALOG_FROMTO )
		mbFromTo = FALSE;
	else
		mbRange = FALSE;
}

inline BOOL PrintDialog::IsRangeEnabled( PrintDialogRange eRange ) const
{
	BOOL bRet;

	if ( eRange == PRINTDIALOG_ALL )
		bRet = mbAll;
	else if ( eRange == PRINTDIALOG_SELECTION )
		bRet = mbSelection;
	else if ( eRange == PRINTDIALOG_FROMTO )
		bRet = mbFromTo;
	else
		bRet = mbRange;

	return bRet;
}

inline BOOL PrintDialog::IsRangeChecked( PrintDialogRange eRange ) const
{
	if ( eRange == meCheckRange )
		return TRUE;
	else
		return FALSE;
}

inline void PrintDialog::SetFirstPage( USHORT nPage )
{
	mnFirstPage = nPage;
	if ( nPage && (nPage < mnMinPage) )
		mnMinPage = nPage;
}

inline void PrintDialog::SetLastPage( USHORT nPage )
{
	mnLastPage = nPage;
	if ( nPage && (nPage > mnMaxPage) )
		mnMaxPage = nPage;
}

#endif // _SV_PRINTDLG_HXX_
