/*************************************************************************
 *
 *  $RCSfile: extattr.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "mac_start.h"

#ifndef __FILES__
  #include <Files.h>
#endif

#ifndef __FINDER__
  #include <Finder.h>
#endif

#include "mac_end.h"

#define private public

#include <tools/fsys.hxx>
#include <tools/stream.hxx>

#undef private

#ifndef _EXTATTR_HXX
#include <ExtAttr.hxx>
#endif

#ifndef _SYSDEP_HXX
#include <vcl/SysDep.hxx>
#endif

/**********************************************************************/

class ImpEaMgr
{
  public:
	FSSpec	aFileSpec;
	BOOL	bValid;
};

/**********************************************************************/

SvEaMgr::SvEaMgr(const DirEntry& rEntry)
{
	pImp = new ImpEaMgr();
	String  aFullString = rEntry.GetFull();
	pImp -> bValid =
		(FSMakeFSSpec(0,0,aFullString.GetPascalStr(),&pImp ->aFileSpec) == noErr);
}

/**********************************************************************/

SvEaMgr::SvEaMgr(const String& rFilename)
{
	pImp = new ImpEaMgr();
	pImp -> bValid =
		(FSMakeFSSpec(0,0,rFilename.GetPascalStr(),&pImp ->aFileSpec) == noErr);
}

/**********************************************************************/

SvEaMgr::SvEaMgr(SvFileStream& rStream)
{
	FCBPBRec	aFileControl;
	OSErr		nErr;

	pImp = new ImpEaMgr();

	aFileControl.ioCompletion 	= NULL;
	aFileControl.ioFCBIndx    	= NULL;
	aFileControl.ioNamePtr 		= pImp->aFileSpec.name;
	aFileControl.ioRefNum 		=  rStream.GetFileHandle();

	nErr = PBGetFCBInfoSync( &aFileControl);
	if (nErr == noErr)
	{
		pImp->aFileSpec.parID	= aFileControl.ioFCBParID;
		pImp->aFileSpec.vRefNum	= aFileControl.ioFCBVRefNum;
		pImp->bValid = TRUE;
	}
	else
		pImp->bValid = FALSE;
}

/**********************************************************************/

SvEaMgr::~SvEaMgr()
{
	delete pImp;
}

/**********************************************************************/

BOOL SvEaMgr::GetIcon(Icon&) const
{
	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::SetIcon(const ResId&)
{
	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::SetIcon(const String& rIconFileName)
{
	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::GetLongName(String&) const
{
	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::SetLongName(const String&)
{
	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::GetVersionInfo( String& ) const
{
	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::SetVersionInfo( const String& )
{
	return FALSE;
}

/*************************************************************************
|*
|*    SvEaMgr::GetFileType()
|*
|*    Beschreibung
|*    Ersterstellung    KH ??.??.95
|*    Letzte Aenderung  DV 11.12.96
|*
*************************************************************************/
BOOL SvEaMgr::GetFileType(String& rType) const
{
	if (!pImp -> bValid)
		return FALSE;

	FInfo	aInfo;
	OSType aFileType;

	if ( noErr == FSpGetFInfo( &pImp->aFileSpec, &aInfo ) )
	{	aFileType = aInfo.fdType;
		if ( ( /* aInfo.fdCreator == 'mdos' && */ aInfo.fdType == 'TEXT' ) ||
			 ( aInfo.fdCreator == '????' && aInfo.fdType == '????' ) )
		{	aFileType = '0000';
		}
		rType = String( (const char*)&aFileType, 4 );
		if (aInfo.fdFlags & kIsStationery)
			rType += FILE_IS_STATIONARY;
		else
			rType += FILE_IS_NOT_STATIONARY;
		return TRUE;
	}
	// else
	rType.Erase();
	return FALSE;
}

/*************************************************************************
|*
|*    SvEaMgr::SetFileType()
|*
|*    Beschreibung
|*    Ersterstellung    KH ??.??.95
|*    Letzte Aenderung  DV 01.02.96
|*
*************************************************************************/
BOOL SvEaMgr::SetFileType(const String& rType)
{
	if (!pImp -> bValid)
		return FALSE;

	FInfo	aInfo;

	if ( noErr == FSpGetFInfo( &pImp->aFileSpec, &aInfo ))
	{
		aInfo.fdType = *((long*)(const char *)rType);

		// Stationary Bit wird auch gleich gesetzt
		if ( ( 4 < rType.Len() ) && ( rType[4] == FILE_IS_STATIONARY ) )
			aInfo.fdFlags |= kIsStationery;
		else
			aInfo.fdFlags &= ~kIsStationery;

		if ( noErr == FSpSetFInfo( &pImp->aFileSpec, &aInfo ) )
			return TRUE;
	}
	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::GetComment(String& rComment) const
{
	if (!pImp -> bValid)
		return FALSE;

	DTPBRec aParamBlock;
	char	Buffer[200];

	aParamBlock.ioCompletion = NULL;

	aParamBlock.ioNamePtr = NULL;
	aParamBlock.ioVRefNum = pImp->aFileSpec.vRefNum;
	if ( noErr != PBDTGetPath( &aParamBlock ))
		return FALSE;

	aParamBlock.ioNamePtr 	= pImp->aFileSpec.name;
	// aParamBlock.ioDTRefNum 	= aParamBlock.ioDTRefNum;
	aParamBlock.ioDTBuffer	= Buffer;
	aParamBlock.ioDirID	    = pImp->aFileSpec.parID;

	if ( noErr == PBDTGetCommentSync(&aParamBlock) )
	{
		rComment = String(Buffer,(int) aParamBlock.ioDTActCount);
		return TRUE;
	}

	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::SetComment(const String& rComment)
{
	if (!pImp -> bValid)
		return FALSE;

	DTPBRec aParamBlock;

	aParamBlock.ioCompletion = NULL;

	aParamBlock.ioNamePtr = NULL;
	aParamBlock.ioVRefNum = pImp->aFileSpec.vRefNum;
	if ( noErr != PBDTGetPath( &aParamBlock ))
		return FALSE;

	aParamBlock.ioNamePtr 		= pImp->aFileSpec.name;
	// aParamBlock.ioDTRefNum 	= aParamBlock.ioDTRefNum;
	aParamBlock.ioDTBuffer		= (char*) rComment.GetStr();
	aParamBlock.ioDTReqCount 	= rComment.Len();
	aParamBlock.ioDirID	    	= pImp->aFileSpec.parID;

	if ( noErr == PBDTSetCommentSync(&aParamBlock) )
		return TRUE;

	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::GetCreator(String& rCreator) const
{
	if (!pImp -> bValid)
		return FALSE;

	FInfo	aInfo;

	if ( noErr == FSpGetFInfo( &pImp->aFileSpec, &aInfo ) )
	{
		rCreator = String( (const char*)&aInfo.fdCreator, 4 );
		return TRUE;
	}
	// else
	rCreator.Erase();
	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::SetCreator(const String& rCreator)
{
	if (!pImp -> bValid)
		return FALSE;

	FInfo	aInfo;

	if ( noErr == FSpGetFInfo( &pImp->aFileSpec, &aInfo ))
	{
		aInfo.fdCreator = *((long*)(const char *)rCreator);
		if ( noErr == FSpSetFInfo( &pImp->aFileSpec, &aInfo ) )
			return TRUE;
	}
	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::Clone( const SvEaMgr& rCloneFrom )
{
	if (!rCloneFrom.pImp -> bValid || !pImp -> bValid)
		return FALSE;

	FInfo	aInfo;

	if ( noErr == FSpGetFInfo( &rCloneFrom.pImp->aFileSpec, &aInfo ) )
	{
		if ( noErr != FSpSetFInfo( &pImp->aFileSpec, &aInfo ) )
			return FALSE;
	}

	String aComment;

	if (rCloneFrom.GetComment(aComment))
	{
		if (aComment.Len())
			this -> SetComment(aComment);
		return TRUE;
	}
	return FALSE;
}

/**********************************************************************/

BOOL SvEaMgr::GetAppCreator(String& rAppCreator)
{
	ProcessSerialNumber		process;
	ProcessInfoRec			procInfo;

	process.highLongOfPSN		= 0;
	process.lowLongOfPSN  		= kCurrentProcess;
	procInfo.processInfoLength	= sizeof(ProcessInfoRec);
	procInfo.processName		= nil;
	procInfo.processAppSpec		= nil;

	if ( noErr == GetProcessInformation( &process, &procInfo ) )
	{
		rAppCreator = String( (char*) &(procInfo.processSignature), 4 );
	}
	return TRUE;
}
