/*************************************************************************
 *
 *  $RCSfile: wizardheader.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 14:37:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef SVTOOLS_WIZARDHEADER_HXX
#include "wizardheader.hxx"
#endif

#ifndef _SV_BITMAP_HXX 
#include <vcl/bitmap.hxx>
#endif
#ifndef _TOOLS_COLOR_HXX 
#include <tools/color.hxx>
#endif

//.........................................................................
namespace svt
{
//.........................................................................

	//=====================================================================
	//= FontChanger
	//=====================================================================
	class FontChanger
	{
	protected:
		OutputDevice*	m_pDev;

	public:
		FontChanger( OutputDevice* _pDev, const Font& _rNewFont )
			:m_pDev( _pDev )
		{
			m_pDev->Push( PUSH_FONT );
			m_pDev->SetFont( _rNewFont );
		}

		~FontChanger()
		{
			m_pDev->Pop( );
		}
	};

	//=====================================================================
	//= ColorChanger
	//=====================================================================
	class ColorChanger
	{
	protected:
		OutputDevice*	m_pDev;

	public:
		ColorChanger( OutputDevice* _pDev, const Color& _rNewLineColor, const Color& _rNewFillColor )
			:m_pDev( _pDev )
		{
			m_pDev->Push( PUSH_LINECOLOR | PUSH_FILLCOLOR );
			m_pDev->SetLineColor( _rNewLineColor );
			m_pDev->SetFillColor( _rNewFillColor );
		}

		~ColorChanger()
		{
			m_pDev->Pop();
		}
	};

	//=====================================================================
	//= WizardHeaderImpl
	//=====================================================================
	class WizardHeaderImpl
	{
	protected:
		Bitmap		m_aPicture;
		String		m_aText;

		Font		m_aFont;

	public:
		WizardHeaderImpl();

		void			setPicture( const Bitmap& _rPic ) { m_aPicture = _rPic; }
		const Bitmap&	getPicture( ) const { return m_aPicture; }

		void			setText( const String& _rText ) { m_aText = _rText; }
		const String&	getText( ) const { return m_aText; }

		void			setFont( const Font& _rFont ) { m_aFont = _rFont; }
		const Font&		getFont() const { return m_aFont; }
	};

	//---------------------------------------------------------------------
	WizardHeaderImpl::WizardHeaderImpl()
	{
	}

	//=====================================================================
	//= WizardHeader
	//=====================================================================
	//---------------------------------------------------------------------
	WizardHeader::WizardHeader( Window* _pParent, const ResId& _rId )
		:Control( _pParent, _rId )
		,m_pImpl( NULL )
	{
		implInit();
	}

	//---------------------------------------------------------------------
	WizardHeader::WizardHeader( Window* _pParent, WinBits _nWinStyle )
		:Control( _pParent, _nWinStyle )
		,m_pImpl( NULL )
	{
		implInit();
	}

	//---------------------------------------------------------------------
	void WizardHeader::implInit()
	{
		m_pImpl = new WizardHeaderImpl;

		// the font we want to use
		Font aFont = GetFont( );
		aFont.SetWeight( WEIGHT_BOLD );
		m_pImpl->setFont( aFont );
			// TODO: if somebody sets a new font from outside (OutputDevice::SetFont), we would have to react
			// on this with calculating a new bold font.
			// Unfortunately, the OutputDevice does not offer a notify mechanism for a changed font.
			// So settings the font from outside is simply a forbidded scenario at the moment
	}

	//---------------------------------------------------------------------
	WizardHeader::~WizardHeader( )
	{
		delete m_pImpl;
	}

	//---------------------------------------------------------------------
	void WizardHeader::setHeaderBitmap( const Bitmap& _rBmp, sal_Bool _bInvalidate )
	{
		m_pImpl->setPicture( _rBmp );

		if ( _bInvalidate )
			Invalidate( );
	}

	//---------------------------------------------------------------------
	const Bitmap& WizardHeader::getHeaderBitmap( ) const
	{
		return m_pImpl->getPicture( );
	}

	//---------------------------------------------------------------------
	void WizardHeader::setHeaderText( const String& _rText, sal_Bool _bInvalidate )
	{
		m_pImpl->setText( _rText );

		if ( _bInvalidate )
			Invalidate( );
	}

	//---------------------------------------------------------------------
	const String& WizardHeader::getHeaderText( ) const
	{
		return m_pImpl->getText( );
	}

	//---------------------------------------------------------------------
	void WizardHeader::Paint( const Rectangle& _rRect )
	{
		Control::Paint( _rRect );

		//.................................................................
		// draw the background
		{
			ColorChanger aColors( this, COL_TRANSPARENT, COL_WHITE );
			DrawRect( _rRect );
		}

		// the x pos for drawing our elements: starting at col 7 (counted in APPFONT units)
		sal_Int32 nElementXPos = LogicToPixel( Point( 7, 0 ), MAP_APPFONT ).X();

		//.................................................................
		// draw the bitmap
		if ( !!m_pImpl->getPicture() )
		{
			Size aBitmapSize = m_pImpl->getPicture().GetSizePixel();
			Size aMySize = GetOutputSizePixel();

			// center the bitmap vertically
			Point aBitmapPos( nElementXPos, ( aMySize.Height() - aBitmapSize.Height() ) / 2 );

			// draw it
			DrawBitmap( aBitmapPos, m_pImpl->getPicture() );

			// the next element (the text) will start 3 APPFONT units next to the bitmap
			nElementXPos += aBitmapSize.Width();
			nElementXPos += LogicToPixel( Point( 3, 0 ), MAP_APPFONT ).X();
		}

		//.................................................................
		// draw the text
		{
			FontChanger aFont( this, m_pImpl->getFont() );

			Point aDistance = LogicToPixel( Point( 4, 4 ), MAP_APPFONT );
			// the posisiton of the text: the current x-pos, and 4 APPFONT units from the top
			Point aTextPos( nElementXPos, aDistance.Y() );

			// the size of the rectangle of the text
			Size aOutputSize( GetOutputSizePixel() );
			Size aTextSize( aOutputSize.Width() - nElementXPos - aDistance.X(), aOutputSize.Height() - aDistance.Y() - aDistance.Y() );

			// draw it
			DrawText( Rectangle( aTextPos, aTextSize ), m_pImpl->getText( ), TEXT_DRAW_LEFT | TEXT_DRAW_TOP | TEXT_DRAW_MULTILINE | TEXT_DRAW_WORDBREAK );
		}

	}

//.........................................................................
}	// namespace svt
//.........................................................................

