/*************************************************************************
 *
 *  $RCSfile: pver.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:59:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifdef MAC
#ifdef BUILD
#undef BUILD
#endif
#endif

#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#pragma hdrstop

#ifndef _TOOLS_RESMGR_HXX //autogen
#include <tools/resmgr.hxx>
#endif

#include "svtdata.hxx"
#include "pver.hxx"

#include "svtools.hrc"

/******************************************************************************
 *
 *	sensetive
 * 		TAG == dNiK
 *
 *	first byte (edition):
 *		o == Internal
 * 		1 == PersonalDeLuxe
 * 		2 == Personal
 * 		3 == Professional
 * 		4 == Business
 * 		5 == Enterprice
 * 		6 == Education
 * 		7 == Demo
 * 		8 == Beta
 * 		9 == OEM
 * 		a == Campus
 * 		b == Pilot
 *		c == Evaluation
 *		d == Partner
 *		e == SmallBusiness
 *		f == OEMProfessional
 *
 *	second byte (license):
 *		k == LicenseInternal
 *		1 == LicenseStar
 *		2 == LicensePUFF
 *		3 == LicenseSmallBusiness
 *		4 == LicenseBeta
 *		5 == LicenseOEM1
 *		6 == LicenseOEM2
 *		7 == LicenseOEM3
 *		8 == LicenseCampus
 *		9 == LicenseEnterprice
 *		a == LicenseNoReg
 *		b == LicensePilot
 *
 *****************************************************************************/

#if SUPD >= 507
const char strLicenseType[] = "dNiKok";
#else
const char strLicenseType[] = "dNiK11";
#endif

#if SUPD >= 505 && SUPD < 514
#define 						__VERSION			50
#define 						__REVISION			0
#define 						__PRODUCTID         StarOffice50
#elif SUPD >= 514 && SUPD < 561
#define 						__VERSION			51
#define 						__REVISION			0
#define 						__PRODUCTID         StarOffice50
#elif SUPD >= 561 && SUPD < 582
#define 						__VERSION			52
#define 						__REVISION			0
#define 						__PRODUCTID         StarOffice50
#elif SUPD >= 582
#define 						__VERSION			53
#define 						__REVISION			0
#define 						__PRODUCTID         StarOffice50
#else
#error was isses denn fuer ne Version ???
#endif

void ProductVersion::PrepareStr( String& rStr, USHORT nLen )
{
	USHORT nStrLen = rStr.Len();
	if( nStrLen < nLen )
		for( USHORT i = 0; i < nLen - nStrLen; ++i )
			rStr.Insert( UniString::CreateFromAscii("0"), 0 );
}

String ProductVersion::GetVersion()
{
	String aReturn( UniString::CreateFromInt32( __VERSION ) );
	return aReturn;
}

String ProductVersion::GetRevision()
{
	String aReturn( UniString::CreateFromInt32( __REVISION ) );
	return aReturn;
}

String ProductVersion::GetMajorVersion()
{
	String aReturn( UniString::CreateFromAscii( UPD ) );
	return aReturn;
}

String ProductVersion::GetMinorVersion()
{
	String aReturn( UniString::CreateFromAscii( MINOR ) );
	return aReturn;
}

String ProductVersion::GetBuildNumber()
{
	String aReturn( UniString::CreateFromAscii( BUILD_ID ) );
	return aReturn;
}

String ProductVersion::GetSystemID()
{
	String aReturn( SYSTEM_ID );
	PrepareStr( aReturn );
	return aReturn;
}

String ProductVersion::GetLanguage()
{
	String aReturn( SvtResId(STR_PVER_LANGUAGECODE) );
	PrepareStr( aReturn );
	return aReturn;
}

String ProductVersion::GetLongLanguage()
{
	String aReturn( SvtResId(STR_PVER_LONG_LANGUAGECODE) );
	PrepareStr( aReturn, 4 );
	return aReturn;
}

