/*************************************************************************
 *
 *  $RCSfile: eaimp.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:59:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <sys/types.h>
#include <sys/stat.h>
#include <utime.h>
#include <unistd.h>

#include <extattr.hxx>
#include <tools/string.hxx>
#include <tools/fsys.hxx>
#include <tools/stream.hxx>

class ImpEaMgr
{
	String			m_aFilename;
public:
	ImpEaMgr( const String& rFilename ) : m_aFilename( rFilename ) {}
	ImpEaMgr( const ImpEaMgr& rFrom ) : m_aFilename( rFrom.m_aFilename ) {}

	BOOL Clone( const ImpEaMgr& rClone );
};

BOOL ImpEaMgr::Clone( const ImpEaMgr& rClone )
{
	struct stat aFrom;

	rtl_TextEncoding aEncoding = gsl_getSystemTextEncoding();

	ByteString aFilename( m_aFilename, aEncoding );
	ByteString aCloneFilename( rClone.m_aFilename, aEncoding );

	if( stat( aFilename.GetBuffer(), & aFrom ) )
		return FALSE;

	if( chmod( aCloneFilename.GetBuffer(), aFrom.st_mode & ( ~S_IFMT ) ) )
		return FALSE;

	// try to change group id
	// do not consider failure to do so severe
	chown( aCloneFilename.GetBuffer(), -1, aFrom.st_gid );

	return TRUE;
}

SvEaMgr::SvEaMgr( const DirEntry& rEntry ) :
		pImp( new ImpEaMgr( rEntry.GetFull() ) )
{
}

SvEaMgr::SvEaMgr( const String& rFilename ) :
		pImp( new ImpEaMgr( rFilename ) )
{
}

SvEaMgr::SvEaMgr( SvFileStream& rStream ) :
		pImp( new ImpEaMgr( rStream.GetFileName() ) )
{
}

SvEaMgr::~SvEaMgr()
{
	delete pImp;
}


BOOL SvEaMgr::Clone( const SvEaMgr& rFrom )
{
	return pImp->Clone( *rFrom.pImp );
}


// Dummies

BOOL SvEaMgr::GetIcon( Icon& ) const { return FALSE; }
BOOL SvEaMgr::SetIcon( const ResId& ) { return FALSE; }
BOOL SvEaMgr::SetIcon( const String&  ) { return FALSE; }
BOOL SvEaMgr::GetLongName( String& ) const { return FALSE; }
BOOL SvEaMgr::SetLongName( const String& ) { return FALSE; }
BOOL SvEaMgr::GetFileType( String& ) const { return FALSE; }
BOOL SvEaMgr::SetFileType( const String& ) { return FALSE; }
BOOL SvEaMgr::GetComment( String& ) const { return FALSE; }
BOOL SvEaMgr::SetComment( const String& ) { return FALSE; }
BOOL SvEaMgr::GetCreator( String& ) const { return FALSE; }
BOOL SvEaMgr::SetCreator( const String& ) { return FALSE; }
BOOL SvEaMgr::GetVersionInfo( String& ) const { return FALSE; }
BOOL SvEaMgr::SetVersionInfo( const String& ) { return FALSE; }
BOOL SvEaMgr::GetAppCreator( String& ) { return FALSE; }
