/*************************************************************************
 *
 *  $RCSfile: spldlg.cxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: tl $ $Date: 2003/05/06 12:37:02 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#pragma hdrstop

// include ---------------------------------------------------------------
#include <tools/ref.hxx>

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SV_SYSTEM_HXX
#include <vcl/system.hxx>
#endif
#ifndef _SV_MENU_HXX
#include <vcl/menu.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif

#ifndef _LINGUISTIC_LNGPROPS_HHX_
#include <linguistic/lngprops.hxx>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_SPELLFAILURE_HPP_
#include <com/sun/star/linguistic2/SpellFailure.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif

#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif


#define _SVX_SPLDLG_CXX

#include "dialogs.hrc"
#include <helpid.hrc>
#include "spldlg.hrc"

#define ITEMID_SPELLCHECK	SID_ATTR_SPELL

#include "optitems.hxx"
#include "svxenum.hxx"
#include "spldlg.hxx"       // Der Dialog
#include "splwrap.hxx"      // Der Wrapper
#include "thesdlg.hxx"      // ThesaurusDlg
#include "dlgutil.hxx"		// language
#include "optlingu.hxx"
#include "dialmgr.hxx"
#include "svxerr.hxx"

#ifndef SVX_COMMON_LINGUI_HXX
#include "commonlingui.hxx"
#endif

using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::linguistic2;

#define C2U(cChar) 					OUString::createFromAscii(cChar)
// struct SpellCheckDlg_Impl ---------------------------------------------

struct SpellCheckDlg_Impl
{
	Sequence< Reference< XDictionary >  >	aDics;
	SvxSpellWrapper*			pSpellWrapper;
	FASTBOOL					bBtnLock;

	SpellCheckDlg_Impl() :
		pSpellWrapper	(NULL),
		bBtnLock		(sal_False)
	{
	}
};

static Window* pOldDefDialogParent;

// define ----------------------------------------------------------------

#define WRAPPER					pImpl->pSpellWrapper
#define BTN_LOCK				pImpl->bBtnLock
#define BTN_LOCKING( bLock )									\
	if ( bLock )												\
	{															\
		EnterWait();											\
		pOldDefDialogParent=Application::GetDefDialogParent();	\
		Application::SetDefDialogParent(this);					\
	}															\
	else														\
	{															\
		LeaveWait();											\
		Application::SetDefDialogParent(pOldDefDialogParent);	\
	}															\
	BTN_LOCK = bLock


	static void 				SetDefDialogParent( Window* pWindow );
	static Window*				GetDefDialogParent();

// statics ---------------------------------------------------------------

static const short NOACTDICT = -1;

/*
static SfxItemInfo __READONLY_DATA aItemInfos[] =
{
	{ 0, 0 }
};
*/
static sal_uInt16 pSpellInfos[] =
{
	SID_ATTR_SPELL,SID_ATTR_SPELL,
	0
};

// class SvxSpellCheckDialog ---------------------------------------------

SvxSpellCheckDialog::SvxSpellCheckDialog
(
	Window* 			pParent,
	Reference< XSpellChecker1 >  &	xChecker,
	SvxSpellWrapper* 	pWrapper
) :

	SfxModalDialog( pParent, SVX_RES( RID_SVXDLG_SPELLCHECK ) ),

	m_aPlayground( new SvxCommonLinguisticControl( this ) ),

	aStateImage		( m_aPlayground.get(),	ResId( FI_STATE) ),
	aTestBtn		( m_aPlayground.get(),	ResId( IB_TEST ) ),
	aNewWordLB		( m_aPlayground.get(),	ResId( LB_NEWWORD ) ),
	aLanguageText	( m_aPlayground.get(),	ResId( FT_LANGUAGE ) ),
	aLangLB			( m_aPlayground.get(),	ResId( LB_LANGUAGE ) ),

	aAutoCorrBtn	( m_aPlayground.get(),	ResId( BTN_AUTOCORR ) ),
	aThesBtn		( m_aPlayground.get(),	ResId( BTN_THES ) ),
	aOptionsBtn		( m_aPlayground.get(),	ResId( BTN_OPTIONS ) ),
	aBookText		( m_aPlayground.get(),	ResId( FT_BOOK ) ),
	aBookDLB		( m_aPlayground.get(),	ResId( LB_BOOK ) ),
	aAddBtn			( m_aPlayground.get(),	ResId( BTN_ADD ) ),
	aBackWdBox		( m_aPlayground.get(), ResId( CB_BACKWD ) ),

	aErrorStr		( ResId( STR_ERROR) ),
	aFalseStateIm	( ResId( IM_FALSE) ),
	aTrueStateIm	( ResId( IM_OK) ),
	xSpell			( xChecker ),
	nOldLang		( LANGUAGE_NONE ),
	nActDict		( NOACTDICT ),
	aStateStr		( aStateImage.GetQuickHelpText() ),
	bModified		( sal_False )
{
	pImpl = new SpellCheckDlg_Impl;
	//pImpl->xSpellAlt = WRAPPER->GetLast(), UNO_QUERY);
	WRAPPER = pWrapper;
	BTN_LOCK = sal_False;

	aStateImage.SetImage(aFalseStateIm);

	// we have to correct the z-order of our controls (some are part of the SvxCommonLinguisticControl,
	// and some aren't)
	m_aPlayground->InsertControlGroup( aStateImage, aTestBtn, SvxCommonLinguisticControl::eLeftRightWords );
	m_aPlayground->InsertControlGroup( aNewWordLB, aAddBtn, SvxCommonLinguisticControl::eSuggestionLabel );
	m_aPlayground->InsertControlGroup( aAutoCorrBtn, aBackWdBox, SvxCommonLinguisticControl::eActionButtons );
    m_aPlayground->GetButton(SvxCommonLinguisticControl::eClose     )->SetHelpId(HID_SPLDLG_BUTTON_CLOSE    );
    m_aPlayground->GetButton(SvxCommonLinguisticControl::eIgnore    )->SetHelpId(HID_SPLDLG_BUTTON_IGNORE   );
    m_aPlayground->GetButton(SvxCommonLinguisticControl::eIgnoreAll )->SetHelpId(HID_SPLDLG_BUTTON_IGNOREALL);
    m_aPlayground->GetButton(SvxCommonLinguisticControl::eChange    )->SetHelpId(HID_SPLDLG_BUTTON_CHANGE   );
    m_aPlayground->GetButton(SvxCommonLinguisticControl::eChangeAll )->SetHelpId(HID_SPLDLG_BUTTON_CHANGEALL);
    m_aPlayground->GetWordInputControl().SetHelpId(HID_SPLDLG_EDIT_NEWWORD);

	Init_Impl();
	FreeResource();

	// disable controls if service is missing
	if (!xSpell.is())
		Enable( sal_False );
}

// -----------------------------------------------------------------------

SvxSpellCheckDialog::~SvxSpellCheckDialog()
{
    //!! needs to be reseted, otherwise it may crash upon closing
    //!! under Solaris and Linux since a already non-existing control
    //!! will get the foxus
    m_aPlayground->SetResetWordHdl( Link() );
    
    delete pImpl;
}

// -----------------------------------------------------------------------

void SvxSpellCheckDialog::Init_Impl()
{
	// Handler initialisieren
	m_aPlayground->SetButtonHandler( SvxCommonLinguisticControl::eClose,		LINK( this, SvxSpellCheckDialog, CancelHdl ) );
	m_aPlayground->SetButtonHandler( SvxCommonLinguisticControl::eChange,		LINK( this, SvxSpellCheckDialog, ChgHdl ) );
	m_aPlayground->SetButtonHandler( SvxCommonLinguisticControl::eChangeAll,	LINK( this, SvxSpellCheckDialog, ChgAllHdl ) );
	m_aPlayground->SetButtonHandler( SvxCommonLinguisticControl::eIgnore,		LINK( this, SvxSpellCheckDialog, IgnHdl ) );
	m_aPlayground->SetButtonHandler( SvxCommonLinguisticControl::eIgnoreAll,	LINK( this, SvxSpellCheckDialog, IgnAllHdl ) );
	aAddBtn		 .SetClickHdl( LINK( this, SvxSpellCheckDialog, AddHdl ) );

	aAutoCorrBtn.SetClickHdl( LINK( this, SvxSpellCheckDialog, ExtClickHdl ) );
	aThesBtn	.SetClickHdl( LINK( this, SvxSpellCheckDialog, ExtClickHdl ) );
	aOptionsBtn .SetClickHdl( LINK( this, SvxSpellCheckDialog, ExtClickHdl ) );

	aBookDLB.SetSelectHdl( LINK( this, SvxSpellCheckDialog, SelectHdl ) );
	aLangLB		 .SetSelectHdl( LINK( this, SvxSpellCheckDialog, SelectHdl ) );

	aNewWordLB.SetGetFocusHdl( LINK( this, SvxSpellCheckDialog, WordSelectHdl ) );
	aNewWordLB.SetSelectHdl( LINK( this, SvxSpellCheckDialog, WordSelectHdl ) );
	aNewWordLB.SetDoubleClickHdl( LINK( this, SvxSpellCheckDialog, ChgHdl ) );

	aBackWdBox.SetClickHdl(LINK ( this, SvxSpellCheckDialog, DirectionHdl ) );
	aTestBtn  .SetClickHdl(LINK ( this, SvxSpellCheckDialog, AuditHdl) );
    aTestBtn.SetModeImage( Image( ResId( IMG_TEST_HC) ), BMP_COLOR_HIGHCONTRAST );
	m_aPlayground->GetWordInputControl().SetModifyHdl(LINK ( this, SvxSpellCheckDialog, ModifyHdl) );
	m_aPlayground->SetResetWordHdl( LINK ( this, SvxSpellCheckDialog, ClickHdl) );

	// "Uberschrift merken
	aTitel = GetText();

	// initialisieren der Sprachen-Listbox
    aLangLB.SetLanguageList( LANG_LIST_SPELL_USED, FALSE, FALSE, TRUE );

	Reference< XSpellAlternatives >  xAlt( WRAPPER->GetLast(), UNO_QUERY );
	if (xAlt.is())
	{
		nOldLang = SvxLocaleToLanguage( xAlt->getLocale() );
		aOldWord = String( xAlt->getWord() );
		WRAPPER->SetOldLang( nOldLang );
	}

	// aktuelle Sprache ermitteln
	UpdateBoxes_Impl();

	// Benutzerbuecher anzeigen
	InitUserDicts();

	Reference< XPropertySet >  xProp( SvxGetLinguPropertySet() );
	sal_Bool bWrapReverse = xProp.is() ?
		*(sal_Bool*)xProp->getPropertyValue( C2U(UPN_IS_WRAP_REVERSE) ).getValue() : sal_False;
	aBackWdBox.Check(0 != bWrapReverse);
}

// -----------------------------------------------------------------------

void SvxSpellCheckDialog::UpdateBoxes_Impl()
{
	sal_Int32 i;
	aNewWordLB.Clear();

	Reference< XSpellAlternatives >  xAlt( WRAPPER->GetLast(), UNO_QUERY );

	LanguageType nAltLanguage = LANGUAGE_NONE;
	String		 aAltWord;
	Sequence< OUString >	aNewWords;
	if (xAlt.is())
	{
		nAltLanguage	= SvxLocaleToLanguage( xAlt->getLocale() );
		aAltWord 		= String( xAlt->getWord() );
		aNewWords 		= xAlt->getAlternatives();
	}


	String aStr( aTitel );
	aStr.Append( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) ) );
	if (xAlt.is())
		aStr.Append( ::GetLanguageString( nAltLanguage ) );
	aStr.Append( sal_Unicode( ')' ) );
	SetText( aStr );

	SetSelectedLang_Impl( nAltLanguage );

	// Das Wort Anzeigen und seine Alternativen
	m_aPlayground->SetCurrentText( aAltWord );

	SetAddBtnHelp(m_aPlayground->GetCurrentText());
	m_aPlayground->UpdateIgnoreHelp( );

	// 1. Alternative in das Edit stellen
	m_aPlayground->GetWordInputControl().SetText( m_aPlayground->GetCurrentText() );
	aAutoCorrBtn.Enable( m_aPlayground->GetWordInputControl().GetText() != m_aPlayground->GetCurrentText() );

	// Alternativen eintragen
	const OUString *pNewWords = aNewWords.getConstArray();
	const sal_Int32 nSize = aNewWords.getLength();
	for ( i = 0; i < nSize; ++i )
	{
		String aTmp( pNewWords[i] );
		if ( LISTBOX_ENTRY_NOTFOUND == aNewWordLB.GetEntryPos( aTmp ) )
			aNewWordLB.InsertEntry( aTmp );
	}
	m_aPlayground->GetWordInputControl().GrabFocus();

	// display status message
	String aTmpText;
	if (xAlt.is())
	{
		int nRID;
		switch (xAlt->getFailureType())
		{
			case SpellFailure::IS_NEGATIVE_WORD : nRID = RID_SVXSTR_HMSTATUS_DONTUSE; break;
			case SpellFailure::CAPTION_ERROR : 	 nRID = RID_SVXSTR_HMSTATUS_CAPERROR; break;
			case SpellFailure::SPELLING_ERROR : 	 nRID = RID_SVXSTR_HMSTATUS_WRONG; break;
			default :
				DBG_ERROR("undefined SpellFailure type");
		}
		aTmpText = SVX_RESSTR( nRID );
	}
	m_aPlayground->SetStatusText( aTmpText );

	if (aNewWordLB.GetEntryCount())
	{
		aNewWordLB.Enable();
		aNewWordLB.SelectEntryPos(0);
		//aNewWordLB.Select();	// Select-Handler rufen
		long nPos= m_aPlayground->GetWordInputControl().GetText().Len();
		Selection aSel(nPos, nPos);
		m_aPlayground->GetWordInputControl().SetSelection(aSel);	// Alles selektieren
		m_aPlayground->UpdateChangesHelp( aNewWordLB.GetSelectEntry() );
	}
	else
	{
		m_aPlayground->UpdateChangesHelp( );
	}
	aStateImage.SetImage(aFalseStateIm);
	UniString aStrTmp( aStateStr );
	aStrTmp.Append(m_aPlayground->GetStatusText());
	aStateImage.SetQuickHelpText( aStrTmp );

}

// -----------------------------------------------------------------------
String SvxSpellCheckDialog::GetNewEditWord()
{
	return m_aPlayground->GetNewEditWord();
}

// -----------------------------------------------------------------------
void SvxSpellCheckDialog::SetNewEditWord( const String& _rNew )
{
	m_aPlayground->SetNewEditWord( _rNew );
}

// -----------------------------------------------------------------------

void SvxSpellCheckDialog::SpellContinue_Impl()
{
	WRAPPER->FindSpellError();
	Reference< XSpellAlternatives >  xAlt( WRAPPER->GetLast(), UNO_QUERY );

	if (xAlt.is())
	{
		UpdateBoxes_Impl();
		nOldLang = GetSelectedLang_Impl();
		aOldWord = m_aPlayground->GetCurrentText();
//		aOldWord = m_aPlayground->GetWordInputControl().GetText();
	}
	else
		EndDialog( RET_OK );
}

// -----------------------------------------------------------------------

IMPL_LINK( SvxSpellCheckDialog, ExtClickHdl, Button *, pBtn )
{
	if (&aOptionsBtn == pBtn)
		StartSpellOptDlg_Impl();
	else if (&aAutoCorrBtn == pBtn)
	{
		String aOldWord( m_aPlayground->GetCurrentText() ),
			   aNewWord( m_aPlayground->GetWordInputControl().GetText() );
		SvxPrepareAutoCorrect( aOldWord, aNewWord );
		WRAPPER->AutoCorrect( aOldWord, aNewWord );
	}
	else if (&aThesBtn == pBtn)
		StartThesaurus_Impl( sal_True );

	return 0;
}
// -----------------------------------------------------------------------

void SvxSpellCheckDialog::StartSpellOptDlg_Impl()
{

	SfxItemSet aSet( SFX_APP()->GetPool(), pSpellInfos);
	aSet.Put(SfxSpellCheckItem( xSpell ),SID_ATTR_SPELL );
	SfxSingleTabDialog* pDlg =
		new SfxSingleTabDialog( this, aSet, RID_SFXPAGE_LINGU );
	SfxTabPage* pPage = SvxLinguTabPage::Create( pDlg, aSet );
	( (SvxLinguTabPage*)pPage )->HideGroups( GROUP_MODULES );
	pDlg->SetTabPage( pPage );
	pDlg->Execute();
	delete pDlg;

	// Benutzerb"ucher anzeigen
	aBookDLB.Clear();
	InitUserDicts();
}

// -----------------------------------------------------------------------

void SvxSpellCheckDialog::StartThesaurus_Impl( sal_Bool bInter )
{
	if ( !bInter )
	{
		QueryBox aBox( this, SVX_RES( RID_SVXQB_THESAURUS ) );

		if ( aBox.Execute() == RET_NO )
			return;
	}
	WRAPPER->StartThesaurus( GetNewEditWord(), GetSelectedLang_Impl() );
}

// -----------------------------------------------------------------------

IMPL_LINK( SvxSpellCheckDialog, ChgHdl, Button *, EMPTYARG )
{
	if ( BTN_LOCK )
		return 0;
	BTN_LOCKING( sal_True );

	String aString=m_aPlayground->GetWordInputControl().GetText();
	if(aNewWordLB.IsEnabled() && aNewWordLB.GetSelectEntryCount()>0)
		aString=aNewWordLB.GetSelectEntry();

	WRAPPER->ChangeWord( aString, GetSelectedLang_Impl() );
	SpellContinue_Impl();
	BTN_LOCKING( sal_False );
	bModified=sal_False;
	return 1;
}


// -----------------------------------------------------------------------

IMPL_LINK( SvxSpellCheckDialog, ChgAllHdl, Button *, EMPTYARG )
{
	if ( BTN_LOCK )
		return 0;
	BTN_LOCKING( sal_True );

	// zuerst das aktuelle Wort "andern

	String aString=m_aPlayground->GetWordInputControl().GetText();
	if(aNewWordLB.IsEnabled() && aNewWordLB.GetSelectEntryCount()>0)
		aString=aNewWordLB.GetSelectEntry();

	LanguageType nLang = GetSelectedLang_Impl();

	// add new word to ChangeAll list
	String  aOldWord( m_aPlayground->GetCurrentText() );
	SvxPrepareAutoCorrect( aOldWord, aString );
    Reference<XDictionary> aXDictionary( SvxGetChangeAllList(), UNO_QUERY );
	SvxAddEntryToDic( aXDictionary,
		::rtl::OUString( aOldWord ), sal_True,
			aString, nLang );

	WRAPPER->ChangeWord( aString, nLang );
	SpellContinue_Impl();
	BTN_LOCKING( sal_False );
	bModified=sal_False;
	return 1;
}


// -----------------------------------------------------------------------

IMPL_LINK( SvxSpellCheckDialog, IgnAllHdl, Button *, EMPTYARG )
{
	if ( BTN_LOCK )
		return 0;
	BTN_LOCKING( sal_True );

	// add word to IgnoreAll list
    Reference< XDictionary > aXDictionary( SvxGetIgnoreAllList(), UNO_QUERY );
    SvxAddEntryToDic( aXDictionary,
		::rtl::OUString( m_aPlayground->GetCurrentText() ), sal_False,
		::rtl::OUString(), LANGUAGE_NONE );

	SpellContinue_Impl();
	BTN_LOCKING( sal_False );
	bModified=sal_False;
	return 1;
}


// -----------------------------------------------------------------------

IMPL_LINK( SvxSpellCheckDialog, IgnHdl, Button *, EMPTYARG )
{
	if ( BTN_LOCK )
		return 0;
	BTN_LOCKING( sal_True );
	// Das Wort wird einfach ignoriert
	SpellContinue_Impl();
	BTN_LOCKING( sal_False );
	bModified=sal_False;
	return 1;
}


// -----------------------------------------------------------------------

IMPL_LINK( SvxSpellCheckDialog, AddHdl, Button *, pButton )
{
	const sal_uInt16 nPos = aBookDLB.GetSelectEntryPos();

	String aNewWord;

	if(bModified)
		aNewWord= m_aPlayground->GetWordInputControl().GetText();
	else
		aNewWord= m_aPlayground->GetCurrentText();

	if ( nPos != LISTBOX_ENTRY_NOTFOUND )
	{
		sal_uInt16 nPos = aBookDLB.GetSelectEntry().nId;

        Reference< XDictionary >  xDic( pImpl->aDics.getConstArray()[ nPos ], UNO_QUERY );
        sal_Int16 nAddRes = DIC_ERR_UNKNOWN;
        if (xDic.is())
        {
            String aTmpTxt( aNewWord );
            sal_Bool bNegEntry = xDic->getDictionaryType() == DictionaryType_NEGATIVE;
            nAddRes = SvxAddEntryToDic( xDic, aTmpTxt, bNegEntry,
                    OUString(), LANGUAGE_NONE );

            // failed because there is already an entry?
            if (DIC_ERR_NONE != nAddRes && xDic->getEntry( aTmpTxt ).is())
                nAddRes = DIC_ERR_NONE;
        }
        if (DIC_ERR_NONE != nAddRes)
        {
            SvxDicError( this, nAddRes );
            return 0;   // Nicht weitermachen
        }
	}
	// nach dem Aufnehmen ggf. '='-Zeichen entfernen
	aNewWord.EraseAllChars( sal_Unicode( '=' ) );
	m_aPlayground->GetWordInputControl().SetText( aNewWord );
	aAutoCorrBtn.Enable( m_aPlayground->GetWordInputControl().GetText() != m_aPlayground->GetCurrentText() );

	// Bei Bedarf Sprache "andern
    WRAPPER->SetLanguage( GetSelectedLang_Impl() );

	// und weiter...
	if ( m_aPlayground->GetWordInputControl().GetText() == m_aPlayground->GetCurrentText() )
	{
		SpellContinue_Impl();
	}
	else
	{
		ChgHdl(pButton);
	}

	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( SvxSpellCheckDialog, SelectHdl, ListBox *, pBox )
{
	LanguageType  nSelectedLang = GetSelectedLang_Impl();

	if (&aLangLB == pBox)
	{
		BOOL bEnableThes = FALSE;
		Reference< XThesaurus > xThes( SvxGetThesaurus() );
		if (xThes.is())
			bEnableThes = xThes->hasLocale( SvxCreateLocale( nSelectedLang ) );
		aThesBtn.Enable( bEnableThes );

		Reference< XSpellAlternatives >  xAlt( WRAPPER->GetLast(), UNO_QUERY );
		if( &aLangLB == pBox && xAlt.is() )
			Audit_Impl();
	}
	else if (&aBookDLB == pBox)
	{
		sal_Bool bEnable = sal_False;
		if ( aBookDLB.GetSelectEntryPos() != LISTBOX_ENTRY_NOTFOUND )
		{
			nActDict = aBookDLB.GetSelectEntryPos();

			// Stimmt die Sprache "uberein, dann enable
			sal_uInt16 nPos = aBookDLB.GetEntry( nActDict ).nId;
            const sal_uInt16 nLang = SvxLocaleToLanguage(
                            pImpl->aDics.getConstArray()[ nPos ]->getLocale() );

            if ( nLang == nSelectedLang ||
                nLang == LANGUAGE_NONE ) // LANGUAGE_DONTKNOW
                bEnable = sal_True;
		}
		aAddBtn.Enable( bEnable );
	}

	return 0;
}

// -----------------------------------------------------------------------

sal_Bool SvxSpellCheckDialog::Close()
{
	if ( BTN_LOCK )
		return sal_False;

	BTN_LOCKING( sal_True );
	WRAPPER->SpellEnd();
	BTN_LOCKING( sal_False );
	return SfxModalDialog::Close();
}

// -----------------------------------------------------------------------

void SvxSpellCheckDialog::Audit_Impl()
{
	Reference< XSpellAlternatives >  xSpellAlt( WRAPPER->GetLast(), UNO_QUERY );

	DBG_ASSERT(xSpell.is() && xSpellAlt.is(), "unexpected behaviour");
	if (!(xSpell.is() && xSpellAlt.is()))
		return;

	// Fehlerkontext aufspannen
	SfxErrorContext aContext( ERRCTX_SVX_LINGU_SPELLING, String(), this,
							  RID_SVXERRCTX, DIALOG_MGR() );

	// Wort Direct pr"ufen
	String aTmp( m_aPlayground->GetWordInputControl().GetText() );
//	String aTmp2( U2S(xSpellAlt->getWord()) );
	String aTmp2( aOldWord );

	// Bitte warten ...
	EnterWait();

//	const sal_uInt16 nOld = xSpellAlt->getLanguage();
	const sal_uInt16 nOld = nOldLang;
	sal_uInt16 nLang = GetSelectedLang_Impl();

	// zeitweise die Sprache umschalten
	//
	FASTBOOL bAll = sal_False;
	sal_Int16	 nErr = -1;

	Reference< XSpellAlternatives >  xTmpSpellAlt;
	sal_Bool bTestOk=sal_True;
	sal_Bool bInvalidLang = sal_False;

	if ( ( nOld != nLang || aTmp != aTmp2 ) &&
		 nLang != LANGUAGE_DONTKNOW)
	{
		if (xSpell->hasLanguage( nLang ))
		{
			xTmpSpellAlt = xSpell->spell( aTmp, nLang,
										  Sequence< PropertyValue >() );
			if(!xTmpSpellAlt.is())
				bTestOk = sal_False;
		}
		else
		{
			bInvalidLang = sal_True;
		}
	}
	else
		bAll = sal_True;

	nOldLang = nLang;
	aOldWord = aTmp;

	sal_Bool bIsSpellError 	= sal_False;
	sal_Int16 nAltCount 	= 0;
	if (xTmpSpellAlt.is())
	{
		bIsSpellError = sal_True;	//xTmpSpellAlt->getFailureType() == SpellFailure::SPELLING_ERROR;
		nAltCount 	  = xTmpSpellAlt->getAlternativesCount();
	}

	if ( bAll /*|| (bIsSpellError  &&  nAltCount == 0)*/ )
	{
		// ErrorLink ausschalten
		//Link aOldLnk( pSpell->ChgErrorLink( Link() ) );

		// andere Sprachen automatisch pr"ufen
		// auch wenn beliebiger Schwachsinn rauskommt
		// NUR: wenn Sprache KEINE oder die neue die Alte ist oder die Sprache
		// nicht vorhanden ist
		sal_uInt16 nMaxAlt	  	= 0;
		sal_uInt16 nMaxAltLang	= LANGUAGE_NONE;

        Sequence< INT16 > aLang;
        if (xSpell.is())
            aLang = xSpell->getLanguages();
        sal_Int32 nLangCount = aLang.getLength();
        const INT16 *pLang = aLang.getConstArray();
        for (INT32 i = 0;  i < nLangCount;  ++i)
		{
            INT16 nNewLang = pLang[i];
			if ( xSpell->hasLanguage( nNewLang ) )
			{
				xTmpSpellAlt = xSpell->spell( aTmp, nNewLang,
											  Sequence< PropertyValue >() );

				if ( !xTmpSpellAlt.is() )	// correct spelling?
				{
					aLangLB.SelectLanguage( nNewLang );
                    break;
				}
				else if ( xTmpSpellAlt->getAlternativesCount() > nMaxAlt )
				{
					nMaxAlt = xTmpSpellAlt->getAlternativesCount();
					nMaxAltLang = nNewLang;
				}
			}
		}

		// was the spelling of the word wrong in all the languages
		// checked above?
		if ( xTmpSpellAlt.is() )
		{
			if ( nMaxAlt > 0 )
			{
				// Die Sprache mit den meisten Alternativen anzeigen
				// den richtigen Eintrag finden, da sortiert
				aLangLB.SelectLanguage( nMaxAltLang );
				LanguageType nSelLang = aLangLB.GetSelectLanguage();
				DBG_ASSERT( nSelLang != LANGUAGE_DONTKNOW,
						"correct language not found" );
				if (nSelLang != LANGUAGE_DONTKNOW)
				{
					nOldLang = nSelLang;
					xTmpSpellAlt = xSpell->spell( aTmp, nSelLang,
											  	Sequence< PropertyValue >() );
				}
			}
			//else
			//	pSpell->SetActualLanguage( nLang );
		}
		// ErrorHandler wieder installieren
		//pSpell->ChgErrorLink(aOldLnk);
	}

	// Alternativen eintragen
	aNewWordLB.Clear();
	if(xTmpSpellAlt.is())
	{
		sal_uInt16 nCount = xTmpSpellAlt->getAlternativesCount();;
		Sequence< OUString > aAlt = xTmpSpellAlt->getAlternatives();
		const OUString *pStr = aAlt.getConstArray();
		for( sal_uInt16 i=0; i < nCount; ++i )
		{
			String aTmp( pStr[i] );
			if ( LISTBOX_ENTRY_NOTFOUND == aNewWordLB.GetEntryPos( aTmp ) )
				aNewWordLB.InsertEntry( aTmp );
		}
	}
	m_aPlayground->GetWordInputControl().GrabFocus();

	if (aNewWordLB.GetEntryCount())
	{
		aNewWordLB.Enable();

		long nPos= m_aPlayground->GetWordInputControl().GetText().Len();
		Selection aSel(nPos, nPos);
		m_aPlayground->GetWordInputControl().SetSelection(aSel);	// Alles selektieren
	}

	// Status anzeigen

	if (bInvalidLang)
	{
		m_aPlayground->SetStatusText( SVX_RESSTR( RID_SVXSTR_HMSTATUS_INVALID_LANG ) );
		aStateImage.Hide();
	}
	else
	{
		String aTxt;
		aStateImage.Show();

		if(!xTmpSpellAlt.is())
		{
			aTxt = SVX_RESSTR( RID_SVXSTR_HMSTATUS_OK );
			aStateImage.SetImage(aTrueStateIm);
			m_aPlayground->UpdateChangesHelp();
		}
		else
		{
			int nRID = RID_SVXSTR_HMSTATUS_OK;
			switch (xTmpSpellAlt->getFailureType())
			{
				case SpellFailure::IS_NEGATIVE_WORD : nRID = RID_SVXSTR_HMSTATUS_DONTUSE; break;
				case SpellFailure::CAPTION_ERROR : 	 nRID = RID_SVXSTR_HMSTATUS_CAPERROR; break;
				case SpellFailure::SPELLING_ERROR :	 nRID = RID_SVXSTR_HMSTATUS_WRONG; break;
				default :
					DBG_ERROR("unexpected SpellFailure type");
			}

			aTxt = SVX_RESSTR( nRID );
			aStateImage.SetImage(aFalseStateIm);
		}
		m_aPlayground->SetStatusText( aTxt );
		UniString aStrTmp( aStateStr );
		aStrTmp.Append( aTxt );
		aStateImage.SetQuickHelpText( aStrTmp );
	}

	LeaveWait();

}

// -----------------------------------------------------------------------

String SvxSpellCheckDialog::AddPreAndPost_Impl( const String& rStr )
{
	return rStr;
}

// -----------------------------------------------------------------------

IMPL_LINK( SvxSpellCheckDialog, WordSelectHdl, ListBox *, EMPTYARG )
{
	if(aNewWordLB.GetEntryCount()>0)
	{
		String aString=aNewWordLB.GetSelectEntry();
		m_aPlayground->GetWordInputControl().SetText(aString);
		bModified=sal_False;
		SetAddBtnHelp(m_aPlayground->GetCurrentText());
		m_aPlayground->UpdateChangesHelp( aString );
		aStateImage.SetImage(aTrueStateIm);
		String aStr = aStateStr;
		aStr += SVX_RESSTR( RID_SVXSTR_HMSTATUS_OK );
		aStateImage.SetQuickHelpText(aStr);

		aStateImage.Show();

		aAutoCorrBtn.Enable( m_aPlayground->GetWordInputControl().GetText() != m_aPlayground->GetCurrentText() );
	}
	return 0;
}


// -----------------------------------------------------------------------

void SvxSpellCheckDialog::HideAutoCorrect()

/*	[Beschreibung]

	Applikationen, die keine Autokorrektur unterst"utzen,
	k"onnen mit dieser Methode diesen Eintrag aus dem Men"u entfernen
*/

{
	aAutoCorrBtn.Hide();
}

// -----------------------------------------------------------------------

void SvxSpellCheckDialog::SetSelectedLang_Impl( LanguageType nLang )
{
	aLangLB.SelectLanguage( nLang );
}

// -----------------------------------------------------------------------

LanguageType SvxSpellCheckDialog::GetSelectedLang_Impl() const
{
	INT16 nLang = aLangLB.GetSelectLanguage();
	return nLang;
}

// -----------------------------------------------------------------------

void SvxSpellCheckDialog::SetLanguage( sal_uInt16 nLang )

/*	[Beschreibung]

	wenn die Sprache im Thesaurus umgestellt wurde,
	muss auch hier die Sprache umgestellt werden.
*/

{
	String aStr( aTitel );
	aStr.Append( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( " (" ) ) );
	aStr.Append( ::GetLanguageString( (LanguageType)nLang ) );
	aStr.Append( sal_Unicode( ')' ) );;
	SetText( aStr );

	// den richtigen Eintrag finden, da sortiert
	aLangLB.SelectLanguage( nLang );
}

// -----------------------------------------------------------------------

IMPL_LINK(SvxSpellCheckDialog, DirectionHdl, CheckBox*, pBox)
{
	Reference< XPropertySet >  xProp( SvxGetLinguPropertySet() );
	if (xProp.is())
	{
		BOOL bVal = pBox->IsChecked();
		Any aBool(&bVal, ::getBooleanCppuType());
		xProp->setPropertyValue( C2U(UPN_IS_WRAP_REVERSE), aBool );
	}
	return 0;
};

void SvxSpellCheckDialog::SetAddBtnHelp(const String& rString)
{
	String aString = GetNonMnemonicString( aAddBtn.GetText() );
	aString.Append( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( ": " ) ) );
	aString.Append( rString );
	aAddBtn.SetQuickHelpText(aString);
}

void SvxSpellCheckDialog::InitUserDicts()
{
	sal_uInt16 nLang = aLangLB.GetSelectLanguage();

	const Reference< XDictionary >  *pDic = 0;

    // get list of dictionaries
    Reference< XDictionaryList >  xDicList( SvxGetDictionaryList() );
    if (xDicList.is())
    {
        // add active, positive dictionary to dic-list (if not already done).
        // This is to ensure that there is at least on dictionary to which
        // words could be added.
        Reference< XDictionary1 >  xDic( SvxGetOrCreatePosDic( xDicList ) );
        if (xDic.is())
            xDic->setActive( sal_True );

        pImpl->aDics = xDicList->getDictionaries();
    }

    // Benutzerbuecher anzeigen
    const sal_Int32 nSize = pImpl->aDics.getLength();
    pDic = pImpl->aDics.getConstArray();
    sal_Int32 i;
    for (i = 0; i < nSize; ++i )
    {
        Reference< XDictionary1 >  xDic( pDic[i], UNO_QUERY );
        if (!xDic.is() || SvxGetIgnoreAllList() == xDic)
            continue;

        // add only active and not read-only dictionaries to list
        // from which to choose from
        Reference< frame::XStorable > xStor( xDic, UNO_QUERY );
        if ( xDic->isActive()  &&  (!xStor.is() || !xStor->isReadonly()) )
        {
            sal_Bool bNegativ = xDic->getDictionaryType() == DictionaryType_NEGATIVE;
            aBookDLB.InsertEntry( SvxBoxEntry(
                ::GetDicInfoStr( xDic->getName(),
                                xDic->getLanguage(), bNegativ ), i ) );
        }
    }

	aAddBtn.Disable();

    sal_uInt16 k;
    for ( k = 0; k < aBookDLB.GetEntryCount(); ++k )
	{
        sal_uInt16 nId = aBookDLB.GetEntry(k).nId;
		sal_Bool bFound = sal_False;

        const sal_uInt16 nDicLang  = SvxLocaleToLanguage( pDic[nId]->getLocale() );
        const sal_Bool bDicNegativ =
            pDic[nId]->getDictionaryType() == DictionaryType_NEGATIVE;
        // Stimmt die Sprache "uberein, dann enable
        if ((nDicLang == nLang || nDicLang == LANGUAGE_NONE) && !bDicNegativ)
            bFound = sal_True;

		if (bFound)
		{
            aBookDLB.SelectEntryPos(k);
			aAddBtn.Enable();
			break;
		}
	}
}

IMPL_LINK(SvxSpellCheckDialog, ModifyHdl, Edit *, pEd)
{
	if (&m_aPlayground->GetWordInputControl() == pEd)
	{
		bModified=sal_True;
		aStateImage.Hide();
		m_aPlayground->SetStatusText( String() );
		aNewWordLB.SetNoSelection();
        aNewWordLB.Disable();
		aTestBtn.Enable();
		String sNewText( m_aPlayground->GetWordInputControl().GetText() );
		SetAddBtnHelp( sNewText );
		m_aPlayground->UpdateChangesHelp( );

		aAutoCorrBtn.Enable( sNewText != m_aPlayground->GetCurrentText() );
	}
	return 0;
};

IMPL_LINK(SvxSpellCheckDialog, AuditHdl, Button *, pButton )
{
	if(pButton!=NULL)
	{
		Audit_Impl();

		// ggf. wurde die aktuelle Sprache ge"andert,
		// dann mu/s vielleicht ein anderes W"orterbuch selektiert werden
		sal_uInt16 nLang = aLangLB.GetSelectLanguage();
		aAddBtn.Disable();

		for ( sal_uInt16 i = 0; i < aBookDLB.GetEntryCount(); ++i )
		{
			sal_uInt16 nDicPos = aBookDLB.GetEntry(i).nId;
			const sal_uInt16 nDicLang = SvxLocaleToLanguage(
					pImpl->aDics.getConstArray()[ nDicPos ]->getLocale() );

			// Stimmt die Sprache "uberein, dann enable
			if ( nDicLang == nLang || nDicLang == LANGUAGE_NONE )
			{
				// den ersten selektieren
				aBookDLB.SelectEntryPos(i);
				aAddBtn.Enable();
				break;
			}
		}
	}
	return 0;
};

IMPL_LINK(SvxSpellCheckDialog, CancelHdl, Button *, pButton )
{
	Close();
	return 0;
}

IMPL_LINK( SvxSpellCheckDialog, ClickHdl, Control*, pCtr )
{
	if(pCtr!=NULL)
	{
		bModified=sal_True;
		m_aPlayground->GetWordInputControl().SetText(pCtr->GetText());
		aStateImage.SetImage(aFalseStateIm);
		aStateImage.Show();
		String aStr = aStateStr;
		aStr += SVX_RESSTR( RID_SVXSTR_HMSTATUS_WRONG );
		aStateImage.SetQuickHelpText(aStr);

		SetAddBtnHelp(pCtr->GetText());
		m_aPlayground->UpdateChangesHelp( );
		m_aPlayground->GetWordInputControl().GrabFocus();
		long nPos= m_aPlayground->GetWordInputControl().GetText().Len();
		Selection aSel(0, nPos);
		m_aPlayground->GetWordInputControl().SetSelection(aSel);

//        aNewWordLB.SetNoSelection();
//        aNewWordLB.Disable();

		aAutoCorrBtn.Enable( m_aPlayground->GetWordInputControl().GetText() != m_aPlayground->GetCurrentText() );
	}
	return 0;
};

IMPL_LINK(SvxSpellCheckDialog, ErrorHdl, void*, pDontKnow)
{
	aStateImage.SetImage(aFalseStateIm);
	aStateImage.Show();
	String aStr = aStateStr;
	aStr += SVX_RESSTR( RID_SVXSTR_HMSTATUS_WRONG );
	aStateImage.SetQuickHelpText(aStr);

	m_aPlayground->SetStatusText(aErrorStr);
	return 0;
};


