/*************************************************************************
 *
 *  $RCSfile: svxifact.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:01:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SFXMSG_HXX //autogen
#include <sfx2/msg.hxx>
#endif

#ifndef _SFX_CONST_HXX //autogen
#include <sfx2/const.hxx>
#endif
#ifndef _SFX_SHELL_HXX //autogen
#include <sfx2/shell.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <sfx2/app.hxx>
#endif
#ifndef __SBX_SBX_FACTORY_HXX //autogen
#include <svtools/sbxfac.hxx>
#endif
#pragma hdrstop

#define ITEMID_TABSTOP 0
#define _SVX_SVXIFACT_CXX

#define SearchSettings
#define SvxChartStyle
#include "svxslots.hxx"
#include "chrtitem.hxx"

#include "svxifact.hxx"
#include "isbxobj.hxx"
#include "boxobj.hxx"

// -----------------------------------------------------------------------

const SfxConstant __FAR_DATA aConstants[] =
{
	SFX_USHORT_CONSTANT( "2DArea",              CHSTYLE_2D_AREA ),
	SFX_USHORT_CONSTANT( "2DBar",               CHSTYLE_2D_BAR ),
	SFX_USHORT_CONSTANT( "2DColumn",            CHSTYLE_2D_COLUMN ),
	SFX_USHORT_CONSTANT( "2DLine",              CHSTYLE_2D_LINE ),
	SFX_USHORT_CONSTANT( "2DLineSymbols",       CHSTYLE_2D_LINESYMBOLS ),
	SFX_USHORT_CONSTANT( "2DPercentArea",       CHSTYLE_2D_PERCENTAREA ),
	SFX_USHORT_CONSTANT( "2DPercentBar",        CHSTYLE_2D_PERCENTBAR ),
	SFX_USHORT_CONSTANT( "2DPercentColumn",     CHSTYLE_2D_PERCENTCOLUMN ),
	SFX_USHORT_CONSTANT( "2DPercentLine",       CHSTYLE_2D_PERCENTLINE ),
	SFX_USHORT_CONSTANT( "2DPercentLineSymbols",CHSTYLE_2D_PERCENTLINESYM ),
	SFX_USHORT_CONSTANT( "2DPie",               CHSTYLE_2D_PIE ),
	SFX_USHORT_CONSTANT( "2DStackedArea",       CHSTYLE_2D_STACKEDAREA ),
	SFX_USHORT_CONSTANT( "2DStackedBar",        CHSTYLE_2D_STACKEDBAR ),
	SFX_USHORT_CONSTANT( "2DStackedColumn",     CHSTYLE_2D_STACKEDCOLUMN ),
	SFX_USHORT_CONSTANT( "2DStackedLine",       CHSTYLE_2D_STACKEDLINE ),
	SFX_USHORT_CONSTANT( "2DStackedLineSymbols",CHSTYLE_2D_STACKEDLINESYM ),
	SFX_USHORT_CONSTANT( "2DXY",                CHSTYLE_2D_XY ),
	SFX_USHORT_CONSTANT( "2DXYSymbols",         CHSTYLE_2D_XYSYMBOLS ),
	SFX_USHORT_CONSTANT( "3DArea",              CHSTYLE_3D_AREA ),
	SFX_USHORT_CONSTANT( "3DColumn",            CHSTYLE_3D_COLUMN ),
	SFX_USHORT_CONSTANT( "3DFlatColumn",        CHSTYLE_3D_FLATCOLUMN ),
	SFX_USHORT_CONSTANT( "3DPercentArea",       CHSTYLE_3D_PERCENTAREA ),
	SFX_USHORT_CONSTANT( "3DPercentFlatColumn", CHSTYLE_3D_PERCENTFLATCOLUMN ),
	SFX_USHORT_CONSTANT( "3DPie",               CHSTYLE_3D_PIE ),
	SFX_USHORT_CONSTANT( "3DStackedArea",       CHSTYLE_3D_STACKEDAREA ),
	SFX_USHORT_CONSTANT( "3DStackedFlatColumn", CHSTYLE_3D_STACKEDFLATCOLUMN ),
	SFX_USHORT_CONSTANT( "3DStripe",            CHSTYLE_3D_STRIPE ),
	SFX_USHORT_CONSTANT( "3DSurface",           CHSTYLE_3D_SURFACE ),
	SFX_USHORT_CONSTANT( "3DXYZ",               CHSTYLE_3D_XYZ ),
	SFX_USHORT_CONSTANT( "3DXYZSymbols",        CHSTYLE_3D_XYZSYMBOLS ),
	SFX_USHORT_CONSTANT( "BlackBoldLine",      10 ),
	SFX_USHORT_CONSTANT( "BlackLine",           4 ),
	SFX_USHORT_CONSTANT( "BoldBlackLine",      11 ),
	SFX_USHORT_CONSTANT( "BoldLine",            3 ),
	SFX_USHORT_CONSTANT( "BoldMediumLine",      8 ),
	SFX_USHORT_CONSTANT( "DoubleBoldLine",      7 ),
	SFX_USHORT_CONSTANT( "DoubleMediumLine",    6 ),
	SFX_USHORT_CONSTANT( "DoubleThinLine",      5 ),
	SFX_USHORT_CONSTANT( "MediumBoldLine",      9 ),
	SFX_USHORT_CONSTANT( "MediumLine",          2 ),
	SFX_USHORT_CONSTANT( "NoLine",              0 ),
	SFX_USHORT_CONSTANT( "ThinLine",            1 )
};


//=========================================================================

class SvxItemFactory_Impl: public SbxFactory

/*	[Beschreibung]

	Imp-Struktur f"ur SvxItemFactory und Subklasse von SbxFactory, um
	SbxObjects zu erzeugen, die von den Svx-Items verwendet werden. Dies
	ist i.d.R. im Record/Construct-Bereich der Fall.
*/

{
public:
	virtual SbxObject* CreateObject( const String& );
};

// -----------------------------------------------------------------------


SbxObject* SvxItemFactory_Impl::CreateObject( const String &rType )

/*	[Beschreibung]

	"Uberladung der virtuellen Methode von SbxFactory, um SbxObjects
	zu erzeugen, die von den Svx-Items verwendet werden. Dies ist i.d.R.
	im Record/Construct-Bereich der Fall.
*/

{
//	if ( rType.EqualsAscii( "TabStops" ) )
//		return new SvxTabStopObject_Impl;
	if ( rType.EqualsAscii( "SearchSettings" ) )
		return new SfxShellSubObject( 0, 
		SFX_TYPELIB_INFO(SearchSettings), 
		String("SearchSettings", 14, gsl_getSystemTextEncoding()));
	if ( rType.EqualsAscii( "Border" ) )
		return new SvxBoxObject( 0 );
	return 0;
}

// =======================================================================


SvxItemFactory::SvxItemFactory()

/*	[Beschreibung]

	Dieser Ctor mu\s von den Applikationen genau einmal gerufen werden und
	sp"atestens, wenn das BASIC initialisiert wird bzw. bevor es verwendet
	werden kann. Z.B. kann man ein Stack-Objekt um Application::Execute()
	anlegen, oder sobald <SfxApplication::GetSbxObject()> gerufen wird. In
	letzterem Fall wird es beim Programmende zerst"ort.
*/

:	pImp( new SvxItemFactory_Impl )
{
	SbxBase::AddFactory( pImp );
	SFX_APP()->RegisterBasicConstants( "so", aConstants, sizeof(aConstants)/sizeof(SfxConstant) );
}

// -----------------------------------------------------------------------


SvxItemFactory::~SvxItemFactory()

/*	[Beschreibung]

	Dieser Ctor mu\s von den Applikationen genau einmal gerufen werden und
	fr"uhestens, wenn das BASIC nicht mehr ben"otigt wird.
*/

{
	SbxBase::RemoveFactory( pImp );
	delete pImp;
}


